/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;

public class SingletonPolicyServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
SingletonPolicy {
    private final SupplierDependency<SingletonElectionPolicy> policy;
    private volatile SupplierDependency<SingletonServiceBuilderFactory> factory;
    private volatile int quorum;

    public SingletonPolicyServiceConfigurator(PathAddress address) {
        super((Capability)SingletonPolicyResourceDefinition.Capability.POLICY, address);
        this.policy = new ServiceSupplierDependency(ElectionPolicyResourceDefinition.Capability.ELECTION_POLICY.getServiceName(address.append(new PathElement[]{ElectionPolicyResourceDefinition.WILDCARD_PATH})));
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer policy = new CompositeDependency(new Dependency[]{this.policy, this.factory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)policy, (Object)((Object)this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String containerName = SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        String cacheName = SingletonPolicyResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.factory = new ServiceSupplierDependency(ClusteringCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY.getServiceName(context, containerName, cacheName));
        this.quorum = SingletonPolicyResourceDefinition.Attribute.QUORUM.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return this;
    }

    public ServiceConfigurator createSingletonServiceConfigurator(ServiceName name) {
        return ((SingletonServiceBuilderFactory)this.factory.get()).createSingletonServiceConfigurator(name).electionPolicy((SingletonElectionPolicy)this.policy.get()).requireQuorum(this.quorum);
    }

    public <T> Builder<T> createSingletonServiceBuilder(ServiceName name, org.jboss.msc.service.Service<T> service) {
        return ((SingletonServiceBuilderFactory)this.factory.get()).createSingletonServiceBuilder(name, service).electionPolicy((SingletonElectionPolicy)this.policy.get()).requireQuorum(this.quorum);
    }

    public <T> Builder<T> createSingletonServiceBuilder(ServiceName name, org.jboss.msc.service.Service<T> primaryService, org.jboss.msc.service.Service<T> backupService) {
        return ((SingletonServiceBuilderFactory)this.factory.get()).createSingletonServiceBuilder(name, primaryService, backupService).electionPolicy((SingletonElectionPolicy)this.policy.get()).requireQuorum(this.quorum);
    }

    public String toString() {
        return this.getServiceName().getSimpleName();
    }
}

