/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FilterCodeWriter;
import com.sun.istack.tools.DefaultAuthenticator;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Messages;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.SecureLoader;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.reader.Util;
import com.sun.tools.xjc.util.ForkEntityResolver;
import com.sun.xml.bind.v2.util.EditDistance;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.XMLCatalog;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XJCBase
extends MatchingTask {
    private Path modulepath = null;
    private Path upgrademodulepath = null;
    private String addmodules = null;
    private String limitmodules = null;
    private String addreads = null;
    private String addexports = null;
    private String patchmodule = null;
    private String addopens = null;
    public final Options options = new Options();
    private long stackSize = -1L;
    private boolean failonerror = true;
    private final ArrayList<File> bindingFiles = new ArrayList();
    private final ArrayList<File> schemaFiles = new ArrayList();
    private boolean removeOldOutput = false;
    private final ArrayList<File> dependsSet = new ArrayList();
    private final ArrayList<File> producesSet = new ArrayList();
    private boolean producesSpecified = false;
    private final Path classpath;
    private final Commandline cmdLine = new Commandline();
    private XMLCatalog xmlCatalog = null;
    private boolean fork = false;
    private final CommandlineJava cmd = new CommandlineJava();
    private File catalog;
    private boolean extension = false;
    private String specTarget;

    public XJCBase() {
        this.classpath = new Path(null);
        this.options.setSchemaLanguage(Language.XMLSCHEMA);
    }

    public void setModulepath(Path mp) {
        this.modulepath = mp;
    }

    public Path getModulepath() {
        return this.modulepath;
    }

    public void setUpgrademodulepath(Path ump) {
        this.upgrademodulepath = ump;
    }

    public Path getUpgrademodulepath() {
        return this.upgrademodulepath;
    }

    public void setAddmodules(String ams) {
        this.addmodules = ams;
    }

    public String getAddmodules() {
        return this.addmodules;
    }

    public void setLimitmodules(String lms) {
        this.limitmodules = lms;
    }

    public String getLimitmodules() {
        return this.limitmodules;
    }

    public void setAddreads(String ars) {
        this.addreads = ars;
    }

    public String getAddreads() {
        return this.addreads;
    }

    public void setAddexports(String aes) {
        this.addexports = aes;
    }

    public String getAddexports() {
        return this.addexports;
    }

    public void setPatchmodule(String pms) {
        this.patchmodule = pms;
    }

    public String getPatchmodule() {
        return this.patchmodule;
    }

    public void setAddopens(String aos) {
        this.addopens = aos;
    }

    public String getAddopens() {
        return this.addopens;
    }

    CommandlineJava getCommandline() {
        return this.cmd;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setSchema(String schema) {
        File f;
        try {
            f = new File(schema);
            this.options.addGrammar(this.getInputSource(new URL(schema)));
        }
        catch (MalformedURLException e) {
            f = this.getProject().resolveFile(schema);
            this.options.addGrammar(f);
            this.dependsSet.add(f);
        }
        this.schemaFiles.add(f);
    }

    public void addConfiguredSchema(FileSet fs) {
        for (InputSource value : this.toInputSources(fs)) {
            this.options.addGrammar(value);
        }
        this.addIndividualFilesTo(fs, this.dependsSet);
        this.addIndividualFilesTo(fs, this.schemaFiles);
    }

    public void setClasspath(Path cp) {
        this.classpath.createPath().append(cp);
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.classpath.createPath().setRefid(r);
    }

    public void setLanguage(String language) {
        Language l = Language.valueOf(language.toUpperCase());
        if (l == null) {
            Language[] languages = Language.values();
            String[] candidates = new String[languages.length];
            for (int i = 0; i < candidates.length; ++i) {
                candidates[i] = languages[i].name();
            }
            throw new BuildException("Unrecognized language: " + language + ". Did you mean " + EditDistance.findNearest(language.toUpperCase(), candidates) + " ?");
        }
        this.options.setSchemaLanguage(l);
    }

    public void setBinding(String binding) {
        try {
            File f = new File(binding);
            this.bindingFiles.add(f);
            this.options.addBindFile(this.getInputSource(new URL(binding)));
        }
        catch (MalformedURLException e) {
            File f = this.getProject().resolveFile(binding);
            this.options.addBindFile(f);
            this.dependsSet.add(f);
        }
    }

    public void addConfiguredBinding(FileSet fs) {
        for (InputSource is : this.toInputSources(fs)) {
            this.options.addBindFile(is);
        }
        this.addIndividualFilesTo(fs, this.dependsSet);
        this.addIndividualFilesTo(fs, this.bindingFiles);
    }

    public void setPackage(String pkg) {
        this.options.defaultPackage = pkg;
    }

    public String getPackage() {
        return this.options.defaultPackage;
    }

    public void setCatalog(File catalog) {
        try {
            this.options.addCatalog(catalog);
            this.catalog = catalog;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getCatalog() {
        return this.catalog;
    }

    public void setFailonerror(boolean value) {
        this.failonerror = value;
    }

    public void setStackSize(String ss) {
        try {
            this.stackSize = Long.parseLong(ss);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (ss.length() > 2) {
                String head = ss.substring(0, ss.length() - 2);
                String tail = ss.substring(ss.length() - 2);
                if (tail.equalsIgnoreCase("kb")) {
                    try {
                        this.stackSize = Long.parseLong(head) * 1024L;
                        return;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
                if (tail.equalsIgnoreCase("mb")) {
                    try {
                        this.stackSize = Long.parseLong(head) * 1024L * 1024L;
                        return;
                    }
                    catch (NumberFormatException numberFormatException3) {
                        // empty catch block
                    }
                }
            }
            throw new BuildException("Unrecognizable stack size: " + ss);
        }
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void setReadonly(boolean flg) {
        this.options.readOnly = flg;
    }

    public boolean getReadOnly() {
        return this.options.readOnly;
    }

    public void setHeader(boolean flg) {
        this.options.noFileHeader = !flg;
    }

    public boolean getHeader() {
        return this.options.noFileHeader;
    }

    public void setXexplicitAnnotation(boolean flg) {
        this.options.runtime14 = flg;
    }

    public void setExtension(boolean flg) {
        this.extension = flg;
        this.options.compatibilityMode = flg ? 2 : 1;
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setTarget(String version) {
        this.options.target = SpecVersion.parse(version);
        if (this.options.target == null) {
            throw new BuildException(version + " is not a valid version number. Perhaps you meant @destdir?");
        }
        this.specTarget = this.options.target.getVersion();
    }

    public String getSpecTarget() {
        return this.specTarget;
    }

    public boolean getVerbose() {
        return this.options.verbose;
    }

    public void setDestdir(File dir) {
        this.options.targetDir = dir;
    }

    public File getDestdir() {
        return this.options.targetDir;
    }

    public void setEncoding(String encoding) {
        this.options.encoding = encoding;
    }

    public String getEncoding() {
        return this.options.encoding;
    }

    public void addConfiguredDepends(FileSet fs) {
        this.addIndividualFilesTo(fs, this.dependsSet);
    }

    public void addConfiguredProduces(FileSet fs) {
        this.producesSpecified = true;
        if (!fs.getDir(this.getProject()).exists()) {
            this.log(fs.getDir(this.getProject()).getAbsolutePath() + " is not found and thus excluded from the dependency check", 2);
        } else {
            this.addIndividualFilesTo(fs, this.producesSet);
        }
    }

    public void setRemoveOldOutput(boolean roo) {
        this.removeOldOutput = roo;
    }

    public boolean getRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public Commandline.Argument createArg() {
        return this.cmdLine.createArgument();
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    protected CommandlineJava setupCommand() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.getCommandline().createArgument().setValue("-d");
            this.getCommandline().createArgument().setFile(this.getDestdir());
        }
        if (null != this.getPackage() && !this.getPackage().equals("")) {
            this.getCommandline().createArgument().setValue("-p");
            this.getCommandline().createArgument().setValue(this.getPackage());
        }
        if (this.getExtension()) {
            this.getCommandline().createArgument().setValue("-extension");
        }
        if (this.getEncoding() != null) {
            this.getCommandline().createArgument().setValue("-encoding");
            this.getCommandline().createArgument().setValue(this.getEncoding());
        }
        if (this.getReadOnly()) {
            this.getCommandline().createArgument().setValue("-readOnly");
        }
        if (this.getHeader()) {
            this.getCommandline().createArgument().setValue("-no-header");
        }
        if (this.getRemoveOldOutput()) {
            this.getCommandline().createArgument().setValue("-removeOldOutput");
        }
        if (this.getSpecTarget() != null) {
            this.getCommandline().createArgument().setValue("-target");
            this.getCommandline().createArgument().setValue(this.getSpecTarget());
        }
        if (this.getVerbose()) {
            this.getCommandline().createArgument().setValue("-verbose");
        }
        if (this.getCatalog() != null && this.getCatalog().getName().length() > 0) {
            this.getCommandline().createArgument().setValue("-catalog");
            this.getCommandline().createArgument().setFile(this.getCatalog());
        }
        for (String a : this.cmdLine.getArguments()) {
            this.getCommandline().createArgument().setValue(a);
        }
        this.addFilesToCommandLine(this.schemaFiles, null);
        this.addFilesToCommandLine(this.bindingFiles, "-b");
        return this.getCommandline();
    }

    void addFilesToCommandLine(ArrayList<File> files, String option) {
        if (!files.isEmpty()) {
            for (File file : files) {
                if (option != null && option.length() > 0) {
                    this.getCommandline().createArgument().setValue(option);
                }
                boolean isLink = false;
                try {
                    isLink = !file.getCanonicalPath().equals(file.getAbsolutePath()) && (!file.getAbsolutePath().contains("~1") || file.getCanonicalPath().indexOf(32) < 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (isLink) {
                    this.getCommandline().createArgument().setValue(file.toURI().toString());
                    continue;
                }
                this.getCommandline().createArgument().setFile(file);
            }
        }
    }

    void setupForkCommand(String className) {
        ClassLoader loader;
        for (loader = ((Object)((Object)this)).getClass().getClassLoader(); loader != null && !(loader instanceof AntClassLoader); loader = loader.getParent()) {
        }
        String antcp = loader != null ? ((AntClassLoader)loader).getClasspath() : System.getProperty("java.class.path");
        File jreHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
        if (toolsJar.exists()) {
            antcp = antcp + File.pathSeparatorChar + toolsJar.getAbsolutePath();
        }
        this.getCommandline().createClasspath(this.getProject()).append(new Path(this.getProject(), antcp));
        this.getCommandline().setClassname(className);
    }

    public void execute() throws BuildException {
        block16: {
            this.log("build id of XJC is " + Driver.getBuildID(), 3);
            this.classpath.setProject(this.getProject());
            long srcTime = this.computeTimestampFor(this.dependsSet, true);
            long dstTime = this.computeTimestampFor(this.producesSet, false);
            this.log("the last modified time of the inputs is  " + srcTime, 3);
            this.log("the last modified time of the outputs is " + dstTime, 3);
            if (srcTime < dstTime) {
                this.log("files are up to date");
                return;
            }
            try {
                if (this.getFork()) {
                    this.setupCommand();
                    this.setupForkCommand("com.sun.tools.xjc.XJCFacade");
                    int status = this.run(this.getCommandline().getCommandline());
                    if (status != 0) {
                        this.log("Command invoked: xjc" + this.getCommandline().toString());
                        throw new BuildException("xjc failed", this.getLocation());
                    }
                    break block16;
                }
                if (this.getCommandline().getVmCommand().size() > 1) {
                    this.log("JVM args ignored when same JVM is used.", 1);
                }
                if (this.stackSize == -1L) {
                    this.doXJC();
                    break block16;
                }
                try {
                    Thread t;
                    final Throwable[] e = new Throwable[1];
                    Runnable job = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                XJCBase.this.doXJC();
                            }
                            catch (Throwable be) {
                                e[0] = be;
                            }
                        }
                    };
                    try {
                        Constructor c = Thread.class.getConstructor(ThreadGroup.class, Runnable.class, String.class, Long.TYPE);
                        t = (Thread)c.newInstance(Thread.currentThread().getThreadGroup(), job, Thread.currentThread().getName() + ":XJC", this.stackSize);
                    }
                    catch (Throwable err) {
                        this.log("Unable to set the stack size. Use JDK1.4 or above", 1);
                        this.doXJC();
                        return;
                    }
                    t.start();
                    t.join();
                    if (e[0] instanceof Error) {
                        throw (Error)e[0];
                    }
                    if (e[0] instanceof RuntimeException) {
                        throw (RuntimeException)e[0];
                    }
                    if (e[0] instanceof BuildException) {
                        throw (BuildException)e[0];
                    }
                    if (e[0] != null) {
                        throw new BuildException(e[0]);
                    }
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (BuildException e) {
                this.log("failure in the XJC task. Use the Ant -verbose switch for more details");
                if (this.failonerror) {
                    throw e;
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.getProject().log(sw.toString(), 1);
            }
        }
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.getProject());
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doXJC() throws BuildException {
        ClassLoader old = SecureLoader.getContextClassLoader();
        AntClassLoader acl = null;
        try {
            if (this.classpath != null) {
                for (String pathElement : this.classpath.list()) {
                    try {
                        this.options.classpaths.add(new File(pathElement).toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        this.log("Classpath for XJC task not setup properly: " + pathElement);
                    }
                }
            }
            acl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath, false);
            SecureLoader.setContextClassLoader((ClassLoader)acl);
            this._doXJC();
        }
        finally {
            SecureLoader.setContextClassLoader(old);
            if (acl != null) {
                acl.cleanup();
            }
            if (this.options.proxyAuth != null) {
                DefaultAuthenticator.reset();
            }
        }
    }

    private void _doXJC() throws BuildException {
        ErrorReceiverImpl errorReceiver;
        Model model;
        try {
            this.options.parseArguments(this.cmdLine.getArguments());
        }
        catch (BadCommandLineException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        if (this.xmlCatalog != null) {
            this.options.entityResolver = this.options.entityResolver == null ? this.xmlCatalog : new ForkEntityResolver(this.options.entityResolver, (EntityResolver)this.xmlCatalog);
        }
        if (!this.producesSpecified) {
            this.log("Consider using <depends>/<produces> so that XJC won't do unnecessary compilation", 2);
        }
        InputSource[] grammars = this.options.getGrammars();
        String msg = "Compiling " + grammars[0].getSystemId();
        if (grammars.length > 1) {
            msg = msg + " and others";
        }
        this.log(msg, 2);
        if (this.removeOldOutput) {
            this.log("removing old output files", 2);
            for (File f : this.producesSet) {
                f.delete();
            }
        }
        if ((model = ModelLoader.load(this.options, new JCodeModel(), errorReceiver = new ErrorReceiverImpl())) == null) {
            throw new BuildException("unable to parse the schema. Error messages should have been provided");
        }
        try {
            if (model.generateCode(this.options, errorReceiver) == null) {
                throw new BuildException("failed to compile a schema");
            }
            this.log("Writing output to " + this.options.targetDir, 2);
            model.codeModel.build((CodeWriter)new AntProgressCodeWriter(this.options.createCodeWriter()));
        }
        catch (IOException e) {
            throw new BuildException("unable to write files: " + e.getMessage(), (Throwable)e);
        }
    }

    private long computeTimestampFor(List<File> files, boolean findNewest) {
        long lastModified = findNewest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (File file : files) {
            this.log("Checking timestamp of " + file.toString(), 3);
            if (findNewest) {
                lastModified = Math.max(lastModified, file.lastModified());
                continue;
            }
            lastModified = Math.min(lastModified, file.lastModified());
        }
        if (lastModified == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (lastModified == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return lastModified;
    }

    private void addIndividualFilesTo(FileSet fs, List<File> lst) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            lst.add(new File(baseDir, value));
        }
    }

    private InputSource[] toInputSources(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        ArrayList<InputSource> lst = new ArrayList<InputSource>();
        for (String value : includedFiles) {
            lst.add(this.getInputSource(new File(baseDir, value)));
        }
        return lst.toArray(new InputSource[lst.size()]);
    }

    private InputSource getInputSource(File f) {
        try {
            return new InputSource(f.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            return new InputSource(f.getPath());
        }
    }

    private InputSource getInputSource(URL url) {
        return Util.getInputSource(url.toExternalForm());
    }

    private class ErrorReceiverImpl
    extends ErrorReceiver {
        private ErrorReceiverImpl() {
        }

        @Override
        public void warning(SAXParseException e) {
            this.print(1, "Driver.WarningMessage", e);
        }

        @Override
        public void error(SAXParseException e) {
            this.print(0, "Driver.ErrorMessage", e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.print(0, "Driver.ErrorMessage", e);
        }

        @Override
        public void info(SAXParseException e) {
            this.print(3, "Driver.InfoMessage", e);
        }

        private void print(int logLevel, String header, SAXParseException e) {
            XJCBase.this.log(Messages.format(header, e.getMessage()), logLevel);
            XJCBase.this.log(this.getLocationString(e), logLevel);
            XJCBase.this.log("", logLevel);
        }
    }

    private class AntProgressCodeWriter
    extends FilterCodeWriter {
        public AntProgressCodeWriter(CodeWriter output) {
            super(output);
        }

        public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
            if (pkg == null || pkg.isUnnamed()) {
                XJCBase.this.log("generating " + fileName, 3);
            } else {
                XJCBase.this.log("generating " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName, 3);
            }
            return super.openBinary(pkg, fileName);
        }
    }
}

