/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.push.WebsocketChannelManager;
import com.sun.faces.push.WebsocketFacesListener;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIWebsocket;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class WebsocketRenderer
extends HtmlBasicRenderer
implements ComponentSystemEventListener {
    public static final String RENDERER_TYPE = "javax.faces.Websocket";
    private static final String SCRIPT_INIT = "mojarra.l(function(){jsf.push.init('%s','%s','%s',%s,%s,%s);});";

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        WebsocketFacesListener.subscribeIfNecessary(event.getFacesContext());
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIWebsocket websocket = (UIWebsocket)component;
        if (WebsocketFacesListener.isNew(context, websocket)) {
            WebsocketChannelManager websocketChannelManager = CdiUtils.getBeanReference(WebsocketChannelManager.class, new Annotation[0]);
            String clientId = websocket.getClientId(context);
            String channel = websocket.getChannel();
            String url = websocketChannelManager.register(context, channel, websocket.getScope(), websocket.getUser());
            String functions = websocket.getOnopen() + "," + websocket.getOnmessage() + "," + websocket.getOnclose();
            String behaviors = WebsocketRenderer.getBehaviorScripts(context, websocket);
            boolean connected = websocket.isConnected();
            RenderKitUtils.renderJsfJsIfNecessary(context);
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.write(String.format(SCRIPT_INIT, clientId, url, channel, functions, behaviors, connected));
            writer.endElement("script");
        }
    }

    private static String getBehaviorScripts(FacesContext context, UIWebsocket websocket) {
        Map clientBehaviorsByEvent = websocket.getClientBehaviors();
        if (clientBehaviorsByEvent.isEmpty()) {
            return "{}";
        }
        String clientId = websocket.getClientId(context);
        StringBuilder scripts = new StringBuilder("{");
        for (Map.Entry entry : clientBehaviorsByEvent.entrySet()) {
            String event = (String)entry.getKey();
            List clientBehaviors = (List)entry.getValue();
            scripts.append(scripts.length() > 1 ? "," : "").append(event).append(":[");
            for (int i = 0; i < clientBehaviors.size(); ++i) {
                scripts.append(i > 0 ? "," : "").append("function(event){");
                scripts.append(((ClientBehavior)clientBehaviors.get(i)).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)websocket, (String)event, (String)clientId, null)));
                scripts.append("}");
            }
            scripts.append("]");
        }
        return scripts.append("}").toString();
    }
}

