/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import javax.management.ObjectName;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public final class ObjectNameBuilder {
    public static final ObjectNameBuilder DEFAULT = new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), "localhost", true);
    private final String domain;
    private String brokerName;
    private final boolean jmxUseBrokerName;

    public static ObjectNameBuilder create(String domain) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), null, false);
        }
        return new ObjectNameBuilder(domain, null, false);
    }

    public static ObjectNameBuilder create(String domain, String brokerName) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), brokerName, true);
        }
        return new ObjectNameBuilder(domain, brokerName, true);
    }

    public static ObjectNameBuilder create(String domain, String brokerName, boolean jmxUseBrokerName) {
        if (domain == null) {
            return new ObjectNameBuilder(ActiveMQDefaultConfiguration.getDefaultJmxDomain(), brokerName, jmxUseBrokerName);
        }
        return new ObjectNameBuilder(domain, brokerName, jmxUseBrokerName);
    }

    private ObjectNameBuilder(String domain, String brokerName, boolean jmxUseBrokerName) {
        this.domain = domain;
        this.brokerName = brokerName;
        this.jmxUseBrokerName = jmxUseBrokerName;
    }

    public ObjectName getActiveMQServerObjectName() throws Exception {
        return ObjectName.getInstance(this.domain + ":" + this.getBrokerProperties());
    }

    public ObjectName getAddressObjectName(SimpleString address) throws Exception {
        return ObjectName.getInstance(String.format("%s:broker=%s,component=addresses,address=%s", this.domain, ObjectName.quote(this.brokerName), ObjectName.quote(address.toString())));
    }

    public ObjectName getQueueObjectName(SimpleString address, SimpleString name, RoutingType routingType) throws Exception {
        return ObjectName.getInstance(String.format("%s:broker=%s,component=addresses,address=%s,subcomponent=queues,routing-type=%s,queue=%s", this.domain, ObjectName.quote(this.brokerName), ObjectName.quote(address.toString()), ObjectName.quote(routingType.toString().toLowerCase()), ObjectName.quote(name.toString())));
    }

    public ObjectName getDivertObjectName(String name, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s:broker=%s,component=addresses,address=%s,subcomponent=diverts,divert=%s", this.domain, ObjectName.quote(this.brokerName), ObjectName.quote(address.toString()), ObjectName.quote(name.toString())));
    }

    public ObjectName getAcceptorObjectName(String name) throws Exception {
        return this.createObjectName("acceptor", name);
    }

    public ObjectName getBroadcastGroupObjectName(String name) throws Exception {
        return this.createObjectName("broadcast-group", name);
    }

    public ObjectName getBridgeObjectName(String name) throws Exception {
        return this.createObjectName("bridge", name);
    }

    public ObjectName getClusterConnectionObjectName(String name) throws Exception {
        return this.createObjectName("cluster-connection", name);
    }

    private ObjectName createObjectName(String type, String name) throws Exception {
        return ObjectName.getInstance(String.format("%s:broker=%s,component=%ss,name=%s", this.domain, ObjectName.quote(this.brokerName), type, ObjectName.quote(name)));
    }

    private String getBrokerProperties() {
        if (this.jmxUseBrokerName && this.brokerName != null) {
            return String.format("broker=%s", ObjectName.quote(this.brokerName));
        }
        return "";
    }
}

