/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.AbstractX509CertificateChainCredential;
import org.wildfly.security.key.KeyUtil;

public final class X509CertificateChainPrivateCredential
extends AbstractX509CertificateChainCredential {
    private final PrivateKey privateKey;

    public X509CertificateChainPrivateCredential(PrivateKey privateKey, X509Certificate ... certificateChain) {
        super(certificateChain);
        Assert.checkNotNullParam("privateKey", privateKey);
        if (!this.getFirstCertificate().getPublicKey().getAlgorithm().equals(privateKey.getAlgorithm())) {
            throw ElytronMessages.log.mismatchedPublicPrivateKeyAlgorithms();
        }
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public X509CertificateChainPrivateCredential clone() {
        PrivateKey privateKey = this.privateKey;
        PrivateKey clone = KeyUtil.cloneKey(PrivateKey.class, privateKey);
        return privateKey == clone ? this : new X509CertificateChainPrivateCredential(clone, this.getCertificateChain());
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(Arrays.hashCode(this.certificateChain), this.privateKey.hashCode());
    }

    public boolean equals(Object obj) {
        return obj instanceof X509CertificateChainPrivateCredential && this.equals((X509CertificateChainPrivateCredential)obj);
    }

    private boolean equals(X509CertificateChainPrivateCredential obj) {
        return this.privateKey.equals(obj.privateKey) && Arrays.equals(this.certificateChain, obj.certificateChain);
    }
}

