/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class FieldContext {
    private final String field;
    private final boolean isIdField;
    private boolean ignoreAnalyzer;
    private final QueryCustomizer fieldCustomizer;
    private boolean ignoreFieldBridge;
    private FieldBridge fieldBridge;

    public FieldContext(String field, QueryBuildingContext queryContext) {
        this.field = field;
        this.fieldCustomizer = new QueryCustomizer();
        this.isIdField = queryContext.getDocumentBuilder().getIdFieldName().equals(field);
    }

    public String getField() {
        return this.field;
    }

    public boolean applyAnalyzer() {
        return !this.ignoreAnalyzer && !this.isIdField;
    }

    public void setIgnoreAnalyzer(boolean ignoreAnalyzer) {
        this.ignoreAnalyzer = ignoreAnalyzer;
    }

    public QueryCustomizer getFieldCustomizer() {
        return this.fieldCustomizer;
    }

    public boolean isIgnoreFieldBridge() {
        return this.ignoreFieldBridge;
    }

    public void setIgnoreFieldBridge(boolean ignoreFieldBridge) {
        this.ignoreFieldBridge = ignoreFieldBridge;
    }

    public void setFieldBridge(FieldBridge fieldBridge) {
        this.fieldBridge = fieldBridge;
    }

    public FieldBridge getFieldBridge() {
        return this.fieldBridge;
    }

    public String objectToString(DocumentBuilderIndexedEntity documentBuilder, Object value, ConversionContext conversionContext) {
        if (this.isIgnoreFieldBridge()) {
            return value == null ? null : value.toString();
        }
        if (this.fieldBridge != null) {
            return documentBuilder.objectToString(this.field, this.fieldBridge, value, conversionContext);
        }
        return documentBuilder.objectToString(this.field, value, conversionContext);
    }

    public String toString() {
        return "FieldContext [field=" + this.field + ", fieldBridge=" + this.fieldBridge + ", fieldCustomizer=" + this.fieldCustomizer + ", ignoreAnalyzer=" + this.ignoreAnalyzer + ", ignoreFieldBridge=" + this.ignoreFieldBridge + "]";
    }
}

