/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.api.CounterConfiguration;

public class CompareAndSwapOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(CompareAndSwapOperation.class, Log.class);
    private final long expect;
    private final long update;
    private final CounterConfiguration counterConfiguration;

    public CompareAndSwapOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, long expect, long update, CounterConfiguration counterConfiguration) {
        super((short)88, (short)89, codec, channelFactory, topologyId, cfg, counterName);
        this.expect = expect;
        this.update = update;
        this.counterConfiguration = counterConfiguration;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 16);
        buf.writeLong(this.expect);
        buf.writeLong(this.update);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        this.complete(buf.readLong());
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.update >= this.counterConfiguration.upperBound()) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

