/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultProjectDependencyGraph;
import org.apache.maven.DuplicateProjectException;
import org.apache.maven.FilteredProjectDependencyGraph;
import org.apache.maven.InternalErrorException;
import org.apache.maven.LoggingRepositoryListener;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.LocalRepositoryNotAccessibleException;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ChainedWorkspaceReader;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;

@Component(role=Maven.class)
public class DefaultMaven
implements Maven {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;
    @Requirement
    private LifecycleStarter lifecycleStarter;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    MavenExecutionRequestPopulator populator;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement(optional=true, hint="ide")
    private WorkspaceReader workspaceRepository;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement(optional=true, hint="simple")
    private LocalRepositoryManagerFactory simpleLocalRepoMgrFactory;
    @Requirement
    private SettingsDecrypter settingsDecrypter;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private EventSpyDispatcher eventSpyDispatcher;
    @Requirement
    private SessionScope sessionScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result;
        try {
            result = this.doExecute(this.populator.populateDefaults(request));
        }
        catch (OutOfMemoryError e) {
            result = this.addExceptionToResult(new DefaultMavenExecutionResult(), e);
        }
        catch (MavenExecutionRequestPopulationException e) {
            result = this.addExceptionToResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result = this.addExceptionToResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        finally {
            this.legacySupport.setSession(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        WorkspaceReader reactorWorkspace;
        List<MavenProject> projects;
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (LocalRepositoryNotAccessibleException e) {
            return this.addExceptionToResult(result, e);
        }
        DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)this.newRepositorySession(request);
        MavenSession session = new MavenSession(this.container, (RepositorySystemSession)repoSession, request, result);
        this.sessionScope.enter();
        this.sessionScope.seed(MavenSession.class, session);
        this.legacySupport.setSession(session);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.<MavenProject>emptyList())) {
                listener.afterSessionStart(session);
            }
        }
        catch (MavenExecutionException e) {
            return this.addExceptionToResult(result, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session, null);
        try {
            projects = this.getProjectsForMavenReactor(session);
            session.setAllProjects(projects);
        }
        catch (ProjectBuildingException e) {
            return this.addExceptionToResult(result, e);
        }
        this.validateProjects(projects);
        ProjectDependencyGraph projectDependencyGraph = this.createProjectDependencyGraph(projects, request, result, true);
        if (result.hasExceptions()) {
            return result;
        }
        session.setProjects(projectDependencyGraph.getSortedProjects());
        try {
            session.setProjectMap(this.getProjectMap(session.getProjects()));
        }
        catch (DuplicateProjectException e) {
            return this.addExceptionToResult(result, e);
        }
        try {
            reactorWorkspace = (WorkspaceReader)this.container.lookup(WorkspaceReader.class, "reactor");
        }
        catch (ComponentLookupException e) {
            return this.addExceptionToResult(result, e);
        }
        repoSession.setWorkspaceReader(ChainedWorkspaceReader.newInstance((WorkspaceReader)reactorWorkspace, (WorkspaceReader)repoSession.getWorkspaceReader()));
        repoSession.setReadOnly();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterProjectsRead(session);
            }
        }
        catch (MavenExecutionException e) {
            MavenExecutionResult listener = this.addExceptionToResult(result, e);
            return listener;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        projectDependencyGraph = this.createProjectDependencyGraph(session.getProjects(), request, result, false);
        try {
            MavenExecutionResult e;
            if (result.hasExceptions()) {
                e = result;
                return e;
            }
            session.setProjects(projectDependencyGraph.getSortedProjects());
            session.setProjectDependencyGraph(projectDependencyGraph);
            result.setTopologicallySortedProjects(session.getProjects());
            result.setProject(session.getTopLevelProject());
            this.lifecycleStarter.execute(session);
            this.validateActivatedProfiles(session.getProjects(), request.getActiveProfiles());
            if (!session.getResult().hasExceptions()) return result;
            e = this.addExceptionToResult(result, session.getResult().getExceptions().get(0));
            return e;
        }
        finally {
            try {
                this.afterSessionEnd(projects, session);
            }
            catch (MavenExecutionException e) {
                MavenExecutionResult mavenExecutionResult = this.addExceptionToResult(result, e);
                return mavenExecutionResult;
            }
            finally {
                this.sessionScope.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterSessionEnd(Collection<MavenProject> projects, MavenSession session) throws MavenExecutionException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterSessionEnd(session);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setCache(request.getRepositoryCache());
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", this.getUserAgent());
        configProps.put("aether.interactive", request.isInteractiveMode());
        configProps.putAll(request.getSystemProperties());
        configProps.putAll(request.getUserProperties());
        session.setOffline(request.isOffline());
        session.setChecksumPolicy(request.getGlobalChecksumPolicy());
        if (request.isNoSnapshotUpdates()) {
            session.setUpdatePolicy("never");
        } else if (request.isUpdateSnapshots()) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        int errorPolicy = 0;
        errorPolicy |= request.isCacheNotFound() ? 1 : 0;
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(errorPolicy |= request.isCacheTransferError() ? 2 : 0, errorPolicy | 1));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry(this.artifactHandlerManager));
        LocalRepository localRepo = new LocalRepository(request.getLocalRepository().getBasedir());
        if (request.isUseLegacyLocalRepository()) {
            this.logger.warn("Disabling enhanced local repository: using legacy is strongly discouraged to ensure build reproducibility.");
            try {
                session.setLocalRepositoryManager(this.simpleLocalRepoMgrFactory.newInstance((RepositorySystemSession)session, localRepo));
            }
            catch (NoLocalRepositoryManagerException e) {
                this.logger.warn("Failed to configure legacy local repository: back to default");
                session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
            }
        } else {
            session.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        }
        if (request.getWorkspaceReader() != null) {
            session.setWorkspaceReader(request.getWorkspaceReader());
        } else {
            session.setWorkspaceReader(this.workspaceRepository);
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(request.getProxies());
        decrypt.setServers(request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
            }
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        for (Mirror mirror : request.getMirrors()) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Proxy proxy : decrypted.getProxies()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            proxySelector.add(new org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authBuilder.build()), proxy.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        session.setTransferListener(request.getTransferListener());
        session.setRepositoryListener(this.eventSpyDispatcher.chainListener((RepositoryListener)new LoggingRepositoryListener(this.logger)));
        session.setUserProperties((Map)request.getUserProperties());
        session.setSystemProperties((Map)request.getSystemProperties());
        session.setConfigProperties(configProps);
        return session;
    }

    private String getUserAgent() {
        return "Apache-Maven/" + this.getMavenVersion() + " (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
    }

    private String getMavenVersion() {
        Properties props = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                this.logger.debug("Failed to read Maven version", (Throwable)e);
            }
            IOUtil.close((InputStream)is);
        }
        return props.getProperty("version", "unknown-version");
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws LocalRepositoryNotAccessibleException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at " + localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new LocalRepositoryNotAccessibleException("Could not create local repository at " + localRepoDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private MavenExecutionResult addExceptionToResult(MavenExecutionResult result, Throwable e) {
        if (!result.getExceptions().contains(e)) {
            result.addException(e);
        }
        return result;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenSession session) throws ProjectBuildingException {
        MavenExecutionRequest request = session.getRequest();
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
            MavenProject project = this.projectBuilder.build((ModelSource)modelSource, request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            projects.add(project);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files, request);
        return projects;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                String loc = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)result.getProjectId());
                this.logger.warn(problem.getMessage() + (StringUtils.isNotEmpty((String)loc) ? " @ " + loc : ""));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private Map<String, MavenProject> getProjectMap(Collection<MavenProject> projects) throws DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            MavenProject collision = (MavenProject)index.get(projectId);
            if (collision == null) {
                index.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index;
    }

    private void validateProjects(List<MavenProject> projects) {
        HashMap<String, MavenProject> projectsMap = new HashMap<String, MavenProject>();
        for (MavenProject p : projects) {
            String projectKey = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
            projectsMap.put(projectKey, p);
        }
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuildPlugins()) {
                String pluginKey;
                if (!plugin.isExtensions() || !projectsMap.containsKey(pluginKey = ArtifactUtils.key((String)plugin.getGroupId(), (String)plugin.getArtifactId(), (String)plugin.getVersion()))) continue;
                this.logger.warn(project.getName() + " uses " + plugin.getKey() + " as extensions, which is not possible within the same reactor build. " + "This plugin was pulled from the local repository!");
            }
        }
    }

    private void validateActivatedProfiles(List<MavenProject> projects, List<String> activeProfileIds) {
        LinkedHashSet<String> notActivatedProfileIds = new LinkedHashSet<String>(activeProfileIds);
        for (MavenProject project : projects) {
            for (List<String> profileIds : project.getInjectedProfileIds().values()) {
                notActivatedProfileIds.removeAll(profileIds);
            }
        }
        for (String notActivatedProfileId : notActivatedProfileIds) {
            this.logger.warn("The requested profile \"" + notActivatedProfileId + "\" could not be activated because it does not exist.");
        }
    }

    @Deprecated
    protected Logger getLogger() {
        return this.logger;
    }

    private ProjectDependencyGraph createProjectDependencyGraph(Collection<MavenProject> projects, MavenExecutionRequest request, MavenExecutionResult result, boolean trimming) {
        ProjectDependencyGraph projectDependencyGraph = null;
        try {
            projectDependencyGraph = new DefaultProjectDependencyGraph(projects);
            if (trimming) {
                List<MavenProject> activeProjects = projectDependencyGraph.getSortedProjects();
                activeProjects = this.trimSelectedProjects(activeProjects, projectDependencyGraph, request);
                activeProjects = this.trimExcludedProjects(activeProjects, request);
                if ((activeProjects = this.trimResumedProjects(activeProjects, request)).size() != projectDependencyGraph.getSortedProjects().size()) {
                    projectDependencyGraph = new FilteredProjectDependencyGraph(projectDependencyGraph, activeProjects);
                }
            }
        }
        catch (CycleDetectedException e) {
            String message = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message, e);
            this.addExceptionToResult(result, error);
        }
        catch (org.apache.maven.project.DuplicateProjectException e) {
            this.addExceptionToResult(result, e);
        }
        catch (MavenExecutionException e) {
            this.addExceptionToResult(result, e);
        }
        return projectDependencyGraph;
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getSelectedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getSelectedProjects()) {
                MavenProject selectedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    selectedProject = project;
                    break;
                }
                if (selectedProject != null) {
                    selectedProjects.add(selectedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty((String)request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                for (MavenProject selectedProject : new ArrayList(selectedProjects)) {
                    if (makeUpstream) {
                        selectedProjects.addAll(graph.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    selectedProjects.addAll(graph.getDownstreamProjects(selectedProject, true));
                }
            }
            result = new ArrayList<MavenProject>(selectedProjects.size());
            for (MavenProject project : projects) {
                if (!selectedProjects.contains(project)) continue;
                result.add(project);
            }
        }
        return result;
    }

    private List<MavenProject> trimExcludedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getExcludedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> excludedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getExcludedProjects()) {
                MavenProject excludedProject = null;
                for (MavenProject project : projects) {
                    if (!this.isMatchingProject(project, selector, reactorDirectory)) continue;
                    excludedProject = project;
                    break;
                }
                if (excludedProject != null) {
                    excludedProjects.add(excludedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            result = new ArrayList<MavenProject>(projects.size());
            for (MavenProject project : projects) {
                if (excludedProjects.contains(project)) continue;
                result.add(project);
            }
        }
        return result;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (StringUtils.isNotEmpty((String)request.getResumeFrom())) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            String selector = request.getResumeFrom();
            result = new ArrayList<MavenProject>(projects.size());
            boolean resumed = false;
            for (MavenProject project : projects) {
                if (!resumed && this.isMatchingProject(project, selector, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                result.add(project);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + projects, request.getPom());
            }
        }
        return result;
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }
}

