/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.concurrent.CountDownLatch;
import org.aesh.command.shell.Shell;
import org.aesh.readline.PagingSupport;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.Config;

class ShellImpl
implements Shell {
    private Connection connection;
    private Readline readline;
    private final PagingSupport pagingSupport;

    ShellImpl(Connection connection, Readline readline) {
        this(connection, readline, false);
    }

    ShellImpl(Connection connection, Readline readline, boolean search) {
        this.connection = connection;
        this.readline = readline;
        this.pagingSupport = new PagingSupport(connection, readline, search);
    }

    void startCollectOutput() {
        this.pagingSupport.reset();
    }

    void printCollectedOutput() {
        this.pagingSupport.printCollectedOutput();
    }

    @Override
    public void write(String msg, boolean page) {
        if (this.connection.supportsAnsi() && page) {
            this.pagingSupport.addContent(msg);
        } else {
            this.connection.write(msg);
        }
    }

    @Override
    public void writeln(String msg, boolean page) {
        if (this.connection.supportsAnsi() && page) {
            this.pagingSupport.addContent(msg);
        } else {
            this.connection.write(msg + Config.getLineSeparator());
        }
    }

    @Override
    public void write(int[] out) {
        this.connection.stdoutHandler().accept(out);
    }

    @Override
    public void write(char out) {
        this.connection.stdoutHandler().accept(new int[]{out});
    }

    @Override
    public String readLine() throws InterruptedException {
        return this.readLine(new Prompt(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(Prompt prompt) throws InterruptedException {
        this.printCollectedOutput();
        this.pagingSupport.reset();
        String[] out = new String[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        this.readline.readline(this.connection, prompt, event -> {
            out[0] = event;
            latch.countDown();
        });
        try {
            latch.await();
        }
        finally {
            this.connection.setStdinHandler(null);
        }
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key read() throws InterruptedException {
        ActionDecoder decoder = new ActionDecoder();
        Key[] key = new Key[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.connection.enterRawMode();
        try {
            this.connection.setStdinHandler(keys -> {
                decoder.add((int[])keys);
                if (decoder.hasNext()) {
                    key[0] = Key.findStartKey(decoder.next().buffer().array());
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            finally {
                this.connection.setStdinHandler(null);
            }
        }
        finally {
            this.connection.setAttributes(attributes);
        }
        return key[0];
    }

    @Override
    public Key read(Prompt prompt) throws InterruptedException {
        return null;
    }

    @Override
    public boolean enableAlternateBuffer() {
        return this.connection.put(Capability.enter_ca_mode, new Object[0]);
    }

    @Override
    public boolean enableMainBuffer() {
        return this.connection.put(Capability.exit_ca_mode, new Object[0]);
    }

    @Override
    public Size size() {
        return this.connection.size();
    }

    @Override
    public void clear() {
        this.connection.put(Capability.clear_screen, new Object[0]);
    }
}

