/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.Divert;

public class DivertControlImpl
extends AbstractControl
implements DivertControl {
    private final Divert divert;
    private final DivertConfiguration configuration;

    public DivertControlImpl(Divert divert, StorageManager storageManager, DivertConfiguration configuration) throws Exception {
        super(DivertControl.class, storageManager);
        this.divert = divert;
        this.configuration = configuration;
    }

    public String getAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getFilter() {
        this.clearIO();
        try {
            String string = this.configuration.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getForwardingAddress() {
        this.clearIO();
        try {
            String string = this.configuration.getForwardingAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getRoutingName() {
        this.clearIO();
        try {
            String string = this.divert.getRoutingName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTransformerClassName() {
        this.clearIO();
        try {
            String string = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTransformerPropertiesAsJSON() {
        return JsonUtil.toJsonObject(this.getTransformerProperties()).toString();
    }

    public Map<String, String> getTransformerProperties() {
        this.clearIO();
        try {
            Map<String, String> map = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getProperties();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getRoutingType() {
        this.clearIO();
        try {
            String string = this.configuration.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUniqueName() {
        this.clearIO();
        try {
            String string = this.divert.getUniqueName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isExclusive() {
        this.clearIO();
        try {
            boolean bl = this.divert.isExclusive();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(DivertControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(DivertControl.class);
    }
}

