/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractDelegatingDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;

public class InternalDataContainerAdapter<K, V>
extends AbstractDelegatingDataContainer<K, V>
implements InternalDataContainer<K, V> {
    private final DataContainer<K, V> container;
    protected final List<Consumer<Iterable<InternalCacheEntry<K, V>>>> listeners = new CopyOnWriteArrayList<Consumer<Iterable<InternalCacheEntry<K, V>>>>();
    @Inject
    private KeyPartitioner keyPartitioner;
    private static final int REMOTE_SEGMENT_BATCH_SIZE = 32;

    public InternalDataContainerAdapter(DataContainer<K, V> container) {
        this.container = container;
    }

    @Override
    public DataContainer<K, V> delegate() {
        return this.container;
    }

    @Override
    public InternalCacheEntry<K, V> get(int segment, Object k) {
        return this.get(k);
    }

    @Override
    public InternalCacheEntry<K, V> peek(int segment, Object k) {
        return this.peek(k);
    }

    @Override
    public void put(int segment, K k, V v, Metadata metadata) {
        this.put(k, v, metadata);
    }

    @Override
    public boolean containsKey(int segment, Object k) {
        return this.containsKey(k);
    }

    @Override
    public InternalCacheEntry<K, V> remove(int segment, Object k) {
        return this.remove(k);
    }

    @Override
    public void evict(int segment, K key) {
        this.evict(key);
    }

    @Override
    public InternalCacheEntry<K, V> compute(int segment, K key, DataContainer.ComputeAction<K, V> action) {
        return this.compute(key, action);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return new FilterSpliterator(this.spliterator(), e -> segments.contains(this.keyPartitioner.getSegment(e.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        return new FilterSpliterator(this.spliteratorIncludingExpired(), e -> segments.contains(this.keyPartitioner.getSegment(e.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new FilterIterator(this.iterator(), e -> segments.contains(this.keyPartitioner.getSegment(e.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        return new FilterIterator(this.iteratorIncludingExpired(), e -> segments.contains(this.keyPartitioner.getSegment(e.getKey())));
    }

    @Override
    public void clear(IntSet segments) {
        Iterator<InternalCacheEntry<K, V>> iter = this.iteratorIncludingExpired(segments);
        while (iter.hasNext()) {
            InternalCacheEntry<K, V> ice = iter.next();
            this.remove(ice.getKey());
        }
    }

    @Override
    public void forEachIncludingExpired(ObjIntConsumer<? super InternalCacheEntry<K, V>> action) {
        this.iteratorIncludingExpired().forEachRemaining(ice -> action.accept((InternalCacheEntry<K, V>)ice, this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public void addSegments(IntSet segments) {
    }

    @Override
    public void removeSegments(IntSet segments) {
        if (!segments.isEmpty()) {
            ArrayList<InternalCacheEntry<K, V>> removedEntries = !this.listeners.isEmpty() ? new ArrayList<InternalCacheEntry<K, V>>(32) : null;
            Iterator<InternalCacheEntry<K, V>> iter = this.iteratorIncludingExpired(segments);
            while (iter.hasNext()) {
                InternalCacheEntry<K, V> ice = iter.next();
                this.remove(ice.getKey());
                if (removedEntries == null) continue;
                removedEntries.add(ice);
                if (removedEntries.size() != 32) continue;
                List unmod = Collections.unmodifiableList(removedEntries);
                this.listeners.forEach((? super T c) -> c.accept(unmod));
                removedEntries.clear();
            }
            if (removedEntries != null && !removedEntries.isEmpty()) {
                List unmod = Collections.unmodifiableList(removedEntries);
                this.listeners.forEach((? super T c) -> c.accept(unmod));
            }
        }
    }

    @Override
    public void addRemovalListener(Consumer<Iterable<InternalCacheEntry<K, V>>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRemovalListener(Object listener) {
        this.listeners.remove(listener);
    }
}

