/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.logging.impl;

import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=79, max=79), @ValidIdRange(min=98, max=98), @ValidIdRange(min=300001, max=399999)})
public interface Log
extends BaseHibernateSearchLogger {
    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=79, value="Serialization protocol version %1$d.%2$d initialized")
    public void serializationProtocol(int var1, int var2);

    @Message(id=98, value="Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d")
    public SearchException incompatibleProtocolVersion(int var1, int var2, int var3, int var4);

    @Message(id=300001, value="Unable to find Avro schema '%s'")
    public SearchException unableToLoadAvroSchema(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=300002, value="Parsing message from a future protocol version. Some feature might not be propagated. Message version: %1$d.%2$d. Current protocol version: %1$d.%3$d")
    public void unexpectedMinorProtocolVersion(int var1, int var2, int var3);
}

