/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.mcmp.MCMPConnectionListener;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPRequestType;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;

@ThreadSafe
public class DefaultMCMPHandler
implements MCMPHandler {
    private static final String NEW_LINE = "\r\n";
    static final Logger log = Logger.getLogger(DefaultMCMPHandler.class);
    private final MCMPHandlerConfiguration config;
    private final ResetRequestSource resetRequestSource;
    private final MCMPRequestFactory requestFactory;
    private final MCMPResponseParser responseParser;
    private final ReadWriteLock proxiesLock = new ReentrantReadWriteLock();
    private final Lock addRemoveProxiesLock = new ReentrantLock();
    @GuardedBy(value="proxiesLock")
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> addProxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> removeProxies = new ArrayList<Proxy>();
    private final AtomicBoolean established = new AtomicBoolean(false);
    private volatile MCMPConnectionListener connectionListener;
    private volatile boolean init = false;

    public DefaultMCMPHandler(MCMPHandlerConfiguration config, ResetRequestSource source, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser) {
        this.resetRequestSource = source;
        this.config = config;
        this.requestFactory = requestFactory;
        this.responseParser = responseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Collection<ProxyConfiguration> proxies, MCMPConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        if (proxies != null) {
            Lock lock = this.proxiesLock.writeLock();
            lock.lock();
            try {
                for (ProxyConfiguration proxy : proxies) {
                    this.add(proxy.getRemoteAddress(), proxy.getLocalAddress());
                }
                this.status(false);
            }
            finally {
                lock.unlock();
            }
        }
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.init = false;
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                proxy.closeConnection();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addProxy(InetSocketAddress socketAddress) {
        this.add(socketAddress);
    }

    @Override
    public void addProxy(ProxyConfiguration proxyConfiguration) {
        this.add(proxyConfiguration.getRemoteAddress(), proxyConfiguration.getLocalAddress());
    }

    private Proxy add(InetSocketAddress socketAddress) {
        return this.add(socketAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Proxy add(InetSocketAddress socketAddress, InetSocketAddress localAddress) {
        Proxy proxy = new Proxy(socketAddress, localAddress, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            Lock lock = this.proxiesLock.readLock();
            lock.lock();
            try {
                Iterator<Proxy> i$ = this.proxies.iterator();
                while (true) {
                    if (i$.hasNext()) {
                        Proxy candidate = i$.next();
                        if (!candidate.equals(proxy)) continue;
                        Proxy proxy2 = candidate;
                        return proxy2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                lock.unlock();
            }
            for (Proxy candidate : this.addProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy3 = candidate;
                return proxy3;
            }
            for (Proxy candidate : this.removeProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy4 = candidate;
                return proxy4;
            }
            proxy.setState(MCMPServerState.State.ERROR);
            this.addProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
        return proxy;
    }

    @Override
    public void addProxy(InetSocketAddress socketAddress, boolean established) {
        this.add(socketAddress).setEstablished(established);
    }

    @Override
    public void addProxy(ProxyConfiguration proxyConfiguration, boolean established) {
        this.add(proxyConfiguration.getRemoteAddress(), proxyConfiguration.getLocalAddress()).setEstablished(established);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProxy(InetSocketAddress socketAddress) {
        Proxy proxy = new Proxy(socketAddress, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            this.removeProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MCMPServerState> getProxyStates() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            if (this.proxies.isEmpty()) {
                Set<MCMPServerState> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<MCMPServerState> result = new LinkedHashSet<MCMPServerState>(this.proxies.size());
            for (Proxy proxy : this.proxies) {
                result.add(proxy);
            }
            LinkedHashSet<MCMPServerState> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProxyHealthOK() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() == MCMPServerState.State.OK) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markProxiesInError() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.OK) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.DOWN) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void status() {
        if (this.init) {
            this.processPendingDiscoveryEvents();
            this.status(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(boolean sendResetRequests) {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.ERROR) continue;
                proxy.closeConnection();
                String response = this.sendRequest(this.requestFactory.createInfoRequest(), proxy);
                if (proxy.getState() == MCMPServerState.State.OK) {
                    if (this.established.compareAndSet(false, true)) {
                        this.connectionListener.connectionEstablished(proxy.getLocalAddress());
                    }
                    if (!sendResetRequests) continue;
                    Map<String, Set<ResetRequestSource.VirtualHost>> parsedResponse = this.responseParser.parseInfoResponse(response);
                    List<MCMPRequest> requests = this.resetRequestSource.getResetRequests(parsedResponse);
                    log.trace(requests);
                    this.sendRequestsToProxy(requests, proxy);
                    continue;
                }
                proxy.closeConnection();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MCMPServerState, String> sendRequest(MCMPRequest request) {
        HashMap<MCMPServerState, String> map = new HashMap<MCMPServerState, String>();
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                map.put(proxy, this.sendRequest(request, proxy));
            }
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MCMPServerState, List<String>> sendRequests(List<MCMPRequest> requests) {
        HashMap<MCMPServerState, List<String>> map = new HashMap<MCMPServerState, List<String>>();
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                ArrayList<String> list = new ArrayList<String>(requests.size());
                for (MCMPRequest request : requests) {
                    list.add(this.sendRequest(request, proxy));
                }
                map.put(proxy, list);
            }
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    private List<String> sendRequestsToProxy(List<MCMPRequest> requests, Proxy proxy) {
        ArrayList<String> list = new ArrayList<String>(requests.size());
        for (MCMPRequest request : requests) {
            list.add(this.sendRequest(request, proxy));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingDiscoveryEvents() {
        block7: {
            this.addRemoveProxiesLock.lock();
            try {
                if (this.addProxies.isEmpty() && this.removeProxies.isEmpty()) break block7;
                Lock lock = this.proxiesLock.writeLock();
                lock.lock();
                try {
                    this.proxies.addAll(this.addProxies);
                    this.proxies.removeAll(this.removeProxies);
                    this.addProxies.clear();
                    this.removeProxies.clear();
                    for (Proxy proxy : this.proxies) {
                        proxy.closeConnection();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                this.addRemoveProxiesLock.unlock();
            }
        }
    }

    private String sendRequest(Proxy proxy, String command, String body) throws IOException {
        BufferedWriter writer = proxy.getConnectionWriter();
        writer.append(command).append(NEW_LINE);
        if (body.length() > 0) {
            writer.append("Content-Length: ").append(String.valueOf(body.length())).append(NEW_LINE);
        }
        writer.append("User-Agent: ClusterListener/1.0").append(NEW_LINE);
        writer.append("Connection: Keep-Alive").append(NEW_LINE);
        writer.write(NEW_LINE);
        if (body.length() > 0) {
            writer.write(body);
        }
        ((Writer)writer).flush();
        return proxy.getConnectionReader().readLine();
    }

    private void appendParameter(Appendable appender, String name, String value, boolean more) throws IOException {
        appender.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
        if (more) {
            appender.append('&');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendRequest(MCMPRequest request, Proxy proxy) {
        if (proxy.getState() != MCMPServerState.State.OK && request.getRequestType() != MCMPRequestType.INFO) {
            return null;
        }
        DefaultMCMPHandler.log.tracef("Sending to %s: %s", (Object)proxy, (Object)request);
        requestType = request.getRequestType();
        wildcard = request.isWildcard();
        jvmRoute = request.getJvmRoute();
        parameters = request.getParameters();
        bodyBuilder = new StringBuilder();
        try {
            if (jvmRoute != null) {
                this.appendParameter(bodyBuilder, "JVMRoute", jvmRoute, parameters.isEmpty() == false);
            }
            entries = parameters.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                this.appendParameter(bodyBuilder, entry.getKey(), entry.getValue(), entries.hasNext());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        headBuilder = new StringBuilder();
        headBuilder.append((Object)requestType).append(" ");
        proxyURL = this.config.getProxyURL();
        if (proxyURL != null) {
            headBuilder.append(proxyURL);
        }
        if (headBuilder.charAt(headBuilder.length() - 1) != '/') {
            headBuilder.append('/');
        }
        if (wildcard) {
            headBuilder.append('*');
        }
        headBuilder.append(" HTTP/1.1\r\n");
        headBuilder.append("Host: ");
        head = headBuilder.toString();
        body = bodyBuilder.toString();
        var12_13 = proxy;
        synchronized (var12_13) {
            try {
                block57: {
                    block56: {
                        block55: {
                            line = null;
                            host = proxy.getSocketAddress().getHostString();
                            proxyhead = host != null && host.contains(":") != false ? head + "[" + host + "]:" + proxy.getSocketAddress().getPort() : head + host + ":" + proxy.getSocketAddress().getPort();
                            try {
                                line = this.sendRequest(proxy, proxyhead, body);
                            }
                            catch (IOException var16_18) {
                                // empty catch block
                            }
                            if (line == null) {
                                proxy.closeConnection();
                                line = this.sendRequest(proxy, proxyhead, body);
                            }
                            reader = proxy.getConnectionReader();
                            status = 500;
                            message = null;
                            errorType = null;
                            contentLength = 0;
                            close = false;
                            chunked = false;
                            if (line == null) break block56;
                            try {
                                spaceIndex = line.indexOf(32);
lbl63:
                                // 2 sources

                                while (spaceIndex == -1) {
                                    line = reader.readLine();
                                    if (line == null) {
                                        var24_30 = null;
                                        break block55;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl77
                            }
                            catch (Exception e) {
                                ModClusterLogger.LOGGER.parseHeaderFailed(e, requestType, proxy.getSocketAddress());
                                break block56;
                            }
                        }
                        return var24_30;
lbl-1000:
                        // 1 sources

                        {
                            spaceIndex = line.indexOf(32);
                            ** GOTO lbl63
lbl77:
                            // 1 sources

                            responseStatus = line.substring(spaceIndex + 1, line.indexOf(32, spaceIndex + 1));
                            status = Integer.parseInt(responseStatus);
                            line = reader.readLine();
                            while (line != null && line.length() > 0) {
                                colon = line.indexOf(58);
                                headerName = line.substring(0, colon).trim();
                                headerValue = line.substring(colon + 1).trim();
                                if (!"version".equalsIgnoreCase(headerName)) {
                                    if ("type".equalsIgnoreCase(headerName)) {
                                        errorType = headerValue;
                                    } else if ("mess".equalsIgnoreCase(headerName)) {
                                        message = headerValue;
                                    } else if ("content-length".equalsIgnoreCase(headerName)) {
                                        contentLength = Integer.parseInt(headerValue);
                                    } else if ("connection".equalsIgnoreCase(headerName)) {
                                        close = "close".equalsIgnoreCase(headerValue);
                                    } else if ("Transfer-Encoding".equalsIgnoreCase(headerName) && "chunked".equalsIgnoreCase(headerValue)) {
                                        chunked = true;
                                    }
                                }
                                line = reader.readLine();
                            }
                        }
                    }
                    if (status == 200) {
                        proxy.setState(MCMPServerState.State.OK);
                        if (request.getRequestType().getEstablishesServer()) {
                            proxy.setEstablished(true);
                        }
                    } else if ("SYNTAX".equals(errorType)) {
                        proxy.setState(MCMPServerState.State.DOWN);
                        ModClusterLogger.LOGGER.unrecoverableErrorResponse(errorType, requestType, proxy.getSocketAddress(), message);
                    } else {
                        proxy.setState(MCMPServerState.State.ERROR);
                        ModClusterLogger.LOGGER.recoverableErrorResponse(errorType, requestType, proxy.getSocketAddress(), message);
                    }
                    if (close) {
                        contentLength = 0x7FFFFFFF;
                    } else if (contentLength == 0 && !chunked) {
                        e = null;
                        return e;
                    }
                    result = new StringBuilder();
                    buffer = new char[512];
                    if (chunked) {
                        skipcrlf = false;
                        block19: while (true) {
                            if (skipcrlf) {
                                reader.readLine();
                            } else {
                                skipcrlf = true;
                            }
                            line = reader.readLine();
                            contentLength = Integer.parseInt(line, 16);
                            if (contentLength == 0) {
                                reader.readLine();
                                break block57;
                            }
                            while (true) {
                                if (contentLength <= 0 || (bytes = reader.read(buffer, 0, contentLength > buffer.length ? buffer.length : contentLength)) <= 0) continue block19;
                                result.append(buffer, 0, bytes);
                                contentLength -= bytes;
                            }
                            break;
                        }
                    }
                    while (contentLength > 0 && (bytes = reader.read(buffer, 0, contentLength > buffer.length ? buffer.length : contentLength)) > 0) {
                        result.append(buffer, 0, bytes);
                        contentLength -= bytes;
                    }
                }
                if (proxy.getState() == MCMPServerState.State.OK) {
                    proxy.setIoExceptionLogged(false);
                }
                if (close) {
                    proxy.closeConnection();
                }
                var25_33 = result.toString();
                return var25_33;
            }
            catch (IOException e) {
                proxy.setState(MCMPServerState.State.ERROR);
                if (!proxy.isIoExceptionLogged()) {
                    ModClusterLogger.LOGGER.sendFailed(requestType, proxy.getSocketAddress(), e.getLocalizedMessage());
                    ModClusterLogger.LOGGER.catchingDebug(e);
                    proxy.setIoExceptionLogged(true);
                }
                var14_16 = null;
                return var14_16;
            }
            finally {
                if (proxy.getState() != MCMPServerState.State.OK) {
                    proxy.closeConnection();
                }
            }
        }
    }

    public static class VirtualHostImpl
    implements ResetRequestSource.VirtualHost,
    Externalizable {
        private final Set<String> aliases = new LinkedHashSet<String>();
        private final Map<String, ResetRequestSource.Status> contexts = new HashMap<String, ResetRequestSource.Status>();

        @Override
        public Set<String> getAliases() {
            return this.aliases;
        }

        @Override
        public Map<String, ResetRequestSource.Status> getContexts() {
            return this.contexts;
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            int aliases = input.readInt();
            for (int i = 0; i < aliases; ++i) {
                this.aliases.add(input.readUTF());
            }
            ResetRequestSource.Status[] stati = ResetRequestSource.Status.values();
            int contexts = input.readInt();
            for (int i = 0; i < contexts; ++i) {
                this.contexts.put(input.readUTF(), stati[input.readInt()]);
            }
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            output.writeInt(this.aliases.size());
            for (String string : this.aliases) {
                output.writeUTF(string);
            }
            output.writeInt(this.contexts.size());
            for (Map.Entry entry : this.contexts.entrySet()) {
                output.writeUTF((String)entry.getKey());
                output.writeInt(((ResetRequestSource.Status)((Object)entry.getValue())).ordinal());
            }
        }
    }

    @ThreadSafe
    private static class Proxy
    implements MCMPServerState,
    Serializable {
        private static final long serialVersionUID = 5219680414337319908L;
        private final InetSocketAddress socketAddress;
        private final InetSocketAddress sourceAddress;
        private volatile MCMPServerState.State state = MCMPServerState.State.OK;
        private volatile boolean established = false;
        private final transient int socketTimeout;
        private final transient SocketFactory socketFactory;
        private volatile transient boolean ioExceptionLogged = false;
        private volatile transient InetAddress localAddress = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient Socket socket = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient BufferedReader reader = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient BufferedWriter writer = null;

        Proxy(InetSocketAddress socketAddress, MCMPHandlerConfiguration config) {
            this(socketAddress, null, config);
        }

        Proxy(InetSocketAddress socketAddress, InetSocketAddress sourceAddress, MCMPHandlerConfiguration config) {
            this.socketAddress = socketAddress;
            this.sourceAddress = sourceAddress;
            this.socketFactory = config.getSocketFactory();
            this.socketTimeout = config.getSocketTimeout();
        }

        @Override
        public MCMPServerState.State getState() {
            return this.state;
        }

        @Override
        public InetSocketAddress getSocketAddress() {
            return this.socketAddress;
        }

        @Override
        public boolean isEstablished() {
            return this.established;
        }

        public String toString() {
            return this.socketAddress.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MCMPServer)) {
                return false;
            }
            MCMPServer proxy = (MCMPServer)object;
            return this.socketAddress.equals(proxy.getSocketAddress());
        }

        public int hashCode() {
            return this.socketAddress.hashCode();
        }

        void setState(MCMPServerState.State state) {
            this.state = state;
        }

        void setEstablished(boolean established) {
            this.established = established;
        }

        private synchronized Socket getConnection() throws IOException {
            if (this.socket == null || this.socket.isClosed()) {
                this.socket = this.socketFactory.createSocket();
                InetAddress address = this.socketAddress.getAddress();
                if (this.sourceAddress != null) {
                    if (this.sourceAddress.getPort() != 0) {
                        this.socket.setReuseAddress(true);
                    }
                    this.socket.bind(this.sourceAddress);
                } else if (address instanceof Inet6Address && address.isLinkLocalAddress()) {
                    InetSocketAddress bindAddr = new InetSocketAddress(address, 0);
                    this.socket.bind(bindAddr);
                }
                this.socket.connect(this.socketAddress, this.socketTimeout);
                this.socket.setSoTimeout(this.socketTimeout);
                this.localAddress = this.socket.getLocalAddress();
            }
            return this.socket;
        }

        synchronized BufferedReader getConnectionReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.getConnection().getInputStream()));
            }
            return this.reader;
        }

        synchronized BufferedWriter getConnectionWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new OutputStreamWriter(this.getConnection().getOutputStream()));
            }
            return this.writer;
        }

        InetAddress getLocalAddress() {
            return this.localAddress;
        }

        synchronized void closeConnection() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.socket = null;
            }
        }

        boolean isIoExceptionLogged() {
            return this.ioExceptionLogged;
        }

        void setIoExceptionLogged(boolean ioErrorLogged) {
            this.ioExceptionLogged = ioErrorLogged;
        }
    }
}

