/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.server.Services;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.core.management.client.Process;
import org.wildfly.extension.core.management.client.ProcessStateListener;
import org.wildfly.extension.core.management.client.ProcessStateListenerInitParameters;
import org.wildfly.extension.core.management.client.RunningStateChangeEvent;
import org.wildfly.extension.core.management.client.RuntimeConfigurationStateChangeEvent;
import org.wildfly.extension.core.management.logging.CoreManagementLogger;

public class ProcessStateListenerService
implements Service<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"core", "management", "process-state-listener"});
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateService = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final PropertyChangeListener propertyChangeListener;
    private final OperationListener operationListener;
    private final ProcessStateListener listener;
    private final ProcessStateListenerInitParameters parameters;
    private final String name;
    private final int timeout;
    private final ProcessType processType;
    private final Object stopLock = new Object();
    private volatile Process.RunningState runningState = null;

    private ProcessStateListenerService(ProcessType processType, final RunningMode runningMode, String name, ProcessStateListener listener, Map<String, String> properties, int timeout) {
        CoreManagementLogger.ROOT_LOGGER.debugf("Initalizing ProcessStateListenerService with a running mode of %s", runningMode);
        this.listener = listener;
        this.name = name;
        this.timeout = timeout;
        this.processType = processType;
        this.parameters = new ProcessStateListenerInitParameters.Builder().setInitProperties(properties).setRunningMode(Process.RunningMode.from((String)runningMode.name())).setProcessType(Process.Type.valueOf((String)processType.name())).build();
        this.propertyChangeListener = evt -> {
            if ("currentState".equals(evt.getPropertyName())) {
                Process.RuntimeConfigurationState oldState = Process.RuntimeConfigurationState.valueOf((String)((ControlledProcessState.State)evt.getOldValue()).name());
                Process.RuntimeConfigurationState newState = Process.RuntimeConfigurationState.valueOf((String)((ControlledProcessState.State)evt.getNewValue()).name());
                this.transition(oldState, newState);
            }
        };
        this.operationListener = !processType.isHostController() ? new OperationListener(){

            public void suspendStarted() {
                ProcessStateListenerService.this.suspendTransition(ProcessStateListenerService.this.runningState, Process.RunningState.SUSPENDING);
            }

            public void complete() {
                ProcessStateListenerService.this.suspendTransition(ProcessStateListenerService.this.runningState, Process.RunningState.SUSPENDED);
            }

            public void cancelled() {
                if (ProcessStateListenerService.this.runningState == null || ProcessStateListenerService.this.runningState == Process.RunningState.STARTING) {
                    ProcessStateListenerService.this.suspendTransition(Process.RunningState.STARTING, Process.RunningState.SUSPENDED);
                }
                switch (runningMode) {
                    case ADMIN_ONLY: {
                        ProcessStateListenerService.this.suspendTransition(ProcessStateListenerService.this.runningState, Process.RunningState.ADMIN_ONLY);
                        break;
                    }
                    case NORMAL: {
                        ProcessStateListenerService.this.suspendTransition(ProcessStateListenerService.this.runningState, Process.RunningState.NORMAL);
                    }
                }
            }

            public void timeout() {
            }
        } : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transition(Process.RuntimeConfigurationState oldState, Process.RuntimeConfigurationState newState) {
        Object object = this.stopLock;
        synchronized (object) {
            if (oldState == newState) {
                return;
            }
            RuntimeConfigurationStateChangeEvent event = new RuntimeConfigurationStateChangeEvent(oldState, newState);
            Future<?> controlledProcessStateTransition = ((ExecutorService)this.executorServiceValue.getValue()).submit(() -> {
                CoreManagementLogger.ROOT_LOGGER.debugf("Executing runtimeConfigurationStateChanged %s in thread %s", event, Thread.currentThread().getName());
                this.listener.runtimeConfigurationStateChanged(event);
            });
            try {
                controlledProcessStateTransition.get(this.timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                CoreManagementLogger.ROOT_LOGGER.processStateInvokationError(ex, this.name);
            }
            catch (TimeoutException ex) {
                CoreManagementLogger.ROOT_LOGGER.processStateTimeoutError(ex, this.name);
            }
            catch (RuntimeException | ExecutionException t) {
                CoreManagementLogger.ROOT_LOGGER.processStateInvokationError(t, this.name);
            }
            finally {
                if (!controlledProcessStateTransition.isDone()) {
                    controlledProcessStateTransition.cancel(true);
                }
            }
            switch (newState) {
                case RUNNING: {
                    if (Process.RunningState.NORMAL == this.runningState || Process.RunningState.ADMIN_ONLY == this.runningState) break;
                    if (!this.processType.isServer()) {
                        if (this.parameters.getRunningMode() == Process.RunningMode.NORMAL) {
                            this.suspendTransition(this.runningState, Process.RunningState.NORMAL);
                            break;
                        }
                        this.suspendTransition(this.runningState, Process.RunningState.ADMIN_ONLY);
                        break;
                    }
                    if (this.runningState != Process.RunningState.STARTING) break;
                    this.suspendTransition(this.runningState, Process.RunningState.SUSPENDED);
                    break;
                }
                case STARTING: {
                    if (Process.RunningState.STARTING == this.runningState) break;
                    this.suspendTransition(this.runningState, Process.RunningState.STARTING);
                    break;
                }
                case STOPPING: {
                    if (Process.RunningState.STOPPING == this.runningState) break;
                    this.suspendTransition(this.runningState, Process.RunningState.STOPPING);
                    break;
                }
                case STOPPED: {
                    if (Process.RunningState.STOPPED == this.runningState) break;
                    this.suspendTransition(this.runningState, Process.RunningState.STOPPED);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendTransition(Process.RunningState oldState, Process.RunningState newState) {
        Object object = this.stopLock;
        synchronized (object) {
            if (oldState == newState) {
                return;
            }
            this.runningState = newState;
            RunningStateChangeEvent event = new RunningStateChangeEvent(oldState, newState);
            Future<?> suspendStateTransition = ((ExecutorService)this.executorServiceValue.getValue()).submit(() -> {
                CoreManagementLogger.ROOT_LOGGER.debugf("Executing runningStateChanged %s in thread %s", event, Thread.currentThread().getName());
                this.listener.runningStateChanged(event);
            });
            try {
                suspendStateTransition.get(this.timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                CoreManagementLogger.ROOT_LOGGER.processStateInvokationError(ex, this.name);
            }
            catch (TimeoutException ex) {
                CoreManagementLogger.ROOT_LOGGER.processStateTimeoutError(ex, this.name);
            }
            catch (RuntimeException | ExecutionException t) {
                CoreManagementLogger.ROOT_LOGGER.processStateInvokationError(t, this.name);
            }
            finally {
                if (!suspendStateTransition.isDone()) {
                    suspendStateTransition.cancel(true);
                }
            }
        }
    }

    static void install(ServiceTarget serviceTarget, ProcessType processType, RunningMode runningMode, String listenerName, ProcessStateListener listener, Map<String, String> properties, int timeout) {
        ProcessStateListenerService service = new ProcessStateListenerService(processType, runningMode, listenerName, listener, properties, timeout);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME.append(new String[]{listenerName}), (Service)service).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, service.controlledProcessStateService);
        if (!processType.isHostController()) {
            builder.addDependency(Services.JBOSS_SUSPEND_CONTROLLER, SuspendController.class, service.suspendControllerInjectedValue);
        }
        Services.addServerExecutorDependency((ServiceBuilder)builder, service.executorServiceValue);
        builder.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        Runnable task = () -> {
            try {
                this.listener.init(this.parameters);
                ((ControlledProcessStateService)this.controlledProcessStateService.getValue()).addPropertyChangeListener(this.propertyChangeListener);
                SuspendController controller = (SuspendController)this.suspendControllerInjectedValue.getOptionalValue();
                if (controller != null) {
                    controller.addListener(this.operationListener);
                    CoreManagementLogger.ROOT_LOGGER.debugf("Starting ProcessStateListenerService with a SuspendControllerState %s", controller.getState());
                    switch (controller.getState()) {
                        case PRE_SUSPEND: {
                            this.runningState = Process.RunningState.PRE_SUSPEND;
                            break;
                        }
                        case RUNNING: {
                            if (this.parameters.getRunningMode() == Process.RunningMode.NORMAL) {
                                this.runningState = Process.RunningState.NORMAL;
                                break;
                            }
                            this.runningState = Process.RunningState.ADMIN_ONLY;
                            break;
                        }
                        case SUSPENDED: {
                            if (((ControlledProcessStateService)this.controlledProcessStateService.getValue()).getCurrentState() == ControlledProcessState.State.STARTING) {
                                this.runningState = Process.RunningState.STARTING;
                                break;
                            }
                            this.runningState = Process.RunningState.SUSPENDED;
                            break;
                        }
                        case SUSPENDING: {
                            this.runningState = Process.RunningState.SUSPENDING;
                        }
                    }
                } else {
                    CoreManagementLogger.ROOT_LOGGER.debugf("Starting ProcessStateListenerService with a ControllerProcessState of %s", ((ControlledProcessStateService)this.controlledProcessStateService.getValue()).getCurrentState());
                    this.runningState = ((ControlledProcessStateService)this.controlledProcessStateService.getValue()).getCurrentState() == ControlledProcessState.State.STARTING ? Process.RunningState.STARTING : (this.parameters.getRunningMode() == Process.RunningMode.NORMAL ? Process.RunningState.NORMAL : Process.RunningState.ADMIN_ONLY);
                }
                context.complete();
            }
            catch (RuntimeException t) {
                context.failed(new StartException(CoreManagementLogger.ROOT_LOGGER.processStateInitError(t, this.name)));
            }
        };
        try {
            ((ExecutorService)this.executorServiceValue.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        Runnable asyncStop = () -> {
            Object object = this.stopLock;
            synchronized (object) {
                ((ControlledProcessStateService)this.controlledProcessStateService.getValue()).removePropertyChangeListener(this.propertyChangeListener);
                SuspendController controller = (SuspendController)this.suspendControllerInjectedValue.getOptionalValue();
                if (controller != null) {
                    controller.removeListener(this.operationListener);
                }
                this.runningState = null;
                try {
                    this.listener.cleanup();
                }
                catch (RuntimeException t) {
                    CoreManagementLogger.ROOT_LOGGER.processStateCleanupError(t, this.name);
                }
                finally {
                    context.complete();
                }
            }
        };
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        try {
            try {
                executorService.execute(asyncStop);
            }
            catch (RejectedExecutionException e) {
                asyncStop.run();
            }
        }
        finally {
            context.asynchronous();
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }
}

