/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public final class QueryFilters {
    public static final QueryFilters EMPTY_FILTERSET = new QueryFilters();
    private final List<Query> filterQueries;

    private QueryFilters() {
        this.filterQueries = Collections.emptyList();
    }

    public QueryFilters(List<Query> filterQueries) {
        this.filterQueries = filterQueries;
    }

    public Query filterOrPassthrough(Query queryToFilter) {
        if (this.isEmpty()) {
            return queryToFilter;
        }
        BooleanQuery.Builder boolQueryBuilder = new BooleanQuery.Builder();
        boolQueryBuilder.add(queryToFilter, BooleanClause.Occur.MUST);
        for (Query bc : this.filterQueries) {
            boolQueryBuilder.add(bc, BooleanClause.Occur.FILTER);
        }
        return boolQueryBuilder.build();
    }

    public List<Query> getFilterQueries() {
        return this.filterQueries;
    }

    public boolean isEmpty() {
        return this.filterQueries.isEmpty();
    }
}

