/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.oauth2;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.MechanismUtil;
import org.wildfly.security.mechanism.oauth2.OAuth2InitialClientMessage;
import org.wildfly.security.sasl.util.StringPrep;

public class OAuth2Client {
    private static final String KV_DELIMITER = "%x01";
    private final CallbackHandler callbackHandler;
    private final String authorizationId;
    private ElytronMessages log;

    public OAuth2Client(String authorizationId, CallbackHandler callbackHandler, ElytronMessages log) {
        this.authorizationId = authorizationId;
        this.callbackHandler = callbackHandler;
        this.log = log;
    }

    public OAuth2InitialClientMessage getInitialResponse() throws AuthenticationMechanismException {
        CredentialCallback credentialCallback = new CredentialCallback(BearerTokenCredential.class);
        try {
            MechanismUtil.handleCallbacks(this.log, this.callbackHandler, credentialCallback);
        }
        catch (UnsupportedCallbackException e) {
            throw this.log.mechCallbackHandlerUnsupportedCallback(e);
        }
        Assert.assertTrue((boolean)credentialCallback.isCredentialTypeSupported(BearerTokenCredential.class));
        String token = credentialCallback.applyToCredential(BearerTokenCredential.class, BearerTokenCredential::getToken);
        if (token == null) {
            throw this.log.mechNoTokenGiven();
        }
        ByteStringBuilder encoded = new ByteStringBuilder();
        encoded.append("n").append(",");
        if (this.authorizationId != null) {
            encoded.append('a').append('=');
            StringPrep.encode(this.authorizationId, encoded, 1073758207L);
        }
        encoded.append(",").append(KV_DELIMITER).append("auth").append("=").append("Bearer").append(" ").append(token).append(KV_DELIMITER);
        return new OAuth2InitialClientMessage(null, null, encoded.toArray());
    }

    public byte[] handleServerResponse(byte[] serverMessage) {
        if (serverMessage.length == 0) {
            return null;
        }
        try {
            String errorMessage = ByteIterator.ofBytes((byte[])serverMessage).asUtf8String().base64Decode().asUtf8String().drainToString();
            this.log.debugf("Got error message from server [%s].", errorMessage);
        }
        catch (Exception e) {
            this.log.errorf(e, "Server returned an unexpected message that is probably an error but could not be parsed.", new Object[0]);
        }
        return new ByteStringBuilder().append(KV_DELIMITER).toArray();
    }
}

