/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataImporter;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ExportJournalOperation;
import org.wildfly.extension.messaging.activemq.InVMTransportDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ImportJournalOperation
extends AbstractRuntimeOnlyHandler {
    private static AttributeDefinition FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"file", (SimpleAttributeDefinition)PathResourceDefinition.PATH).setAllowExpression(false)).setRequired(true)).build();
    private static AttributeDefinition LEGACY_PREFIXES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"legacy-prefixes", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setAllowExpression(false)).setRequired(false)).build();
    private static final String OPERATION_NAME = "import-journal";
    static final ImportJournalOperation INSTANCE = new ImportJournalOperation();

    private ImportJournalOperation() {
    }

    static void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(OPERATION_NAME, resourceDescriptionResolver).addParameter(FILE).addParameter(LEGACY_PREFIXES).setRuntimeOnly().setReplyValueType(ModelType.BOOLEAN).build(), (OperationStepHandler)INSTANCE);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.NORMAL) {
            throw MessagingLogger.ROOT_LOGGER.managementOperationAllowedOnlyInRunningMode(OPERATION_NAME, RunningMode.NORMAL);
        }
        ExportJournalOperation.checkAllowedOnJournal(context, OPERATION_NAME);
        String file = FILE.resolveModelAttribute(context, operation).asString();
        boolean legacyPrefixes = LEGACY_PREFIXES.resolveModelAttribute(context, operation).asBoolean();
        XmlDataImporter importer = new XmlDataImporter();
        importer.legacyPrefixes = legacyPrefixes;
        TransportConfiguration transportConfiguration = this.createInVMTransportConfiguration(context);
        try (FileInputStream is = new FileInputStream(new File(file));
             ServerLocator serverLocator = ActiveMQClient.createServerLocator((boolean)false, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
             ClientSessionFactory sf = serverLocator.createSessionFactory();){
            ClientSession session = sf.createSession();
            importer.process((InputStream)is, session);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private TransportConfiguration createInVMTransportConfiguration(OperationContext context) throws OperationFailedException {
        Resource serverResource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        Set invmConnectors = serverResource.getChildren("in-vm-connector");
        if (invmConnectors.isEmpty()) {
            throw MessagingLogger.ROOT_LOGGER.noInVMConnector();
        }
        Resource.ResourceEntry connectorEntry = (Resource.ResourceEntry)invmConnectors.iterator().next();
        Resource connectorResource = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{connectorEntry.getPathElement()}), false);
        ModelNode model = connectorResource.getModel();
        HashMap<String, Integer> params = new HashMap<String, Integer>(CommonAttributes.PARAMS.unwrap((ExpressionResolver)context, model));
        params.put(InVMTransportDefinition.SERVER_ID.getName(), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, model).asInt());
        TransportConfiguration transportConfiguration = new TransportConfiguration(InVMConnectorFactory.class.getName(), params);
        return transportConfiguration;
    }
}

