/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ByteOutputStream;
import org.jboss.marshalling.UTFUtils;

public class SimpleDataOutput
extends ByteOutputStream
implements DataOutput {
    protected final int bufferSize;
    protected byte[] buffer;
    private int position;

    public SimpleDataOutput(int bufferSize) {
        this(bufferSize, null);
    }

    public SimpleDataOutput(int bufferSize, ByteOutput byteOutput) {
        super(byteOutput);
        this.byteOutput = byteOutput;
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    public SimpleDataOutput(ByteOutput byteOutput) {
        this(8192, byteOutput);
    }

    private static NotActiveException notActiveException() {
        return new NotActiveException("Output not started");
    }

    @Override
    public void write(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int position = this.position;
            if (position == buffer.length) {
                this.flush();
                buffer[0] = (byte)v;
                this.position = 1;
            } else {
                buffer[position] = (byte)v;
                this.position = position + 1;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        int bl = this.buffer.length;
        int position = this.position;
        if (len > bl - position || len > bl >> 3) {
            this.flush();
            this.byteOutput.write(bytes, off, len);
        } else {
            System.arraycopy(bytes, off, this.buffer, position, len);
            this.position = position + len;
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining == 0) {
                this.flush();
                buffer[0] = (byte)(v ? 1 : 0);
                this.position = 1;
            } else {
                buffer[this.position++] = (byte)(v ? 1 : 0);
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining == 0) {
                this.flush();
                buffer[0] = (byte)v;
                this.position = 1;
            } else {
                buffer[this.position++] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 2) {
                this.flush();
                buffer[0] = (byte)(v >> 8);
                buffer[1] = (byte)v;
                this.position = 2;
            } else {
                int s = this.position;
                this.position = s + 2;
                buffer[s] = (byte)(v >> 8);
                buffer[s + 1] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 2) {
                this.flush();
                buffer[0] = (byte)(v >> 8);
                buffer[1] = (byte)v;
                this.position = 2;
            } else {
                int s = this.position;
                this.position = s + 2;
                buffer[s] = (byte)(v >> 8);
                buffer[s + 1] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 4) {
                this.flush();
                buffer[0] = (byte)(v >> 24);
                buffer[1] = (byte)(v >> 16);
                buffer[2] = (byte)(v >> 8);
                buffer[3] = (byte)v;
                this.position = 4;
            } else {
                int s = this.position;
                this.position = s + 4;
                buffer[s] = (byte)(v >> 24);
                buffer[s + 1] = (byte)(v >> 16);
                buffer[s + 2] = (byte)(v >> 8);
                buffer[s + 3] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 8) {
                this.flush();
                buffer[0] = (byte)(v >> 56);
                buffer[1] = (byte)(v >> 48);
                buffer[2] = (byte)(v >> 40);
                buffer[3] = (byte)(v >> 32);
                buffer[4] = (byte)(v >> 24);
                buffer[5] = (byte)(v >> 16);
                buffer[6] = (byte)(v >> 8);
                buffer[7] = (byte)v;
                this.position = 8;
            } else {
                int s = this.position;
                this.position = s + 8;
                buffer[s] = (byte)(v >> 56);
                buffer[s + 1] = (byte)(v >> 48);
                buffer[s + 2] = (byte)(v >> 40);
                buffer[s + 3] = (byte)(v >> 32);
                buffer[s + 4] = (byte)(v >> 24);
                buffer[s + 5] = (byte)(v >> 16);
                buffer[s + 6] = (byte)(v >> 8);
                buffer[s + 7] = (byte)v;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        try {
            byte[] buffer = this.buffer;
            int remaining = buffer.length - this.position;
            if (remaining < 4) {
                this.flush();
                buffer[0] = (byte)(bits >> 24);
                buffer[1] = (byte)(bits >> 16);
                buffer[2] = (byte)(bits >> 8);
                buffer[3] = (byte)bits;
                this.position = 4;
            } else {
                int s = this.position;
                this.position = s + 4;
                buffer[s] = (byte)(bits >> 24);
                buffer[s + 1] = (byte)(bits >> 16);
                buffer[s + 2] = (byte)(bits >> 8);
                buffer[s + 3] = (byte)bits;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        try {
            int remaining = this.buffer.length - this.position;
            if (remaining < 8) {
                this.flush();
                this.buffer[0] = (byte)(bits >> 56);
                this.buffer[1] = (byte)(bits >> 48);
                this.buffer[2] = (byte)(bits >> 40);
                this.buffer[3] = (byte)(bits >> 32);
                this.buffer[4] = (byte)(bits >> 24);
                this.buffer[5] = (byte)(bits >> 16);
                this.buffer[6] = (byte)(bits >> 8);
                this.buffer[7] = (byte)bits;
                this.position = 8;
            } else {
                int s = this.position;
                this.position = s + 8;
                this.buffer[s] = (byte)(bits >> 56);
                this.buffer[s + 1] = (byte)(bits >> 48);
                this.buffer[s + 2] = (byte)(bits >> 40);
                this.buffer[s + 3] = (byte)(bits >> 32);
                this.buffer[s + 4] = (byte)(bits >> 24);
                this.buffer[s + 5] = (byte)(bits >> 16);
                this.buffer[s + 6] = (byte)(bits >> 8);
                this.buffer[s + 7] = (byte)bits;
            }
        }
        catch (NullPointerException e) {
            throw SimpleDataOutput.notActiveException();
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.writeShort(UTFUtils.getShortUTFLength(s));
        UTFUtils.writeUTFBytes(this, s);
    }

    @Override
    public void flush() throws IOException {
        int pos = this.position;
        ByteOutput byteOutput = this.byteOutput;
        if (byteOutput != null) {
            if (pos > 0) {
                byteOutput.write(this.buffer, 0, pos);
            }
            this.position = 0;
            byteOutput.flush();
        }
    }

    protected void shallowFlush() throws IOException {
        int pos = this.position;
        ByteOutput byteOutput = this.byteOutput;
        if (byteOutput != null) {
            if (pos > 0) {
                byteOutput.write(this.buffer, 0, pos);
            }
            this.position = 0;
        }
    }

    protected void start(ByteOutput byteOutput) throws IOException {
        this.byteOutput = byteOutput;
        this.buffer = new byte[this.bufferSize];
    }

    protected void finish() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.buffer = null;
            this.byteOutput = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.byteOutput.close();
    }
}

