/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;

public final class SaslUtils {
    private SaslUtils() {
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslServerFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories() {
        return SaslUtils.getFactories(SaslServerFactory.class, null, true);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslClientFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories() {
        return SaslUtils.getFactories(SaslClientFactory.class, null, true);
    }

    private static <T> Iterator<T> getFactories(Class<T> type, ClassLoader classLoader, boolean includeGlobal) {
        LinkedHashSet factories = new LinkedHashSet();
        ServiceLoader<T> loader = ServiceLoader.load(type, classLoader);
        for (T factory : loader) {
            factories.add(factory);
        }
        if (includeGlobal) {
            Provider[] providers;
            HashSet loadedClasses = new HashSet();
            String filter = type.getSimpleName() + ".";
            for (Provider currentProvider : providers = Security.getProviders()) {
                ClassLoader cl = currentProvider.getClass().getClassLoader();
                currentProvider.keySet().stream().filter(currentKey -> currentKey instanceof String && ((String)currentKey).startsWith(filter) && ((String)currentKey).indexOf(32) < 0).forEach(currentKey -> {
                    String className = currentProvider.getProperty((String)currentKey);
                    if (className != null && loadedClasses.add(className)) {
                        try {
                            factories.add(Class.forName(className, true, cl).asSubclass(type).newInstance());
                        }
                        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        return factories.iterator();
    }

    public static SaslServerFactory getSaslServerFactory(String mech, Map<String, ?> props) {
        Iterator<SaslServerFactory> saslFactories = SaslUtils.getSaslServerFactories(SaslUtils.class.getClassLoader(), true);
        while (saslFactories.hasNext()) {
            SaslServerFactory saslFactory = saslFactories.next();
            for (String supportedMech : saslFactory.getMechanismNames(props)) {
                if (!supportedMech.equals(mech)) continue;
                return saslFactory;
            }
        }
        throw new IllegalArgumentException("No SASL server factory for mech " + mech);
    }

    public static SaslClientFactory getSaslClientFactory(String mech, Map<String, ?> props) {
        Iterator<SaslClientFactory> saslFactories = SaslUtils.getSaslClientFactories(SaslUtils.class.getClassLoader(), true);
        while (saslFactories.hasNext()) {
            SaslClientFactory saslFactory = saslFactories.next();
            for (String supportedMech : saslFactory.getMechanismNames(props)) {
                if (!mech.equals(supportedMech)) continue;
                return saslFactory;
            }
        }
        throw new IllegalArgumentException("No SASL client factory for mech " + mech);
    }
}

