/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.Path;
import org.eclipse.microprofile.opentracing.Traced;

@Traced
@Interceptor
@Priority(value=1001)
public class SmallRyeTracingCDIInterceptor {
    @Inject
    private Tracer tracer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object interceptTraced(InvocationContext ctx) throws Exception {
        try (Scope activeScope = null;){
            if (!this.isJaxRs(ctx.getMethod()) && this.isTraced(ctx.getMethod())) {
                activeScope = this.tracer.buildSpan(this.getOperationName(ctx.getMethod())).startActive(true);
            }
            Object object = ctx.proceed();
            return object;
        }
    }

    protected boolean isJaxRs(Method method) {
        return method.getAnnotation(Path.class) != null || method.getDeclaringClass().getAnnotation(Path.class) != null;
    }

    protected boolean isTraced(Method method) {
        Traced classTraced = method.getDeclaringClass().getAnnotation(Traced.class);
        Traced methodTraced = method.getAnnotation(Traced.class);
        if (methodTraced != null) {
            return methodTraced.value();
        }
        return classTraced != null ? classTraced.value() : false;
    }

    protected String getOperationName(Method method) {
        Traced classTraced = method.getDeclaringClass().getAnnotation(Traced.class);
        Traced methodTraced = method.getAnnotation(Traced.class);
        if (methodTraced != null && methodTraced.operationName().length() > 0) {
            return methodTraced.operationName();
        }
        if (classTraced != null && classTraced.operationName().length() > 0) {
            return classTraced.operationName();
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), method.getName());
    }
}

