/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.wildfly.mod_cluster.undertow.LocationContext;
import org.wildfly.mod_cluster.undertow.UndertowContext;

public class UndertowHost
implements Host {
    private org.wildfly.extension.undertow.Host host;
    private Engine engine;

    public UndertowHost(org.wildfly.extension.undertow.Host host, Engine engine) {
        this.engine = engine;
        this.host = host;
    }

    public String getName() {
        return this.host.getName();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Iterable<Context> getContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Deployment deployment : this.host.getDeployments()) {
            contexts.add(new UndertowContext(deployment, this));
        }
        for (String path : this.host.getLocations()) {
            contexts.add(new LocationContext(path, this));
        }
        return contexts;
    }

    public Set<String> getAliases() {
        return this.host.getAllAliases();
    }

    public Context findContext(String path) {
        String findPath = "".equals(path) ? "/" : path;
        for (Deployment deployment : this.host.getDeployments()) {
            if (!deployment.getDeploymentInfo().getContextPath().equals(findPath)) continue;
            return new UndertowContext(deployment, this);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowHost)) {
            return false;
        }
        UndertowHost host = (UndertowHost)object;
        return this.getName().equals(host.getName());
    }

    public int hashCode() {
        return this.host.getName().hashCode();
    }

    public String toString() {
        return this.host.getName();
    }
}

