/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;

public class TrustDomainService
implements Service<TrustDomainService> {
    private static final String SERVICE_NAME = "TrustDomainService";
    private final String domainName;
    private final InjectedValue<IdentityProviderService> identityProviderService = new InjectedValue();

    public TrustDomainService(String domainName) {
        this.domainName = domainName;
    }

    public static ServiceName createServiceName(String identityProviderName, String domainName) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, identityProviderName + "." + domainName});
    }

    public TrustDomainService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((IdentityProviderService)this.getIdentityProviderService().getValue()).addTrustedDomain(this.domainName);
    }

    public void stop(StopContext context) {
        ((IdentityProviderService)this.getIdentityProviderService().getValue()).removeTrustedDomain(this.domainName);
        context.getController().setMode(ServiceController.Mode.REMOVE);
    }

    public InjectedValue<IdentityProviderService> getIdentityProviderService() {
        return this.identityProviderService;
    }
}

