/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

public class ScopedRoleRequiredHandler
implements OperationStepHandler {
    private final String roleName;

    private ScopedRoleRequiredHandler(String roleName) {
        this.roleName = roleName;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set hostScopedRoles = resource.getChildrenNames("host-scoped-role");
        Set serverGroupScopedRoles = resource.getChildrenNames("server-group-scoped-role");
        if (!hostScopedRoles.contains(this.roleName) && !serverGroupScopedRoles.contains(this.roleName)) {
            throw DomainManagementLogger.ROOT_LOGGER.invalidRoleNameDomain(this.roleName);
        }
    }

    static void addOperation(OperationContext context, String roleName) {
        ModelNode operation = Util.createEmptyOperation((String)"scoped-role-check", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT}));
        context.addStep(operation, (OperationStepHandler)new ScopedRoleRequiredHandler(roleName), OperationContext.Stage.MODEL);
    }
}

