/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.security.Principal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.event.AbstractSTSEvent;
import org.apache.cxf.sts.event.STSEventListener;
import org.apache.cxf.sts.operation.DefaultTokenWrapper;
import org.apache.cxf.sts.operation.TokenWrapper;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestParser;
import org.apache.cxf.sts.request.RequestRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.service.ServiceMBean;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationParameters;
import org.apache.cxf.sts.token.delegation.TokenDelegationResponse;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.sts.token.realm.RelationshipResolver;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.secext.KeyIdentifierType;
import org.apache.cxf.ws.security.sts.provider.model.secext.ReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.secext.SecurityTokenReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.utility.AttributedDateTime;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractOperation {
    public static final QName TOKEN_TYPE = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11");
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractOperation.class);
    protected STSPropertiesMBean stsProperties;
    protected boolean encryptIssuedToken;
    protected List<ServiceMBean> services;
    protected List<TokenProvider> tokenProviders = new ArrayList<TokenProvider>();
    protected List<TokenValidator> tokenValidators = new ArrayList<TokenValidator>();
    protected boolean returnReferences = true;
    protected TokenStore tokenStore;
    protected ClaimsManager claimsManager = new ClaimsManager();
    protected STSEventListener eventPublisher;
    protected List<TokenDelegationHandler> delegationHandlers = new ArrayList<TokenDelegationHandler>();
    protected TokenWrapper tokenWrapper = new DefaultTokenWrapper();
    protected boolean allowCustomContent;
    protected boolean includeLifetimeElement = true;

    public boolean isAllowCustomContent() {
        return this.allowCustomContent;
    }

    public void setAllowCustomContent(boolean allowCustomContent) {
        this.allowCustomContent = allowCustomContent;
    }

    public TokenWrapper getTokenWrapper() {
        return this.tokenWrapper;
    }

    public void setTokenWrapper(TokenWrapper tokenWrapper) {
        this.tokenWrapper = tokenWrapper;
    }

    public boolean isReturnReferences() {
        return this.returnReferences;
    }

    public void setReturnReferences(boolean returnReferences) {
        this.returnReferences = returnReferences;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setStsProperties(STSPropertiesMBean stsProperties) {
        this.stsProperties = stsProperties;
    }

    public void setEncryptIssuedToken(boolean encryptIssuedToken) {
        this.encryptIssuedToken = encryptIssuedToken;
    }

    public void setServices(List<ServiceMBean> services) {
        this.services = services;
    }

    public void setTokenProviders(List<TokenProvider> tokenProviders) {
        this.tokenProviders = tokenProviders;
    }

    public List<TokenDelegationHandler> getDelegationHandlers() {
        return this.delegationHandlers;
    }

    public void setDelegationHandlers(List<TokenDelegationHandler> delegationHandlers) {
        this.delegationHandlers = delegationHandlers;
    }

    public List<TokenProvider> getTokenProviders() {
        return this.tokenProviders;
    }

    public void setTokenValidators(List<TokenValidator> tokenValidators) {
        this.tokenValidators = tokenValidators;
    }

    public List<TokenValidator> getTokenValidators() {
        return this.tokenValidators;
    }

    public ClaimsManager getClaimsManager() {
        return this.claimsManager;
    }

    public void setClaimsManager(ClaimsManager claimsManager) {
        this.claimsManager = claimsManager;
    }

    public void setIncludeLifetimeElement(boolean value) {
        this.includeLifetimeElement = value;
    }

    public boolean isIncludeLifetimeElement() {
        return this.includeLifetimeElement;
    }

    protected RequestRequirements parseRequest(RequestSecurityTokenType request, Map<String, Object> messageContext) {
        if (messageContext == null) {
            throw new STSException("No message context found");
        }
        if (this.stsProperties == null) {
            throw new STSException("No STSProperties object found");
        }
        this.stsProperties.configureProperties();
        RequestParser requestParser = new RequestParser();
        requestParser.setAllowCustomContent(this.allowCustomContent);
        return requestParser.parseRequest(request, messageContext, this.stsProperties, this.claimsManager.getClaimParsers());
    }

    protected static RequestedReferenceType createRequestedReference(TokenReference tokenReference, boolean attached) {
        RequestedReferenceType requestedReferenceType = QNameConstants.WS_TRUST_FACTORY.createRequestedReferenceType();
        SecurityTokenReferenceType securityTokenReferenceType = QNameConstants.WSSE_FACTORY.createSecurityTokenReferenceType();
        String tokenType = tokenReference.getWsse11TokenType();
        if (tokenType != null) {
            securityTokenReferenceType.getOtherAttributes().put(TOKEN_TYPE, tokenType);
        }
        if (tokenReference.isUseKeyIdentifier()) {
            String identifier = XMLUtils.getIDFromReference((String)tokenReference.getIdentifier());
            KeyIdentifierType keyIdentifierType = QNameConstants.WSSE_FACTORY.createKeyIdentifierType();
            keyIdentifierType.setValue(identifier);
            String valueType = tokenReference.getWsseValueType();
            if (valueType != null) {
                keyIdentifierType.setValueType(valueType);
            }
            JAXBElement keyIdentifier = QNameConstants.WSSE_FACTORY.createKeyIdentifier(keyIdentifierType);
            securityTokenReferenceType.getAny().add(keyIdentifier);
        } else if (tokenReference.isUseDirectReference()) {
            String identifier = tokenReference.getIdentifier();
            if (attached && identifier.charAt(0) != '#') {
                identifier = "#" + identifier;
            } else if (!attached && identifier.charAt(0) == '#') {
                identifier = identifier.substring(1);
            }
            ReferenceType referenceType = QNameConstants.WSSE_FACTORY.createReferenceType();
            referenceType.setURI(identifier);
            String valueType = tokenReference.getWsseValueType();
            if (valueType != null) {
                referenceType.setValueType(valueType);
            }
            JAXBElement reference = QNameConstants.WSSE_FACTORY.createReference(referenceType);
            securityTokenReferenceType.getAny().add(reference);
        }
        requestedReferenceType.setSecurityTokenReference(securityTokenReferenceType);
        return requestedReferenceType;
    }

    protected static RequestedReferenceType createRequestedReference(String tokenId, String tokenType, boolean attached) {
        TokenReference tokenReference = new TokenReference();
        tokenReference.setIdentifier(tokenId);
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
            tokenReference.setWsse11TokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            tokenReference.setUseKeyIdentifier(true);
            tokenReference.setWsseValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            tokenReference.setWsse11TokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            tokenReference.setUseKeyIdentifier(true);
            tokenReference.setWsseValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        } else {
            tokenReference.setUseDirectReference(true);
            tokenReference.setWsseValueType(tokenType);
        }
        return AbstractOperation.createRequestedReference(tokenReference, attached);
    }

    protected static LifetimeType createLifetime(Instant tokenCreated, Instant tokenExpires) {
        AttributedDateTime created = QNameConstants.UTIL_FACTORY.createAttributedDateTime();
        AttributedDateTime expires = QNameConstants.UTIL_FACTORY.createAttributedDateTime();
        Instant now = Instant.now();
        Instant creationTime = tokenCreated;
        if (tokenCreated == null) {
            creationTime = now;
        }
        Instant expirationTime = tokenExpires;
        if (tokenExpires == null) {
            long lifeTimeOfToken = 300L;
            expirationTime = now.plusSeconds(lifeTimeOfToken);
        }
        created.setValue(creationTime.atZone(ZoneOffset.UTC).format(DateUtil.getDateTimeFormatter((boolean)true)));
        expires.setValue(expirationTime.atZone(ZoneOffset.UTC).format(DateUtil.getDateTimeFormatter((boolean)true)));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Token lifetime creation: " + created.getValue());
            LOG.fine("Token lifetime expiration: " + expires.getValue());
        }
        LifetimeType lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetimeType();
        lifetimeType.setCreated(created);
        lifetimeType.setExpires(expires);
        return lifetimeType;
    }

    protected Element encryptSecret(byte[] secret, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements) throws WSSecurityException {
        String name = encryptionProperties.getEncryptionName();
        if (name == null) {
            name = this.stsProperties.getEncryptionUsername();
        }
        if (name == null) {
            throw new STSException("No encryption alias is configured", STSException.REQUEST_FAILED);
        }
        String keyWrapAlgorithm = keyRequirements.getKeywrapAlgorithm();
        if (keyWrapAlgorithm == null) {
            keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedKeyWrapAlgorithms();
            if (!supportedAlgorithms.contains(keyWrapAlgorithm)) {
                keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("KeyWrapAlgorithm not supported, defaulting to: " + keyWrapAlgorithm);
                }
            }
        }
        Document doc = DOMUtils.getEmptyDocument();
        WSSecEncryptedKey builder = new WSSecEncryptedKey(doc);
        builder.setUserInfo(name);
        builder.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        builder.setEphemeralKey(secret);
        builder.setKeyEncAlgo(keyWrapAlgorithm);
        builder.prepare(this.stsProperties.getEncryptionCrypto());
        return builder.getEncryptedKeyElement();
    }

    protected String extractAddressFromAppliesTo(Element appliesTo) {
        LOG.fine("Parsing AppliesTo element");
        if (appliesTo != null) {
            Element uri;
            Element endpointRef = DOMUtils.getFirstChildWithName((Element)appliesTo, (String)"http://www.w3.org/2005/08/addressing", (String)"EndpointReference");
            if (endpointRef != null) {
                LOG.fine("Found EndpointReference element");
                Element address = DOMUtils.getFirstChildWithName((Element)endpointRef, (String)"http://www.w3.org/2005/08/addressing", (String)"Address");
                if (address != null) {
                    LOG.fine("Found address element");
                    return address.getTextContent();
                }
            } else if (appliesTo.getNamespaceURI() != null && (uri = DOMUtils.getFirstChildWithName((Element)appliesTo, (String)appliesTo.getNamespaceURI(), (String)"URI")) != null) {
                LOG.fine("Found URI element");
                return uri.getTextContent();
            }
        }
        LOG.fine("AppliesTo element does not exist or could not be parsed");
        return null;
    }

    protected TokenProviderParameters createTokenProviderParameters(RequestRequirements requestRequirements, Principal principal, Map<String, Object> messageContext) {
        TokenProviderParameters providerParameters = new TokenProviderParameters();
        providerParameters.setStsProperties(this.stsProperties);
        providerParameters.setPrincipal(principal);
        providerParameters.setMessageContext(messageContext);
        providerParameters.setTokenStore(this.getTokenStore());
        providerParameters.setEncryptToken(this.encryptIssuedToken);
        KeyRequirements keyRequirements = requestRequirements.getKeyRequirements();
        TokenRequirements tokenRequirements = requestRequirements.getTokenRequirements();
        providerParameters.setKeyRequirements(keyRequirements);
        providerParameters.setTokenRequirements(tokenRequirements);
        String address = this.extractAddressFromAppliesTo(tokenRequirements.getAppliesTo());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("The AppliesTo address that has been received is: " + address);
        }
        providerParameters.setAppliesToAddress(address);
        if (this.stsProperties.getRealmParser() != null) {
            RealmParser realmParser = this.stsProperties.getRealmParser();
            String realm = realmParser.parseRealm(messageContext);
            providerParameters.setRealm(realm);
        }
        ClaimCollection claims = tokenRequirements.getPrimaryClaims();
        providerParameters.setRequestedPrimaryClaims(claims);
        claims = tokenRequirements.getSecondaryClaims();
        providerParameters.setRequestedSecondaryClaims(claims);
        EncryptionProperties encryptionProperties = this.stsProperties.getEncryptionProperties();
        if (address != null) {
            boolean foundService = false;
            if (this.services != null) {
                for (ServiceMBean service : this.services) {
                    if (!service.isAddressInEndpoints(address)) continue;
                    EncryptionProperties svcEncryptionProperties = service.getEncryptionProperties();
                    if (svcEncryptionProperties != null) {
                        encryptionProperties = svcEncryptionProperties;
                    }
                    if (tokenRequirements.getTokenType() == null) {
                        String tokenType = service.getTokenType();
                        tokenRequirements.setTokenType(tokenType);
                        LOG.fine("Using default token type of: " + tokenType);
                    }
                    if (keyRequirements.getKeyType() == null) {
                        String keyType = service.getKeyType();
                        keyRequirements.setKeyType(keyType);
                        LOG.fine("Using default key type of: " + keyType);
                    }
                    foundService = true;
                    break;
                }
            }
            if (!foundService) {
                String msg = "No service corresponding to " + address + " is known. Check 'services' property configuration in SecurityTokenServiceProvider";
                LOG.log(Level.SEVERE, msg);
                throw new STSException(msg, STSException.REQUEST_FAILED);
            }
        }
        providerParameters.setEncryptionProperties(encryptionProperties);
        return providerParameters;
    }

    protected TokenValidatorResponse validateReceivedToken(Principal principal, Map<String, Object> messageContext, String realm, TokenRequirements tokenRequirements, ReceivedToken token) {
        token.setState(ReceivedToken.STATE.NONE);
        TokenRequirements validateRequirements = new TokenRequirements();
        validateRequirements.setValidateTarget(token);
        TokenValidatorParameters validatorParameters = new TokenValidatorParameters();
        validatorParameters.setStsProperties(this.stsProperties);
        validatorParameters.setPrincipal(principal);
        validatorParameters.setMessageContext(messageContext);
        validatorParameters.setTokenStore(this.getTokenStore());
        validatorParameters.setKeyRequirements(null);
        validatorParameters.setTokenRequirements(validateRequirements);
        validatorParameters.setToken(token);
        if (this.tokenValidators.isEmpty()) {
            LOG.fine("No token validators have been configured to validate the received token");
        }
        TokenValidatorResponse tokenResponse = null;
        for (TokenValidator tokenValidator : this.tokenValidators) {
            boolean canHandle = false;
            canHandle = realm == null ? tokenValidator.canHandleToken(token) : tokenValidator.canHandleToken(token, realm);
            if (!canHandle) continue;
            try {
                tokenResponse = tokenValidator.validateToken(validatorParameters);
                token = tokenResponse.getToken();
                token.setPrincipal(tokenResponse.getPrincipal());
                token.setRoles(tokenResponse.getRoles());
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "Failed to validate the token", ex);
                token.setState(ReceivedToken.STATE.INVALID);
            }
            break;
        }
        if (tokenResponse == null) {
            LOG.fine("No token validator has been configured to validate the received token");
        }
        return tokenResponse;
    }

    protected void performDelegationHandling(RequestRequirements requestRequirements, Principal principal, Map<String, Object> messageContext, ReceivedToken token, Principal tokenPrincipal, Set<Principal> tokenRoles) {
        TokenDelegationParameters delegationParameters = new TokenDelegationParameters();
        delegationParameters.setStsProperties(this.stsProperties);
        delegationParameters.setPrincipal(principal);
        delegationParameters.setMessageContext(messageContext);
        delegationParameters.setTokenStore(this.getTokenStore());
        delegationParameters.setTokenPrincipal(tokenPrincipal);
        delegationParameters.setTokenRoles(tokenRoles);
        KeyRequirements keyRequirements = requestRequirements.getKeyRequirements();
        TokenRequirements tokenRequirements = requestRequirements.getTokenRequirements();
        delegationParameters.setKeyRequirements(keyRequirements);
        delegationParameters.setTokenRequirements(tokenRequirements);
        String address = this.extractAddressFromAppliesTo(tokenRequirements.getAppliesTo());
        delegationParameters.setAppliesToAddress(address);
        delegationParameters.setToken(token);
        TokenDelegationResponse tokenResponse = null;
        for (TokenDelegationHandler delegationHandler : this.delegationHandlers) {
            if (!delegationHandler.canHandleToken(token)) continue;
            try {
                tokenResponse = delegationHandler.isDelegationAllowed(delegationParameters);
                break;
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in delegation handling", (Throwable)ex, STSException.REQUEST_FAILED);
            }
        }
        if (tokenResponse == null || !tokenResponse.isDelegationAllowed()) {
            LOG.log(Level.WARNING, "No matching token delegation handler found");
            throw new STSException("No matching token delegation handler found", STSException.REQUEST_FAILED);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processValidToken(TokenProviderParameters providerParameters, ReceivedToken validatedToken, TokenValidatorResponse tokenResponse) {
        Principal responsePrincipal = tokenResponse.getPrincipal();
        if (responsePrincipal == null) return;
        String targetRealm = providerParameters.getRealm();
        String sourceRealm = tokenResponse.getTokenRealm();
        if (sourceRealm == null) return;
        if (targetRealm == null) return;
        if (sourceRealm.equals(targetRealm)) return;
        RelationshipResolver relRes = this.stsProperties.getRelationshipResolver();
        Relationship relationship = null;
        if (relRes != null && (relationship = relRes.resolveRelationship(sourceRealm, targetRealm)) != null) {
            tokenResponse.getAdditionalProperties().put(Relationship.class.getName(), relationship);
        }
        if (relationship == null || relationship.getType().equals("FederatedIdentity")) {
            IdentityMapper identityMapper = null;
            identityMapper = relationship == null ? this.stsProperties.getIdentityMapper() : relationship.getIdentityMapper();
            if (identityMapper != null) {
                Principal targetPrincipal = identityMapper.mapPrincipal(sourceRealm, responsePrincipal, targetRealm);
                validatedToken.setPrincipal(targetPrincipal);
                return;
            }
            LOG.log(Level.SEVERE, "No IdentityMapper configured in STSProperties or Relationship");
            throw new STSException("Error in providing a token", STSException.REQUEST_FAILED);
        }
        if (relationship.getType().equals("FederatedClaims")) {
            return;
        }
        LOG.log(Level.SEVERE, "Unknown federation type: " + relationship.getType());
        throw new STSException("Error in providing a token", STSException.BAD_REQUEST);
    }

    public void setEventListener(STSEventListener eventListener) {
        this.eventPublisher = eventListener;
    }

    protected void publishEvent(AbstractSTSEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.handleSTSEvent(event);
        }
    }

    protected static SecurityToken findInboundSecurityToken(SecurityEventConstants.Event event, Map<String, Object> messageContext) throws XMLSecurityException {
        List incomingEventList = (List)messageContext.get(SecurityEvent.class.getName() + ".in");
        if (incomingEventList != null) {
            for (SecurityEvent incomingEvent : incomingEventList) {
                if (event != incomingEvent.getSecurityEventType()) continue;
                return ((TokenSecurityEvent)incomingEvent).getSecurityToken();
            }
        }
        return null;
    }
}

