/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;

public final class BridgeConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    private String name = null;
    private String queueName = null;
    private String forwardingAddress = null;
    private String filterString = null;
    private List<String> staticConnectors = null;
    private String discoveryGroupName = null;
    private boolean ha = false;
    private TransformerConfiguration transformerConfiguration = null;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    private int initialConnectAttempts = ActiveMQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts();
    private int reconnectAttempts = ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts();
    private int reconnectAttemptsOnSameNode = ActiveMQDefaultConfiguration.getDefaultBridgeConnectSameNode();
    private boolean useDuplicateDetection = ActiveMQDefaultConfiguration.isDefaultBridgeDuplicateDetection();
    private int confirmationWindowSize = -1;
    private int producerWindowSize = ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize();
    private long clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    private String user = ActiveMQDefaultConfiguration.getDefaultClusterUser();
    private String password = ActiveMQDefaultConfiguration.getDefaultClusterPassword();
    private long connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
    private long maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
    private int minLargeMessageSize = 102400;
    private long callTimeout = 30000L;

    public String getName() {
        return this.name;
    }

    public BridgeConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public BridgeConfiguration setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public BridgeConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public BridgeConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public BridgeConfiguration setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
        return this;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public BridgeConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfiguration;
    }

    public BridgeConfiguration setTransformerConfiguration(TransformerConfiguration transformerConfiguration) {
        this.transformerConfiguration = transformerConfiguration;
        return this;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public BridgeConfiguration setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
        return this;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public BridgeConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public boolean isHA() {
        return this.ha;
    }

    public BridgeConfiguration setHA(boolean ha) {
        this.ha = ha;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public BridgeConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public BridgeConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public BridgeConfiguration setInitialConnectAttempts(int initialConnectAttempts) {
        this.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public BridgeConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    public BridgeConfiguration setUseDuplicateDetection(boolean useDuplicateDetection) {
        this.useDuplicateDetection = useDuplicateDetection;
        return this;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public BridgeConfiguration setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public BridgeConfiguration setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public BridgeConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public BridgeConfiguration setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public BridgeConfiguration setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public BridgeConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public int getReconnectAttemptsOnSameNode() {
        return this.reconnectAttemptsOnSameNode;
    }

    public BridgeConfiguration setReconnectAttemptsOnSameNode(int reconnectAttemptsOnSameNode) {
        this.reconnectAttemptsOnSameNode = reconnectAttemptsOnSameNode;
        return this;
    }

    public BridgeConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.callTimeout ^ this.callTimeout >>> 32);
        result = 31 * result + (int)(this.clientFailureCheckPeriod ^ this.clientFailureCheckPeriod >>> 32);
        result = 31 * result + this.confirmationWindowSize;
        result = 31 * result + this.producerWindowSize;
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        result = 31 * result + (this.discoveryGroupName == null ? 0 : this.discoveryGroupName.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.ha ? 1231 : 1237);
        result = 31 * result + (int)(this.maxRetryInterval ^ this.maxRetryInterval >>> 32);
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + this.initialConnectAttempts;
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        long temp = Double.doubleToLongBits(this.retryIntervalMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.staticConnectors == null ? 0 : this.staticConnectors.hashCode());
        result = 31 * result + (this.transformerConfiguration == null ? 0 : this.transformerConfiguration.hashCode());
        result = 31 * result + (this.useDuplicateDetection ? 1231 : 1237);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeConfiguration other = (BridgeConfiguration)obj;
        if (this.callTimeout != other.callTimeout) {
            return false;
        }
        if (this.clientFailureCheckPeriod != other.clientFailureCheckPeriod) {
            return false;
        }
        if (this.confirmationWindowSize != other.confirmationWindowSize) {
            return false;
        }
        if (this.producerWindowSize != other.producerWindowSize) {
            return false;
        }
        if (this.connectionTTL != other.connectionTTL) {
            return false;
        }
        if (this.discoveryGroupName == null ? other.discoveryGroupName != null : !this.discoveryGroupName.equals(other.discoveryGroupName)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.ha != other.ha) {
            return false;
        }
        if (this.maxRetryInterval != other.maxRetryInterval) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.initialConnectAttempts != other.initialConnectAttempts) {
            return false;
        }
        if (this.reconnectAttempts != other.reconnectAttempts) {
            return false;
        }
        if (this.retryInterval != other.retryInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.retryIntervalMultiplier) != Double.doubleToLongBits(other.retryIntervalMultiplier)) {
            return false;
        }
        if (this.staticConnectors == null ? other.staticConnectors != null : !this.staticConnectors.equals(other.staticConnectors)) {
            return false;
        }
        if (this.transformerConfiguration == null ? other.transformerConfiguration != null : !this.transformerConfiguration.equals(other.transformerConfiguration)) {
            return false;
        }
        if (this.useDuplicateDetection != other.useDuplicateDetection) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

