/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationLargeMessageEndMessage
extends PacketImpl {
    long messageId;
    long pendingRecordId;

    public ReplicationLargeMessageEndMessage() {
        super((byte)100);
    }

    public ReplicationLargeMessageEndMessage(long messageId, long pendingRecordId) {
        this();
        this.messageId = messageId;
        this.pendingRecordId = -pendingRecordId;
    }

    public int expectedEncodeSize() {
        return 29;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeLong(this.pendingRecordId);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.messageId = buffer.readLong();
        if (buffer.readableBytes() >= 8) {
            this.pendingRecordId = buffer.readLong();
        }
    }

    public long getMessageId() {
        return this.messageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        return result;
    }

    public String toString() {
        return "ReplicationLargeMessageEndMessage{messageId=" + this.messageId + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationLargeMessageEndMessage other = (ReplicationLargeMessageEndMessage)((Object)obj);
        return this.messageId == other.messageId;
    }

    public long getPendingRecordId() {
        return this.pendingRecordId;
    }
}

