/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.MultiphaseOverallContext;
import org.jboss.as.domain.controller.operations.coordination.ServerRequireRestartTask;
import org.jboss.as.domain.controller.plan.RolloutPlanController;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.threads.AsyncFuture;

public class DomainRolloutStepHandler
implements OperationStepHandler {
    private final MultiphaseOverallContext multiphaseContext;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final ExecutorService executorService;
    private final ModelNode serverOperationHeaders;
    private final ModelNode providedRolloutPlan;
    private final boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();

    public DomainRolloutStepHandler(Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, MultiphaseOverallContext multiphaseContext, ModelNode rolloutPlan, ModelNode serverOperationHeaders, ExecutorService executorService) {
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.multiphaseContext = multiphaseContext;
        this.serverOperationHeaders = serverOperationHeaders.clone();
        this.providedRolloutPlan = rolloutPlan;
        this.executorService = executorService;
        if (this.serverOperationHeaders.hasDefined("caller-type") && this.serverOperationHeaders.get("caller-type").asString().equals("user")) {
            this.serverOperationHeaders.remove("caller-type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean pushToServers;
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            return;
        }
        context.attachIfAbsent(CompositeOperationHandler.DOMAIN_EXECUTION_KEY, (Object)Boolean.TRUE);
        final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getDomainBlockingTimeout((OperationContext)context);
        boolean bl = pushToServers = !this.multiphaseContext.hasHostLevelFailures();
        if (pushToServers) {
            ModelNode ourResult = this.multiphaseContext.getLocalContext().getLocalResponse();
            if (ourResult.has("failure-description")) {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator failed: %s", ourResult);
                }
                pushToServers = false;
                this.multiphaseContext.setCompleteRollback(true);
            } else {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator succeeded: %s", ourResult);
                }
                for (ModelNode hostResult : this.multiphaseContext.getHostControllerPreparedResults().values()) {
                    if (!hostResult.has("failure-description")) continue;
                    if (this.trace) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("host failed: %s", hostResult);
                    }
                    pushToServers = false;
                    this.multiphaseContext.setCompleteRollback(true);
                    break;
                }
            }
        }
        if (pushToServers) {
            this.multiphaseContext.setCompleteRollback(false);
            final HashMap<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks = new HashMap<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest>();
            final ArrayList<ServerTaskExecutor.ServerPreparedResponse> preparedResults = new ArrayList<ServerTaskExecutor.ServerPreparedResponse>();
            boolean completeStepCalled = false;
            try {
                this.pushToServers(context, submittedTasks, preparedResults, blockingTimeout);
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        DomainRolloutStepHandler.this.finalizeOp(context, submittedTasks, preparedResults, blockingTimeout);
                    }
                });
                completeStepCalled = true;
            }
            finally {
                if (!completeStepCalled) {
                    this.finalizeOp(context, submittedTasks, preparedResults, blockingTimeout);
                }
            }
        } else {
            this.reportHostFailures(context, operation);
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeOp(OperationContext context, Map<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks, List<ServerTaskExecutor.ServerPreparedResponse> preparedResults, BlockingTimeout blockingTimeout) {
        boolean interrupted = false;
        boolean completeRollback = this.multiphaseContext.isCompleteRollback();
        String localHostName = this.multiphaseContext.getLocalHostInfo().getLocalHostName();
        for (ServerTaskExecutor.ServerPreparedResponse preparedResult : preparedResults) {
            boolean rollback = completeRollback || this.multiphaseContext.isServerGroupRollback(preparedResult.getServerGroupName());
            interrupted = Thread.interrupted() || interrupted;
            ServerIdentity identity = preparedResult.getServerIdentity();
            if (preparedResult.isTimedOut()) {
                HostControllerLogger.ROOT_LOGGER.serverSuspected(identity.getServerName(), identity.getHostName());
            }
            if (preparedResult.finalizeTransaction(!rollback)) continue;
            try {
                ModelNode result = preparedResult.getPreparedOperation().getPreparedResult();
                ProxyController proxy = this.hostProxies.get(identity.getHostName());
                if (proxy == null && localHostName.equals(identity.getHostName()) && (proxy = this.serverProxies.get(identity.getServerName())) == null) {
                    if (!this.trace) continue;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("No proxy for %s", identity);
                    continue;
                }
                OperationResponse originalResponse = OperationResponse.Factory.createSimple((ModelNode)result);
                Future<OperationResponse> future = this.executorService.submit(new ServerRequireRestartTask(identity, proxy, originalResponse, blockingTimeout));
                submittedTasks.put(identity, new ServerTaskExecutor.ExecutedServerRequest(identity, future));
            }
            catch (Exception result) {}
        }
        try {
            int patient = interrupted ? 50 : blockingTimeout.getDomainBlockingTimeout(this.multiphaseContext.getLocalHostInfo().isMasterDomainController());
            for (Map.Entry<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> entry : submittedTasks.entrySet()) {
                ServerTaskExecutor.ExecutedServerRequest request = entry.getValue();
                ServerIdentity sid = entry.getKey();
                Future<OperationResponse> future = request.getFinalResult();
                try {
                    OperationResponse finalResponse = future.isCancelled() ? this.getCancelledResult() : future.get(patient, TimeUnit.MILLISECONDS);
                    ModelNode untransformedResponse = finalResponse.getResponseNode();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final response from %s is %s (untransformed)", sid, untransformedResponse);
                    ModelNode transformedResult = request.transformResult(untransformedResponse);
                    ResponseAttachmentInputStreamSupport.handleDomainOperationResponseStreams((OperationContext)context, (ModelNode)transformedResult, (List)finalResponse.getInputStreams());
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Transformed final response from %s is %s", sid, transformedResult);
                    this.multiphaseContext.addServerResult(sid, transformedResult);
                }
                catch (InterruptedException e) {
                    this.cancelPreferAsync(future, true);
                    interrupted = true;
                    patient = patient == 0 ? 0 : 50;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(sid.getServerName(), sid.getHostName());
                }
                catch (ExecutionException e) {
                    this.cancelPreferAsync(future, true);
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), sid.getServerName(), sid.getHostName());
                }
                catch (TimeoutException e) {
                    this.cancelPreferAsync(future, true);
                    if (interrupted) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(sid.getServerName(), sid.getHostName());
                    } else {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingFinalResponse(patient, sid.getServerName(), sid.getHostName());
                    }
                    patient = 0;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void cancelPreferAsync(Future<?> future, boolean mayInterruptIfRunning) {
        if (future instanceof AsyncFuture) {
            ((AsyncFuture)future).asyncCancel(mayInterruptIfRunning);
        } else {
            future.cancel(mayInterruptIfRunning);
        }
    }

    private OperationResponse getCancelledResult() {
        ModelNode cancelled = new ModelNode();
        cancelled.get("outcome").set("cancelled");
        return OperationResponse.Factory.createSimple((ModelNode)cancelled);
    }

    private void pushToServers(OperationContext context, Map<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks, List<ServerTaskExecutor.ServerPreparedResponse> preparedResults, final BlockingTimeout blockingTimeout) throws OperationFailedException {
        Map<String, Map<ServerIdentity, ModelNode>> opsByGroup;
        final String localHostName = this.multiphaseContext.getLocalHostInfo().getLocalHostName();
        HashMap<String, ModelNode> hostResults = new HashMap<String, ModelNode>(this.multiphaseContext.getHostControllerPreparedResults());
        ModelNode coordinatorOps = this.multiphaseContext.getLocalContext().getLocalServerOps();
        if (coordinatorOps.isDefined()) {
            ModelNode localNode = new ModelNode();
            localNode.get(new String[]{"result", "server-operations"}).set(coordinatorOps);
            hostResults.put(localHostName, localNode);
        }
        if ((opsByGroup = this.getOpsByGroup(hostResults)).size() > 0) {
            ModelNode rolloutPlan = this.getRolloutPlan(this.providedRolloutPlan, opsByGroup);
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan is %s", rolloutPlan);
            }
            final Transformers.TransformationInputs transformationInputs = Transformers.TransformationInputs.getOrCreate((OperationContext)context);
            ServerTaskExecutor taskExecutor = new ServerTaskExecutor(context, submittedTasks, preparedResults){

                @Override
                protected int execute(TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation> listener, ServerIdentity server, ModelNode original) throws OperationFailedException {
                    String hostName = server.getHostName();
                    ProxyController proxy = (ProxyController)DomainRolloutStepHandler.this.hostProxies.get(hostName);
                    if (proxy == null) {
                        if (localHostName.equals(hostName)) {
                            proxy = (ProxyController)DomainRolloutStepHandler.this.serverProxies.get(server.getServerName());
                        }
                        if (proxy == null) {
                            if (DomainRolloutStepHandler.this.trace) {
                                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("No proxy for %s", server);
                            }
                            return -1;
                        }
                    }
                    TransformingProxyController remoteProxyController = (TransformingProxyController)proxy;
                    OperationTransformer.TransformedOperation transformed = DomainRolloutStepHandler.this.multiphaseContext.transformServerOperation(hostName, remoteProxyController, transformationInputs, original);
                    ModelNode transformedOperation = transformed.getTransformedOperation();
                    OperationResultTransformer resultTransformer = transformed.getResultTransformer();
                    TransactionalProtocolClient client = remoteProxyController.getProtocolClient();
                    if (this.executeOperation(listener, client, server, transformedOperation, resultTransformer)) {
                        return blockingTimeout.getProxyBlockingTimeout(server.toPathAddress(), (ProxyController)remoteProxyController);
                    }
                    return -1;
                }
            };
            RolloutPlanController rolloutPlanController = new RolloutPlanController(opsByGroup, rolloutPlan, this.multiphaseContext, taskExecutor, this.executorService, blockingTimeout);
            RolloutPlanController.Result planResult = rolloutPlanController.execute();
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan result is %s", (Object)planResult);
            }
            if (planResult == RolloutPlanController.Result.FAILED || planResult == RolloutPlanController.Result.PARTIAL && this.multiphaseContext.isCompleteRollback()) {
                this.multiphaseContext.setCompleteRollback(true);
                context.getResult();
                context.getFailureDescription().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.operationFailedOrRolledBack());
                this.multiphaseContext.setFailureReported(true);
            }
        }
    }

    private Map<String, Map<ServerIdentity, ModelNode>> getOpsByGroup(Map<String, ModelNode> hostResults) {
        HashMap<String, Map<ServerIdentity, ModelNode>> result = new HashMap<String, Map<ServerIdentity, ModelNode>>();
        for (Map.Entry<String, ModelNode> entry : hostResults.entrySet()) {
            ModelNode hostResult;
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("1st phase result from host %s is %s", entry.getKey(), entry.getValue());
            }
            if (!(hostResult = entry.getValue().get("result")).hasDefined("server-operations")) continue;
            String host = entry.getKey();
            for (ModelNode item : hostResult.get("server-operations").asList()) {
                ModelNode op = this.translateDomainMappedOperation(item.require("operation"));
                for (Property prop : item.require("servers").asPropertyList()) {
                    String group = prop.getValue().asString();
                    HashMap<ServerIdentity, ModelNode> groupMap = (HashMap<ServerIdentity, ModelNode>)result.get(group);
                    if (groupMap == null) {
                        groupMap = new HashMap<ServerIdentity, ModelNode>();
                        result.put(group, groupMap);
                    }
                    groupMap.put(new ServerIdentity(host, group, prop.getName()), op);
                }
            }
        }
        return result;
    }

    private ModelNode translateDomainMappedOperation(ModelNode domainMappedOperation) {
        if (domainMappedOperation.hasDefined("operation")) {
            return this.incorporateServerOperationHeaders(domainMappedOperation);
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        ModelNode steps = composite.get("steps").setEmptyList();
        for (Property property : domainMappedOperation.asPropertyList()) {
            steps.add(this.translateDomainMappedOperation(property.getValue()));
        }
        return this.incorporateServerOperationHeaders(composite);
    }

    private ModelNode incorporateServerOperationHeaders(ModelNode op) {
        if (this.serverOperationHeaders.isDefined()) {
            if (op.hasDefined("operation-headers")) {
                ModelNode headers = op.get("operation-headers");
                for (Property prop : this.serverOperationHeaders.asPropertyList()) {
                    headers.get(prop.getName()).set(prop.getValue());
                }
            } else {
                op.get("operation-headers").set(this.serverOperationHeaders);
            }
        }
        return op;
    }

    private ModelNode getRolloutPlan(ModelNode rolloutPlan, Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) throws OperationFailedException {
        if (rolloutPlan == null || !rolloutPlan.isDefined()) {
            rolloutPlan = this.getDefaultRolloutPlan(opsByGroup);
        } else {
            HashSet<String> found = new HashSet<String>();
            if (rolloutPlan.hasDefined("in-series")) {
                for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                    if (series.hasDefined("concurrent-groups")) {
                        for (Property prop : series.get("concurrent-groups").asPropertyList()) {
                            this.validateServerGroupPlan(found, prop);
                        }
                        continue;
                    }
                    if (series.hasDefined("server-group")) {
                        Property prop = series.get("server-group").asProperty();
                        this.validateServerGroupPlan(found, prop);
                        continue;
                    }
                    throw new OperationFailedException(DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidRolloutPlan(series, "in-series"));
                }
            }
            HashSet<String> groups = new HashSet<String>(opsByGroup.keySet());
            groups.removeAll(found);
            if (!groups.isEmpty()) {
                throw new OperationFailedException(DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidRolloutPlan(groups));
            }
        }
        return rolloutPlan;
    }

    private void validateServerGroupPlan(Set<String> found, Property prop) throws OperationFailedException {
        int max;
        if (!found.add(prop.getName())) {
            throw new OperationFailedException(DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidRolloutPlanGroupAlreadyExists(prop.getName()));
        }
        ModelNode plan = prop.getValue();
        if (plan.hasDefined("max-failure-percentage")) {
            if (plan.has("max-failed-servers")) {
                plan.remove("max-failed-servers");
            }
            if ((max = plan.get("max-failure-percentage").asInt()) < 0 || max > 100) {
                throw new OperationFailedException(DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidRolloutPlanRange(prop.getName(), "max-failure-percentage", max));
            }
        }
        if (plan.hasDefined("max-failed-servers") && (max = plan.get("max-failed-servers").asInt()) < 0) {
            throw new OperationFailedException(DomainControllerLogger.HOST_CONTROLLER_LOGGER.invalidRolloutPlanLess(prop.getName(), "max-failed-servers", max));
        }
    }

    private ModelNode getDefaultRolloutPlan(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) {
        ModelNode result = new ModelNode();
        if (opsByGroup.size() > 0) {
            ModelNode groups = result.get("in-series").add().get("concurrent-groups");
            ModelNode groupPlan = new ModelNode();
            groupPlan.get("rolling-to-servers").set(false);
            groupPlan.get("max-failed-servers").set(0);
            for (String group : opsByGroup.keySet()) {
                groups.add(group, groupPlan);
            }
            result.get("rollback-across-groups").set(true);
        }
        return result;
    }

    private void reportHostFailures(OperationContext context, ModelNode operation) {
        boolean isDomain = this.isDomainOperation(operation);
        if (!this.collectDomainFailure(context, isDomain)) {
            this.collectHostFailures(context, isDomain);
        }
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.multiphaseContext.getLocalContext().getLocalResponse();
        ModelNode domainFailure = null;
        if (isDomain && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            this.multiphaseContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.multiphaseContext.getHostControllerPreparedResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.multiphaseContext.getLocalContext().getLocalResponse();
        if (!isDomain && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerLogger.HOST_CONTROLLER_LOGGER.unexplainedFailure());
            hostFailureResults.add(this.multiphaseContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            this.multiphaseContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }
}

