/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactoryServiceConfiguratorConfiguration;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryServiceConfiguratorFactory;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.NodeFactory;

public class InfinispanBeanManagerFactoryServiceConfigurator<I, T>
extends SimpleServiceNameProvider
implements ServiceConfigurator,
InfinispanBeanManagerFactoryConfiguration {
    private final BeanContext context;
    private final BeanManagerFactoryServiceConfiguratorConfiguration configuration;
    private final SupplierDependency<Cache> cache;
    private final SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private final SupplierDependency<MarshallingConfigurationRepository> repository;
    private final SupplierDependency<ScheduledExecutorService> scheduler;
    private final SupplierDependency<NodeFactory<Address>> group;
    private final SupplierDependency<Registry<String, ?>> registry;
    private final SupplierDependency<CommandDispatcherFactory> dispatcherFactory;

    public InfinispanBeanManagerFactoryServiceConfigurator(CapabilityServiceSupport support, String name, BeanContext context, BeanManagerFactoryServiceConfiguratorConfiguration configuration) {
        super(context.getDeploymentUnitServiceName().append(new String[]{context.getBeanName()}).append(new String[]{"bean-manager"}));
        this.context = context;
        this.configuration = configuration;
        ServiceName deploymentUnitServiceName = context.getDeploymentUnitServiceName();
        String containerName = configuration.getContainerName();
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, InfinispanBeanManagerFactoryServiceConfiguratorFactory.getCacheName(deploymentUnitServiceName)));
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.repository = new ServiceSupplierDependency(deploymentUnitServiceName.append(new String[]{"marshalling"}));
        this.scheduler = new ServiceSupplierDependency(deploymentUnitServiceName.append(new String[]{name, "expiration"}));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.registry = new ServiceSupplierDependency(ClusteringCacheRequirement.REGISTRY.getServiceName(support, containerName, "client-mappings"));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, "client-mappings"));
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        new CompositeDependency(new Dependency[]{this.cache, this.affinityFactory, this.repository, this.scheduler, this.group, this.registry, this.dispatcherFactory}).register(builder);
        Consumer factory = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, new InfinispanBeanManagerFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public BeanContext getBeanContext() {
        return this.context;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    @Override
    public MarshallingConfigurationRepository getMarshallingConfigurationRepository() {
        return (MarshallingConfigurationRepository)this.repository.get();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return (ScheduledExecutorService)this.scheduler.get();
    }

    @Override
    public BeanPassivationConfiguration getPassivationConfiguration() {
        return this.configuration;
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.group.get();
    }

    @Override
    public Registry<String, ?> getRegistry() {
        return (Registry)this.registry.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }
}

