/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.configuration.cache.StoreConfiguration;

public class PersistenceConfiguration
implements Matchable<PersistenceConfiguration> {
    public static final AttributeDefinition<Boolean> PASSIVATION = AttributeDefinition.builder((String)"passivation", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> AVAILABILITY_INTERVAL = AttributeDefinition.builder((String)"availabilityInterval", (Object)1000).immutable().build();
    public static final AttributeDefinition<Integer> CONNECTION_ATTEMPTS = AttributeDefinition.builder((String)"connectionAttempts", (Object)10).immutable().build();
    public static final AttributeDefinition<Integer> CONNECTION_INTERVAL = AttributeDefinition.builder((String)"connectionInterval", (Object)50).immutable().build();
    private final Attribute<Boolean> passivation;
    private final Attribute<Integer> availabilityInterval;
    private final Attribute<Integer> connectionAttempts;
    private final Attribute<Integer> connectionInterval;
    private final AttributeSet attributes;
    private final List<StoreConfiguration> stores;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PersistenceConfiguration.class, new AttributeDefinition[]{PASSIVATION, AVAILABILITY_INTERVAL, CONNECTION_ATTEMPTS, CONNECTION_INTERVAL});
    }

    PersistenceConfiguration(AttributeSet attributes, List<StoreConfiguration> stores) {
        this.attributes = attributes.checkProtection();
        this.passivation = attributes.attribute(PASSIVATION);
        this.availabilityInterval = attributes.attribute(AVAILABILITY_INTERVAL);
        this.connectionAttempts = attributes.attribute(CONNECTION_ATTEMPTS);
        this.connectionInterval = attributes.attribute(CONNECTION_INTERVAL);
        this.stores = stores;
    }

    public boolean passivation() {
        return (Boolean)this.passivation.get();
    }

    public int availabilityInterval() {
        return (Integer)this.availabilityInterval.get();
    }

    public int connectionAttempts() {
        return (Integer)this.connectionAttempts.get();
    }

    public int connectionInterval() {
        return (Integer)this.connectionInterval.get();
    }

    public List<StoreConfiguration> stores() {
        return this.stores;
    }

    public Boolean fetchPersistentState() {
        for (StoreConfiguration c : this.stores) {
            if (!c.fetchPersistentState()) continue;
            return true;
        }
        return false;
    }

    public Boolean preload() {
        for (StoreConfiguration c : this.stores) {
            if (!c.preload()) continue;
            return true;
        }
        return false;
    }

    public boolean usingStores() {
        return !this.stores.isEmpty();
    }

    public boolean usingAsyncStore() {
        for (StoreConfiguration c : this.stores) {
            if (!c.async().enabled()) continue;
            return true;
        }
        return false;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "PersistenceConfiguration [attributes=" + this.attributes + ", stores=" + this.stores + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceConfiguration other = (PersistenceConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        return !(this.stores == null ? other.stores != null : !this.stores.equals(other.stores));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.stores == null ? 0 : this.stores.hashCode());
        return result;
    }
}

