/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentsJmxRegistration {
    private static final Log log = LogFactory.getLog(ComponentsJmxRegistration.class);
    private MBeanServer mBeanServer;
    private String jmxDomain;
    private String groupName;
    public static String COMPONENT_KEY = "component";
    public static String NAME_KEY = "name";

    public ComponentsJmxRegistration(MBeanServer mBeanServer, String groupName) {
        this.mBeanServer = mBeanServer;
        this.groupName = groupName;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void registerMBeans(Collection<ResourceDMBean> resourceDMBeans) throws CacheException {
        try {
            for (ResourceDMBean resource : resourceDMBeans) {
                JmxUtil.registerMBean((Object)resource, (ObjectName)this.getObjectName(resource), (MBeanServer)this.mBeanServer);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering mbeans", (Throwable)e);
        }
    }

    public void unregisterMBeans(Collection<ResourceDMBean> resourceDMBeans) throws CacheException {
        log.trace("Unregistering jmx resources..");
        try {
            for (ResourceDMBean resource : resourceDMBeans) {
                JmxUtil.unregisterMBean((ObjectName)this.getObjectName(resource), (MBeanServer)this.mBeanServer);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering mbeans", (Throwable)e);
        }
    }

    private ObjectName getObjectName(ResourceDMBean resource) throws Exception {
        return this.getObjectName(resource.getObjectName());
    }

    protected ObjectName getObjectName(String resourceName) throws Exception {
        return new ObjectName(ComponentsJmxRegistration.getObjectName(this.jmxDomain, this.groupName, resourceName));
    }

    public static String getObjectName(String jmxDomain, String groupName, String resourceName) {
        return jmxDomain + ":" + groupName + "," + COMPONENT_KEY + "=" + resourceName;
    }
}

