/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingManagerImpl
implements PartitionHandlingManager {
    private static final Log log = LogFactory.getLog(PartitionHandlingManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<GlobalTransaction, TransactionInfo> partialTransactions;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    @ComponentName(value="cacheName")
    @Inject
    private String cacheName;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private LocalTopologyManager localTopologyManager;
    @Inject
    private CacheNotifier notifier;
    @Inject
    private CommandsFactory commandsFactory;
    @Inject
    private Configuration configuration;
    @Inject
    private RpcManager rpcManager;
    @Inject
    private LockManager lockManager;
    @Inject
    private Transport transport;
    private boolean isVersioned;
    private PartitionHandling partitionHandling;

    public PartitionHandlingManagerImpl() {
        this.partialTransactions = CollectionFactory.makeConcurrentMap();
    }

    @Start
    public void start() {
        this.isVersioned = Configurations.isTxVersioned(this.configuration);
        this.partitionHandling = this.configuration.clustering().partitionHandling().whenSplit();
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    @Override
    public void setAvailabilityMode(AvailabilityMode availabilityMode) {
        if (availabilityMode != this.availabilityMode) {
            log.debugf("Updating availability for cache %s: %s -> %s", this.cacheName, (Object)this.availabilityMode, (Object)availabilityMode);
            this.notifier.notifyPartitionStatusChanged(availabilityMode, true);
            this.availabilityMode = availabilityMode;
            this.notifier.notifyPartitionStatusChanged(availabilityMode, false);
        }
    }

    @Override
    public void checkWrite(Object key) {
        this.doCheck(key, true, 0L);
    }

    @Override
    public void checkRead(Object key, long flagBitSet) {
        this.doCheck(key, false, flagBitSet);
    }

    @Override
    public void checkClear() {
        if (!this.isOperationAllowed(true, 0L)) {
            throw log.clearDisallowedWhilePartitioned();
        }
    }

    @Override
    public void checkBulkRead() {
        if (!this.isOperationAllowed(false, 0L)) {
            throw log.partitionDegraded();
        }
    }

    @Override
    public CacheTopology getLastStableTopology() {
        return this.localTopologyManager.getStableCacheTopology(this.cacheName);
    }

    @Override
    public boolean addPartialRollbackTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
        if (trace) {
            log.tracef("Added partially rollback transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new RollbackTransactionInfo(globalTransaction, affectedNodes, lockedKeys));
        return true;
    }

    @Override
    public boolean addPartialCommit2PCTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, EntryVersionsMap newVersions) {
        if (trace) {
            log.tracef("Added partially committed (2PC) transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new Commit2PCTransactionInfo(globalTransaction, affectedNodes, lockedKeys, newVersions));
        return true;
    }

    @Override
    public boolean addPartialCommit1PCTransaction(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, List<WriteCommand> modifications) {
        if (trace) {
            log.tracef("Added partially committed (1PC) transaction %s", globalTransaction);
        }
        this.partialTransactions.put(globalTransaction, new Commit1PCTransactionInfo(globalTransaction, affectedNodes, lockedKeys, modifications));
        return true;
    }

    @Override
    public boolean isTransactionPartiallyCommitted(GlobalTransaction globalTransaction) {
        boolean partiallyCommitted;
        TransactionInfo transactionInfo = this.partialTransactions.get(globalTransaction);
        boolean bl = partiallyCommitted = transactionInfo != null && !transactionInfo.isRolledBack();
        if (trace) {
            log.tracef("Can release resources for transaction %s? %s. Transaction info=%s", globalTransaction, !partiallyCommitted, transactionInfo);
        }
        return partiallyCommitted;
    }

    @Override
    public Collection<GlobalTransaction> getPartialTransactions() {
        return Collections.unmodifiableCollection(this.partialTransactions.keySet());
    }

    @Override
    public boolean canRollbackTransactionAfterOriginatorLeave(GlobalTransaction globalTransaction) {
        boolean canRollback;
        boolean bl = canRollback = this.availabilityMode == AvailabilityMode.AVAILABLE && !this.getLastStableTopology().getActualMembers().contains(globalTransaction.getAddress());
        if (trace) {
            log.tracef("Can rollback transaction? %s", canRollback);
        }
        return canRollback;
    }

    @Override
    public void onTopologyUpdate(CacheTopology cacheTopology) {
        boolean isStable = this.isTopologyStable(cacheTopology);
        if (isStable) {
            if (trace) {
                log.tracef("On stable topology update. Pending txs: %d", this.partialTransactions.size());
            }
            for (TransactionInfo transactionInfo : this.partialTransactions.values()) {
                this.completeTransaction(transactionInfo, cacheTopology);
            }
        }
    }

    private void completeTransaction(TransactionInfo transactionInfo, CacheTopology cacheTopology) {
        List<Address> commitNodes = transactionInfo.getCommitNodes(cacheTopology);
        TransactionBoundaryCommand command = transactionInfo.buildCommand(this.commandsFactory, this.isVersioned);
        command.setTopologyId(cacheTopology.getTopologyId());
        CompletionStage<Map<Address, Response>> remoteInvocation = commitNodes != null ? this.rpcManager.invokeCommand(commitNodes, (ReplicableCommand)command, MapResponseCollector.validOnly(commitNodes.size()), this.rpcManager.getSyncRpcOptions()) : this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        remoteInvocation.whenComplete((responseMap, throwable) -> {
            GlobalTransaction globalTransaction = transactionInfo.getGlobalTransaction();
            if (throwable != null) {
                if (trace) {
                    log.tracef((Throwable)throwable, "Exception for transaction %s. Retry later.", globalTransaction);
                }
                return;
            }
            if (trace) {
                log.tracef("Future done for transaction %s. Response are %s", globalTransaction, responseMap);
            }
            for (Response response : responseMap.values()) {
                if (response != UnsureResponse.INSTANCE && response != CacheNotFoundResponse.INSTANCE) continue;
                if (trace) {
                    log.tracef("Another partition or topology changed for transaction %s. Retry later.", globalTransaction);
                }
                return;
            }
            if (trace) {
                log.tracef("Performing cleanup for transaction %s", globalTransaction);
            }
            this.lockManager.unlock(transactionInfo.getLockedKeys(), globalTransaction);
            this.partialTransactions.remove(globalTransaction);
            TxCompletionNotificationCommand completionCommand = this.commandsFactory.buildTxCompletionNotificationCommand(null, globalTransaction);
            this.rpcManager.sendToAll(completionCommand, DeliverOrder.NONE);
        });
    }

    private boolean isTopologyStable(CacheTopology cacheTopology) {
        CacheTopology stableTopology = this.localTopologyManager.getStableCacheTopology(this.cacheName);
        if (trace) {
            log.tracef("Check if topology %s is stable. Last stable topology is %s", cacheTopology, stableTopology);
        }
        return stableTopology != null && cacheTopology.getActualMembers().containsAll(stableTopology.getActualMembers()) && cacheTopology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION;
    }

    protected void doCheck(Object key, boolean isWrite, long flagBitSet) {
        if (trace) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)this.availabilityMode);
        }
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return;
        }
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        List<Address> owners = cacheTopology.getDistribution(key).writeOwners();
        List<Address> actualMembers = cacheTopology.getActualMembers();
        boolean operationAllowed = this.isOperationAllowed(isWrite, flagBitSet);
        if (!actualMembers.containsAll(owners) && !operationAllowed) {
            if (trace) {
                log.tracef("Partition is in %s mode, PartitionHandling is set to to %s, access is not allowed for key %s", (Object)this.availabilityMode, (Object)this.partitionHandling, key);
            }
            throw log.degradedModeKeyUnavailable(key);
        }
        if (trace) {
            log.tracef("Key %s is available.", key);
        }
    }

    protected boolean isOperationAllowed(boolean isWrite, long flagBitSet) {
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return true;
        }
        switch (this.partitionHandling) {
            case ALLOW_READ_WRITES: {
                return true;
            }
            case ALLOW_READS: {
                if (EnumUtil.containsAny((long)flagBitSet, (long)FlagBitSets.FORCE_WRITE_LOCK)) {
                    throw log.degradedModeLockUnavailable();
                }
                return !isWrite;
            }
        }
        return false;
    }

    private static abstract class BaseTransactionInfo
    implements TransactionInfo {
        private final GlobalTransaction globalTransaction;
        private final Collection<Address> affectedNodes;
        private final Collection<Object> lockedKeys;

        protected BaseTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
            this.globalTransaction = globalTransaction;
            this.lockedKeys = lockedKeys;
            this.affectedNodes = affectedNodes;
        }

        @Override
        public final List<Address> getCommitNodes(CacheTopology stableTopology) {
            if (this.affectedNodes == null) {
                return null;
            }
            ArrayList<Address> commitNodes = new ArrayList<Address>(this.affectedNodes);
            commitNodes.retainAll(stableTopology.getActualMembers());
            return commitNodes;
        }

        @Override
        public final GlobalTransaction getGlobalTransaction() {
            return this.globalTransaction;
        }

        @Override
        public Collection<Object> getLockedKeys() {
            return this.lockedKeys;
        }

        public String toString() {
            return "TransactionInfo{globalTransaction=" + this.globalTransaction + ", rollback=" + this.isRolledBack() + ", affectedNodes=" + this.affectedNodes + '}';
        }
    }

    private static class Commit1PCTransactionInfo
    extends BaseTransactionInfo {
        private final List<WriteCommand> modifications;

        public Commit1PCTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, List<WriteCommand> modifications) {
            super(globalTransaction, affectedNodes, lockedKeys);
            this.modifications = modifications;
        }

        @Override
        public boolean isRolledBack() {
            return false;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory, boolean isVersioned) {
            if (isVersioned) {
                throw new IllegalArgumentException("Cannot build a versioned one-phase-commit prepare command.");
            }
            return commandsFactory.buildPrepareCommand(this.getGlobalTransaction(), this.modifications, true);
        }
    }

    private static class Commit2PCTransactionInfo
    extends BaseTransactionInfo {
        private final EntryVersionsMap newVersions;

        public Commit2PCTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys, EntryVersionsMap newVersions) {
            super(globalTransaction, affectedNodes, lockedKeys);
            this.newVersions = newVersions;
        }

        @Override
        public boolean isRolledBack() {
            return false;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory, boolean isVersioned) {
            if (isVersioned) {
                VersionedCommitCommand commitCommand = commandsFactory.buildVersionedCommitCommand(this.getGlobalTransaction());
                commitCommand.setUpdatedVersions(this.newVersions);
                return commitCommand;
            }
            return commandsFactory.buildCommitCommand(this.getGlobalTransaction());
        }
    }

    private static class RollbackTransactionInfo
    extends BaseTransactionInfo {
        protected RollbackTransactionInfo(GlobalTransaction globalTransaction, Collection<Address> affectedNodes, Collection<Object> lockedKeys) {
            super(globalTransaction, affectedNodes, lockedKeys);
        }

        @Override
        public boolean isRolledBack() {
            return true;
        }

        @Override
        public TransactionBoundaryCommand buildCommand(CommandsFactory commandsFactory, boolean isVersioned) {
            return commandsFactory.buildRollbackCommand(this.getGlobalTransaction());
        }
    }

    private static interface TransactionInfo {
        public boolean isRolledBack();

        public List<Address> getCommitNodes(CacheTopology var1);

        public TransactionBoundaryCommand buildCommand(CommandsFactory var1, boolean var2);

        public GlobalTransaction getGlobalTransaction();

        public Collection<Object> getLockedKeys();
    }
}

