/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.lang.reflect.Proxy;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassUnwrapper;
import org.apache.cxf.common.util.SpringAopClassHelper;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;

public class ClassHelper {
    public static final String USE_DEFAULT_CLASS_HELPER = "org.apache.cxf.useDefaultClassHelpers";
    static final ClassHelper HELPER;
    static final ClassHelper DEFAULT_HELPER;

    protected ClassHelper() {
    }

    private static ClassHelper getClassHelper(ClassHelper defaultHelper) {
        boolean useSpring = true;
        String s = SystemPropertyAction.getPropertyOrNull("org.apache.cxf.useSpringClassHelpers");
        if (!StringUtils.isEmpty(s)) {
            boolean bl = useSpring = "1".equals(s) || Boolean.parseBoolean(s);
        }
        if (useSpring) {
            try {
                return new SpringAopClassHelper();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultHelper;
    }

    protected Class<?> getRealClassInternal(Object o) {
        return this.getRealObjectInternal(o).getClass();
    }

    protected Class<?> getRealClassFromClassInternal(Class<?> cls) {
        return cls;
    }

    protected Object getRealObjectInternal(Object o) {
        return o instanceof Proxy ? Proxy.getInvocationHandler(o) : o;
    }

    public static Class<?> getRealClass(Object o) {
        return ClassHelper.getRealClass(null, o);
    }

    public static Class<?> getRealClassFromClass(Class<?> cls) {
        return ClassHelper.getRealClassFromClass(null, cls);
    }

    public static Class<?> getRealClassFromClass(Bus bus, Class<?> cls) {
        bus = ClassHelper.getBus(bus);
        return ClassHelper.getContextClassHelper(bus).getRealClassFromClassInternal(cls);
    }

    public static Object getRealObject(Object o) {
        Bus bus = ClassHelper.getBus(null);
        return ClassHelper.getContextClassHelper(bus).getRealObjectInternal(o);
    }

    public static Class<?> getRealClass(Bus bus, Object o) {
        if ((bus = ClassHelper.getBus(bus)) != null && bus.getProperty(ClassUnwrapper.class.getName()) != null) {
            ClassUnwrapper unwrapper = (ClassUnwrapper)bus.getProperty(ClassUnwrapper.class.getName());
            return unwrapper.getRealClass(o);
        }
        return ClassHelper.getContextClassHelper(bus).getRealClassInternal(o);
    }

    private static ClassHelper getContextClassHelper(Bus bus) {
        return DEFAULT_HELPER == HELPER || ClassHelper.checkUseDefaultClassHelper(bus) ? DEFAULT_HELPER : HELPER;
    }

    private static Bus getBus(Bus bus) {
        return bus == null ? BusFactory.getThreadDefaultBus() : bus;
    }

    private static boolean checkUseDefaultClassHelper(Bus bus) {
        return bus != null && Boolean.TRUE.equals(bus.getProperty(USE_DEFAULT_CLASS_HELPER));
    }

    static {
        DEFAULT_HELPER = new ClassHelper();
        HELPER = ClassHelper.getClassHelper(DEFAULT_HELPER);
    }
}

