/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class RemovableIterator<C>
implements Iterator<C> {
    protected final Iterator<C> realIterator;
    protected final Consumer<? super C> consumer;
    protected C previousValue;
    protected C currentValue;

    public RemovableIterator(Iterator<C> realIterator, Consumer<? super C> consumer) {
        this.realIterator = realIterator;
        this.consumer = consumer;
    }

    protected C getNextFromIterator() {
        if (this.realIterator.hasNext()) {
            return this.realIterator.next();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue != null || (this.currentValue = this.getNextFromIterator()) != null;
    }

    @Override
    public C next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.previousValue = this.currentValue;
        this.currentValue = null;
        return this.previousValue;
    }

    @Override
    public void remove() {
        if (this.previousValue == null) {
            throw new IllegalStateException();
        }
        this.consumer.accept(this.previousValue);
        this.previousValue = null;
    }
}

