/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

@Listener(sync=false)
public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<SessionAttributeNamesEntry> {
    private final Cache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache;
    private final Cache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final CacheProperties properties;

    public FineSessionAttributesFactory(Cache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache, Cache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, CacheProperties properties) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public SessionAttributeNamesEntry createValue(String id, Void context) {
        SessionAttributeNamesEntry entry = new SessionAttributeNamesEntry(new AtomicInteger(), new ConcurrentHashMap<String, Integer>());
        this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new SessionAttributeNamesKey(id), (Object)entry);
        return entry;
    }

    public SessionAttributeNamesEntry findValue(String id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (entry != null) {
            for (Map.Entry nameEntry : entry.getNames().entrySet()) {
                Object value = this.attributeCache.get((Object)new SessionAttributeKey(id, (Integer)nameEntry.getValue()));
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (InvalidSerializedFormException e) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)nameEntry.getKey());
                    }
                } else {
                    InfinispanWebLogger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)nameEntry.getKey());
                }
                this.remove(id);
                return null;
            }
        }
        return entry;
    }

    public boolean remove(String id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)new SessionAttributeNamesKey(id));
        if (entry == null) {
            return false;
        }
        for (Integer attributeId : entry.getNames().values()) {
            this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributeKey(id, attributeId));
        }
        return true;
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, SessionAttributeNamesEntry entry) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        CacheEntryMutator mutator = this.properties.isTransactional() && this.namesCache.getAdvancedCache().getCacheEntry((Object)key).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.namesCache, (Object)key, (Object)entry);
        return new FineSessionAttributes<V>(id, entry.getSequence(), entry.getNames(), (Mutator)mutator, this.attributeCache, this.marshaller, this.properties);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, SessionAttributeNamesEntry entry) {
        return new FineImmutableSessionAttributes<V>(id, entry.getNames(), this.attributeCache, this.marshaller);
    }

    @CacheEntriesEvicted
    public void evicted(CacheEntriesEvictedEvent<Key<String>, ?> event) {
        if (!event.isPre()) {
            HashSet<SessionAttributeNamesKey> keys = new HashSet<SessionAttributeNamesKey>();
            for (Key key : event.getEntries().keySet()) {
                if (!(key instanceof SessionCreationMetaDataKey)) continue;
                keys.add(new SessionAttributeNamesKey((String)key.getValue()));
            }
            if (!keys.isEmpty()) {
                AdvancedCache cache = this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
                for (Map.Entry entry : this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).getAll(keys).entrySet()) {
                    SessionAttributeNamesEntry namesEntry = (SessionAttributeNamesEntry)entry.getValue();
                    if (namesEntry != null) {
                        String sessionId = (String)((SessionAttributeNamesKey)((Object)entry.getKey())).getValue();
                        Iterator iterator = namesEntry.getNames().values().iterator();
                        while (iterator.hasNext()) {
                            int attributeId = (Integer)iterator.next();
                            cache.evict((Object)new SessionAttributeKey(sessionId, attributeId));
                        }
                    }
                    this.namesCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).evict(entry.getKey());
                }
            }
        }
    }
}

