/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.oa.poa.Policies;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.CorbaInboundConnectionCacheImpl;
import com.sun.corba.se.impl.transport.CorbaOutboundConnectionCacheImpl;
import com.sun.corba.se.impl.transport.SelectorImpl;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.ByteBufferPool;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.ior.IORTemplate;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaAcceptor;
import com.sun.corba.se.spi.transport.CorbaTransportManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorbaTransportManagerImpl
implements CorbaTransportManager {
    protected ORB orb;
    protected List acceptors;
    protected Map outboundConnectionCaches;
    protected Map inboundConnectionCaches;
    protected Selector selector;

    public CorbaTransportManagerImpl(ORB orb) {
        this.orb = orb;
        this.acceptors = new ArrayList();
        this.outboundConnectionCaches = new HashMap();
        this.inboundConnectionCaches = new HashMap();
        this.selector = new SelectorImpl(orb);
    }

    @Override
    public ByteBufferPool getByteBufferPool(int id) {
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundConnectionCache getOutboundConnectionCache(ContactInfo contactInfo) {
        ContactInfo contactInfo2 = contactInfo;
        synchronized (contactInfo2) {
            if (contactInfo.getConnectionCache() == null) {
                OutboundConnectionCache connectionCache = null;
                Map map = this.outboundConnectionCaches;
                synchronized (map) {
                    connectionCache = (OutboundConnectionCache)this.outboundConnectionCaches.get(contactInfo.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaOutboundConnectionCacheImpl(this.orb, contactInfo);
                        this.outboundConnectionCaches.put(contactInfo.getConnectionCacheType(), connectionCache);
                    }
                }
                contactInfo.setConnectionCache(connectionCache);
            }
            return contactInfo.getConnectionCache();
        }
    }

    @Override
    public Collection getOutboundConnectionCaches() {
        return this.outboundConnectionCaches.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundConnectionCache getInboundConnectionCache(Acceptor acceptor) {
        Acceptor acceptor2 = acceptor;
        synchronized (acceptor2) {
            if (acceptor.getConnectionCache() == null) {
                InboundConnectionCache connectionCache = null;
                Map map = this.inboundConnectionCaches;
                synchronized (map) {
                    connectionCache = (InboundConnectionCache)this.inboundConnectionCaches.get(acceptor.getConnectionCacheType());
                    if (connectionCache == null) {
                        connectionCache = new CorbaInboundConnectionCacheImpl(this.orb, acceptor.getConnectionCacheType(), ((CorbaAcceptor)acceptor).getMonitoringName());
                        this.inboundConnectionCaches.put(acceptor.getConnectionCacheType(), connectionCache);
                    }
                }
                connectionCache.registerAcceptor(acceptor);
                acceptor.setConnectionCache(connectionCache);
            }
            return acceptor.getConnectionCache();
        }
    }

    @Override
    public Collection getInboundConnectionCaches() {
        return this.inboundConnectionCaches.values();
    }

    @Override
    public Selector getSelector(int id) {
        return this.selector;
    }

    @Override
    public synchronized void registerAcceptor(Acceptor acceptor) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor->: " + acceptor);
        }
        this.acceptors.add(acceptor);
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerAcceptor<-: " + acceptor);
        }
    }

    @Override
    public Collection getAcceptors() {
        return this.getAcceptors(null, null);
    }

    @Override
    public synchronized void unregisterAcceptor(Acceptor acceptor) {
        this.acceptors.remove(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->");
            }
            for (Object cc : this.outboundConnectionCaches.values()) {
                ((ConnectionCache)cc).close();
            }
            for (Object icc : this.inboundConnectionCaches.values()) {
                ((ConnectionCache)icc).close();
                for (Acceptor acceptor : ((InboundConnectionCache)icc).getAcceptors()) {
                    this.unregisterAcceptor(acceptor);
                }
            }
            this.getSelector(0).close();
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-");
            }
        }
    }

    @Override
    public Collection getAcceptors(String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (Acceptor acceptor : this.acceptors) {
            if (!acceptor.initialize() || !acceptor.shouldRegisterAcceptEvent()) continue;
            this.orb.getTransportManager().getSelector(0).registerForEvent(acceptor.getEventHandler());
        }
        return this.acceptors;
    }

    @Override
    public void addToIORTemplate(IORTemplate iorTemplate, Policies policies, String codebase, String objectAdapterManagerId, ObjectAdapterId objectAdapterId) {
        for (CorbaAcceptor acceptor : this.getAcceptors(objectAdapterManagerId, objectAdapterId)) {
            acceptor.addToIORTemplate(iorTemplate, policies, codebase);
        }
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaTransportManagerImpl", msg);
    }
}

