/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public abstract class TransportResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final Map<ClusteringRequirement, Capability> CLUSTERING_CAPABILITIES = new EnumMap<ClusteringRequirement, Capability>(ClusteringRequirement.class);
    private final UnaryOperator<ResourceDescriptor> configurator;
    private final ResourceServiceHandler handler;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"transport", (String)value);
    }

    TransportResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceHandler handler) {
        super(path, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path}));
        this.configurator = configurator;
        this.handler = handler;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addCapabilities(CLUSTERING_CAPABILITIES.values());
        new SimpleResourceRegistration(descriptor, this.handler).register(registration);
        return registration;
    }

    static {
        for (ClusteringRequirement requirement : EnumSet.allOf(ClusteringRequirement.class)) {
            CLUSTERING_CAPABILITIES.put(requirement, (Capability)new UnaryRequirementCapability((UnaryRequirement)requirement, UnaryCapabilityNameResolver.PARENT));
        }
    }
}

