/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.invocation;

import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.Executor;
import org.aesh.command.impl.shell.ShellOutputDelegate;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Console;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;

public final class AeshCommandInvocation<C extends Command<AeshCommandInvocation>>
implements CommandInvocation {
    private final Console console;
    private final Shell shell;
    private final CommandRuntime<C, AeshCommandInvocation> runtime;
    private final CommandInvocationConfiguration config;

    public AeshCommandInvocation(Console console, Shell shell, CommandRuntime<C, AeshCommandInvocation> runtime, CommandInvocationConfiguration config) {
        this.console = console;
        this.runtime = runtime;
        this.config = config;
        this.shell = this.getConfiguration() != null && this.getConfiguration().getOutputRedirection() != null ? new ShellOutputDelegate(shell, this.getConfiguration().getOutputRedirection()) : shell;
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public void setPrompt(Prompt prompt) {
        this.console.setPrompt(prompt);
    }

    @Override
    public Prompt getPrompt() {
        return this.console.prompt();
    }

    @Override
    public String getHelpInfo(String commandName) {
        return this.console.helpInfo(commandName);
    }

    @Override
    public void stop() {
        this.console.stop();
    }

    @Override
    @Deprecated
    public AeshContext getAeshContext() {
        return this.config.getAeshContext();
    }

    @Override
    public KeyAction input() throws InterruptedException {
        return this.shell.read();
    }

    @Override
    public String inputLine() throws InterruptedException {
        return this.shell.readLine();
    }

    @Override
    public String inputLine(Prompt prompt) throws InterruptedException {
        return this.shell.readLine(prompt);
    }

    @Override
    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.runtime.executeCommand(input);
    }

    @Override
    public Executor<? extends CommandInvocation> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.runtime.buildExecutor(line);
    }

    @Override
    public void print(String msg, boolean page) {
        this.shell.write(msg, page);
    }

    @Override
    public void println(String msg, boolean page) {
        this.shell.writeln(msg, page);
    }

    @Override
    public CommandInvocationConfiguration getConfiguration() {
        return this.config;
    }
}

