/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.wildfly.security._private.ElytronMessages;

public final class URIUtil {
    private URIUtil() {
    }

    public static String getHostForURI(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            String hostString = inetSocketAddress.getHostString();
            InetAddress address = inetSocketAddress.getAddress();
            if (address instanceof Inet6Address && hostString != null && address != null && hostString.equals(address.getHostAddress())) {
                return "[" + address.getHostAddress() + "]";
            }
            return hostString;
        }
        throw ElytronMessages.log.invalidSocketAddressTypeForUri();
    }

    public static int getPortForURI(SocketAddress socketAddress, int defaultPort) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            int port = inetSocketAddress.getPort();
            if (port == defaultPort) {
                return -1;
            }
            return port;
        }
        throw ElytronMessages.log.invalidSocketAddressTypeForUri();
    }

    public static URI createURI(String scheme, SocketAddress socketAddress, int defaultPort) throws URISyntaxException {
        return new URI(scheme, null, URIUtil.getHostForURI(socketAddress), URIUtil.getPortForURI(socketAddress, defaultPort), null, null, null);
    }

    public static URI createURI(String scheme, SocketAddress socketAddress) throws URISyntaxException {
        return URIUtil.createURI(scheme, socketAddress, -1);
    }

    public static String getUserFromURI(URI uri) {
        int colon;
        String userInfo = uri.getUserInfo();
        if (userInfo == null && "domain".equals(uri.getScheme())) {
            String ssp = uri.getSchemeSpecificPart();
            int at = ssp.lastIndexOf(64);
            if (at == -1) {
                return null;
            }
            userInfo = ssp.substring(0, at);
        }
        if (userInfo != null && (colon = userInfo.indexOf(58)) != -1) {
            userInfo = userInfo.substring(0, colon);
        }
        return userInfo;
    }

    public static InetAddress getDestinationInetAddress(URI uri) throws UnknownHostException {
        String host = uri.getHost();
        if (host == null) {
            return null;
        }
        int length = host.length();
        if (length == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }

    public static InetSocketAddress getDestinationInetSocketAddress(URI uri, int defaultPort) {
        String host = uri.getHost();
        if (host == null) {
            return null;
        }
        int length = host.length();
        if (length == 0) {
            return null;
        }
        int port = uri.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        if (port == -1) {
            return null;
        }
        return new InetSocketAddress(host, port);
    }
}

