/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.writer;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SignatureWriter {
    private final Collection<? extends ClassOutline> classes;
    private final Map<JDefinedClass, ClassOutline> classSet = new HashMap<JDefinedClass, ClassOutline>();
    private final Writer out;
    private int indent = 0;

    public static void write(Outline model, Writer out) throws IOException {
        new SignatureWriter(model, out).dump();
    }

    private SignatureWriter(Outline model, Writer out) {
        this.out = out;
        this.classes = model.getClasses();
        for (ClassOutline classOutline : this.classes) {
            this.classSet.put(classOutline.ref, classOutline);
        }
    }

    private void printIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write("  ");
        }
    }

    private void println(String s) throws IOException {
        this.printIndent();
        this.out.write(s);
        this.out.write(10);
    }

    private void dump() throws IOException {
        TreeSet<JPackage> packages = new TreeSet<JPackage>(new Comparator<JPackage>(){

            @Override
            public int compare(JPackage lhs, JPackage rhs) {
                return lhs.name().compareTo(rhs.name());
            }
        });
        for (ClassOutline classOutline : this.classes) {
            packages.add(classOutline._package()._package());
        }
        for (JPackage jPackage : packages) {
            this.dump(jPackage);
        }
        this.out.flush();
    }

    private void dump(JPackage pkg) throws IOException {
        this.println("package " + pkg.name() + " {");
        ++this.indent;
        this.dumpChildren((JClassContainer)pkg);
        --this.indent;
        this.println("}");
    }

    private void dumpChildren(JClassContainer cont) throws IOException {
        Iterator itr = cont.classes();
        while (itr.hasNext()) {
            JDefinedClass cls = (JDefinedClass)itr.next();
            ClassOutline ci = this.classSet.get(cls);
            if (ci == null) continue;
            this.dump(ci);
        }
    }

    private void dump(ClassOutline ci) throws IOException {
        JDefinedClass cls = ci.implClass;
        StringBuilder buf = new StringBuilder();
        buf.append("interface ");
        buf.append(cls.name());
        boolean first = true;
        Iterator itr = cls._implements();
        while (itr.hasNext()) {
            if (first) {
                buf.append(" extends ");
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(this.printName((JType)((JClass)itr.next())));
        }
        buf.append(" {");
        this.println(buf.toString());
        ++this.indent;
        for (FieldOutline fo : ci.getDeclaredFields()) {
            String type = this.printName(fo.getRawType());
            this.println(type + ' ' + fo.getPropertyInfo().getName(true) + ';');
        }
        this.dumpChildren((JClassContainer)cls);
        --this.indent;
        this.println("}");
    }

    private String printName(JType t) {
        String name = t.fullName();
        if (name.startsWith("java.lang.")) {
            name = name.substring(10);
        }
        return name;
    }
}

