/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ejb3.clustering.SingletonBarrierService;
import org.jboss.as.ejb3.component.messagedriven.MdbDeliveryControllerService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.MdbDeliveryGroupResourceDefinition;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class MdbDeliveryDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        boolean clusteredSingletonFound = false;
        for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
            MessageDrivenComponentDescription mdbDescription;
            ComponentDescription description = configuration.getComponentDescription();
            if (!(description instanceof MessageDrivenComponentDescription) || !(mdbDescription = (MessageDrivenComponentDescription)description).isDeliveryControlled()) continue;
            MdbDeliveryControllerService mdbDeliveryControllerService = new MdbDeliveryControllerService();
            ServiceBuilder builder = serviceTarget.addService(mdbDescription.getDeliveryControllerName(), (Service)mdbDeliveryControllerService).addDependency(description.getCreateServiceName(), MessageDrivenComponent.class, mdbDeliveryControllerService.getMdbComponent()).setInitialMode(ServiceController.Mode.PASSIVE);
            if (mdbDescription.isClusteredSingleton()) {
                clusteredSingletonFound = true;
                builder.requires(EJB3SubsystemRootResourceDefinition.CLUSTERED_SINGLETON_CAPABILITY.getCapabilityServiceName());
            }
            if (mdbDescription.getDeliveryGroup() != null) {
                ServiceName deliveryGroupServiceName = MdbDeliveryGroupResourceDefinition.getDeliveryGroupServiceName(mdbDescription.getDeliveryGroup());
                if (phaseContext.getServiceRegistry().getService(deliveryGroupServiceName) == null) {
                    throw EjbLogger.DEPLOYMENT_LOGGER.missingMdbDeliveryGroup(mdbDescription.getDeliveryGroup());
                }
                builder.requires(deliveryGroupServiceName);
            }
            builder.install();
        }
        if (clusteredSingletonFound) {
            serviceTarget.addDependency(SingletonBarrierService.SERVICE_NAME);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        ServiceRegistry serviceRegistry = deploymentUnit.getServiceRegistry();
        boolean clusteredSingletonFound = false;
        for (ComponentConfiguration configuration : moduleConfiguration.getComponentConfigurations()) {
            ComponentDescription description = configuration.getComponentDescription();
            if (!(description instanceof MessageDrivenComponentDescription)) continue;
            MessageDrivenComponentDescription mdbDescription = (MessageDrivenComponentDescription)description;
            boolean bl = clusteredSingletonFound = clusteredSingletonFound || mdbDescription.isClusteredSingleton();
            if (!mdbDescription.isClusteredSingleton() && mdbDescription.getDeliveryGroup() == null) continue;
            serviceRegistry.getRequiredService(mdbDescription.getDeliveryControllerName()).setMode(ServiceController.Mode.REMOVE);
        }
    }
}

