/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AllowedChannelOptionTypesValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    public static AllowedChannelOptionTypesValidator INSTANCE = new AllowedChannelOptionTypesValidator();
    private final List<ModelNode> allowedChannelOptTypes = new ArrayList<ModelNode>();

    private AllowedChannelOptionTypesValidator() {
        super(ModelType.STRING, false);
        this.allowedChannelOptTypes.add(new ModelNode().set("remoting"));
        this.allowedChannelOptTypes.add(new ModelNode().set("xnio"));
    }

    public List<ModelNode> getAllowedValues() {
        return this.allowedChannelOptTypes;
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION && !this.allowedChannelOptTypes.contains(value)) {
            throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(value.asString());
        }
    }
}

