/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.asn;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.asn.AbstractPrivateKeyDecoder;
import org.cryptacular.pbe.OpenSSLAlgorithm;
import org.cryptacular.pbe.OpenSSLEncryptionScheme;
import org.cryptacular.util.ByteUtil;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.PemUtil;

public class OpenSSLPrivateKeyDecoder
extends AbstractPrivateKeyDecoder<AsymmetricKeyParameter> {
    @Override
    protected byte[] decryptKey(byte[] encrypted, char[] password) {
        String pem = new String(encrypted, ByteUtil.ASCII_CHARSET);
        int start = pem.indexOf("DEK-Info:");
        int eol = pem.indexOf(10, start);
        String[] dekInfo = pem.substring(start + 10, eol).split(",");
        String alg = dekInfo[0];
        byte[] iv = CodecUtil.hex(dekInfo[1]);
        byte[] bytes = PemUtil.decode(encrypted);
        return new OpenSSLEncryptionScheme(OpenSSLAlgorithm.fromAlgorithmId(alg), iv, password).decrypt(bytes);
    }

    @Override
    protected AsymmetricKeyParameter decodeASN1(byte[] encoded) {
        DSAPrivateKeyParameters key;
        ASN1Primitive o;
        try {
            o = new ASN1InputStream(encoded).readObject();
        }
        catch (Exception e) {
            throw new EncodingException("Invalid encoded key", e);
        }
        if (o instanceof ASN1ObjectIdentifier) {
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)o);
            byte len = encoded[1];
            byte[] privatePart = new byte[encoded.length - len - 2];
            System.arraycopy(encoded, len + 2, privatePart, 0, privatePart.length);
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)privatePart);
            X9ECParameters params = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)oid);
            key = new ECPrivateKeyParameters(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue(), new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed()));
        } else {
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)o);
            if (sequence.size() == 9) {
                key = new RSAPrivateCrtKeyParameters(ASN1Integer.getInstance((Object)sequence.getObjectAt(1)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(2)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(3)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(4)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(5)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(6)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(7)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(8)).getValue());
            } else if (sequence.size() == 6) {
                key = new DSAPrivateKeyParameters(ASN1Integer.getInstance((Object)sequence.getObjectAt(5)).getValue(), new DSAParameters(ASN1Integer.getInstance((Object)sequence.getObjectAt(1)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(2)).getValue(), ASN1Integer.getInstance((Object)sequence.getObjectAt(3)).getValue()));
            } else if (sequence.size() == 4) {
                X9ECParameters params = X9ECParameters.getInstance((Object)ASN1TaggedObject.getInstance((Object)sequence.getObjectAt(2)).getObject());
                key = new ECPrivateKeyParameters(new BigInteger(ASN1OctetString.getInstance((Object)sequence.getObjectAt(1)).getOctets()), new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed()));
            } else {
                throw new EncodingException("Invalid OpenSSL traditional private key format.");
            }
        }
        return key;
    }
}

