/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.cryptacular.EncodingException;
import org.cryptacular.codec.Encoder;

public class HexEncoder
implements Encoder {
    private static final char[] ENCODING_TABLE = new char[16];
    private final boolean delimit;

    public HexEncoder() {
        this(false);
    }

    public HexEncoder(boolean delimitBytes) {
        this.delimit = delimitBytes;
    }

    @Override
    public void encode(ByteBuffer input, CharBuffer output) throws EncodingException {
        while (input.hasRemaining()) {
            byte current = input.get();
            output.put(ENCODING_TABLE[(current & 0xF0) >> 4]);
            output.put(ENCODING_TABLE[current & 0xF]);
            if (!this.delimit || !input.hasRemaining()) continue;
            output.put(':');
        }
    }

    @Override
    public void finalize(CharBuffer output) throws EncodingException {
    }

    @Override
    public int outputSize(int inputSize) {
        int size = inputSize * 2;
        if (this.delimit) {
            size += inputSize - 1;
        }
        return size;
    }

    static {
        String charset = "0123456789abcdef";
        for (int i = 0; i < "0123456789abcdef".length(); ++i) {
            HexEncoder.ENCODING_TABLE[i] = "0123456789abcdef".charAt(i);
        }
    }
}

