/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.OperationTransformerRegistry;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;

public class GlobalTransformerRegistry {
    private volatile Map<String, SubRegistry> subRegistries;
    private volatile Map<ModelVersion, OperationTransformerRegistry> versionedRegistries;
    private static final AtomicMapFieldUpdater<GlobalTransformerRegistry, String, SubRegistry> subRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(GlobalTransformerRegistry.class, Map.class, "subRegistries"));
    private static final AtomicMapFieldUpdater<GlobalTransformerRegistry, ModelVersion, OperationTransformerRegistry> registryUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(GlobalTransformerRegistry.class, Map.class, "versionedRegistries"));
    static OperationTransformerRegistry.ResourceTransformerEntry RESOURCE_TRANSFORMER = new OperationTransformerRegistry.ResourceTransformerEntry(ResourceTransformer.DEFAULT, false);
    static OperationTransformerRegistry.ResourceTransformerEntry DISCARD = new OperationTransformerRegistry.ResourceTransformerEntry(ResourceTransformer.DISCARD, true);

    public GlobalTransformerRegistry() {
        registryUpdater.clear(this);
        subRegistriesUpdater.clear(this);
    }

    public void discardOperation(PathAddress address, int major, int minor, String operationName) {
        this.registerTransformer(address.iterator(), ModelVersion.create(major, minor), operationName, OperationTransformerRegistry.DISCARD);
    }

    public void discardOperation(PathAddress address, ModelVersion version, String operationName) {
        this.registerTransformer(address.iterator(), version, operationName, OperationTransformerRegistry.DISCARD);
    }

    public void registerTransformer(PathAddress address, int major, int minor, String operationName, OperationTransformer transformer) {
        this.registerTransformer(address.iterator(), ModelVersion.create(major, minor), operationName, new OperationTransformerRegistry.OperationTransformerEntry(transformer, false));
    }

    public void createDiscardingChildRegistry(PathAddress address, ModelVersion version) {
        this.createChildRegistry(address.iterator(), version, PathAddressTransformer.DEFAULT, DISCARD, OperationTransformerRegistry.DISCARD, false);
    }

    public void createChildRegistry(PathAddress address, ModelVersion version, OperationTransformer transformer) {
        this.createChildRegistry(address.iterator(), version, PathAddressTransformer.DEFAULT, RESOURCE_TRANSFORMER, new OperationTransformerRegistry.OperationTransformerEntry(transformer, false), false);
    }

    public void createChildRegistry(PathAddress address, ModelVersion version, ResourceTransformer resourceTransformer, boolean inherited) {
        this.createChildRegistry(address.iterator(), version, PathAddressTransformer.DEFAULT, new OperationTransformerRegistry.ResourceTransformerEntry(resourceTransformer, inherited), OperationTransformerRegistry.FORWARD, false);
    }

    public void createChildRegistry(PathAddress address, ModelVersion version, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer, boolean placeholder) {
        this.createChildRegistry(address, version, PathAddressTransformer.DEFAULT, resourceTransformer, operationTransformer, placeholder);
    }

    public void createChildRegistry(PathAddress address, ModelVersion version, PathAddressTransformer pathAddressTransformer, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer, boolean placeholder) {
        this.createChildRegistry(address.iterator(), version, pathAddressTransformer, new OperationTransformerRegistry.ResourceTransformerEntry(resourceTransformer, false), new OperationTransformerRegistry.OperationTransformerEntry(operationTransformer, false), placeholder);
    }

    public void createChildRegistry(PathAddress address, ModelVersion version, PathAddressTransformer pathAddressTransformer, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer, boolean inherited, boolean placeholder) {
        this.createChildRegistry(address.iterator(), version, pathAddressTransformer, new OperationTransformerRegistry.ResourceTransformerEntry(resourceTransformer, false), new OperationTransformerRegistry.OperationTransformerEntry(operationTransformer, inherited), placeholder);
    }

    public void registerTransformer(PathAddress address, ModelVersion version, String operationName, OperationTransformer transformer) {
        this.registerTransformer(address.iterator(), version, operationName, new OperationTransformerRegistry.OperationTransformerEntry(transformer, false));
    }

    public OperationTransformerRegistry mergeSubtree(OperationTransformerRegistry parent, PathAddress address, Map<PathAddress, ModelVersion> subTree) {
        OperationTransformerRegistry target = parent.createChildRegistry(address.iterator(), PathAddressTransformer.DEFAULT, RESOURCE_TRANSFORMER, OperationTransformerRegistry.FORWARD, false);
        this.mergeSubtree(target, subTree);
        return target;
    }

    public void mergeSubtree(OperationTransformerRegistry targetRegistry, Map<PathAddress, ModelVersion> subTree) {
        for (Map.Entry<PathAddress, ModelVersion> entry : subTree.entrySet()) {
            this.mergeSubtree(targetRegistry, entry.getKey(), entry.getValue());
        }
    }

    protected void mergeSubtree(OperationTransformerRegistry targetRegistry, PathAddress address, ModelVersion version) {
        GlobalTransformerRegistry child = this.navigate(address.iterator());
        if (child != null) {
            child.process(targetRegistry, address, version, Collections.emptyMap());
        }
    }

    public OperationTransformerRegistry create(ModelVersion version, Map<PathAddress, ModelVersion> versions) {
        OperationTransformerRegistry registry = new OperationTransformerRegistry(PathAddressTransformer.DEFAULT, RESOURCE_TRANSFORMER, null, false);
        this.process(registry, PathAddress.EMPTY_ADDRESS, version, versions);
        return registry;
    }

    private void process(OperationTransformerRegistry registry, PathAddress address, ModelVersion version, Map<PathAddress, ModelVersion> versions) {
        Map<String, SubRegistry> snapshot;
        OperationTransformerRegistry current = this.getRegistryUpdater(version);
        if (current != null) {
            OperationTransformerRegistry.ResourceTransformerEntry resourceTransformer = current.getResourceTransformer();
            OperationTransformerRegistry.OperationTransformerEntry defaultTransformer = current.getDefaultTransformer();
            registry.createChildRegistry(address.iterator(), current.getPathAddressTransformer(), resourceTransformer, defaultTransformer, current.isPlaceholder());
            Map<String, OperationTransformerRegistry.OperationTransformerEntry> transformers = current.getTransformers();
            for (Map.Entry<String, OperationTransformerRegistry.OperationTransformerEntry> transformer : transformers.entrySet()) {
                registry.registerTransformer(address, transformer.getKey(), transformer.getValue().getTransformer());
            }
        }
        if ((snapshot = subRegistriesUpdater.get(this)) != null) {
            for (Map.Entry<String, SubRegistry> registryEntry : snapshot.entrySet()) {
                String key = registryEntry.getKey();
                SubRegistry subRegistry = registryEntry.getValue();
                Map children = SubRegistry.childrenUpdater.get(subRegistry);
                for (Map.Entry childEntry : children.entrySet()) {
                    String value = (String)childEntry.getKey();
                    GlobalTransformerRegistry child = (GlobalTransformerRegistry)childEntry.getValue();
                    PathAddress childAddress = address.append(PathElement.pathElement(key, value));
                    ModelVersion childVersion = versions.containsKey(childAddress) ? versions.get(childAddress) : version;
                    child.process(registry, childAddress, childVersion, versions);
                }
            }
        }
    }

    private OperationTransformerRegistry getRegistryUpdater(ModelVersion version) {
        int micro;
        for (int i = micro = version.getMicro(); i >= 0; --i) {
            ModelVersion currentVersion = ModelVersion.create(version.getMajor(), version.getMinor(), i);
            OperationTransformerRegistry current = registryUpdater.get(this, currentVersion);
            if (current == null) continue;
            if (micro != i && this.getClass().desiredAssertionStatus()) {
                ControllerLogger.MGMT_OP_LOGGER.couldNotFindTransformerRegistryFallingBack(version, currentVersion);
            }
            return current;
        }
        return null;
    }

    private void createChildRegistry(Iterator<PathElement> iterator, ModelVersion version, PathAddressTransformer pathAddressTransformer, OperationTransformerRegistry.ResourceTransformerEntry resourceTransformer, OperationTransformerRegistry.OperationTransformerEntry entry, boolean placeholder) {
        if (!iterator.hasNext()) {
            this.getOrCreate(version, pathAddressTransformer, resourceTransformer, entry, placeholder);
        } else {
            PathElement element = iterator.next();
            this.getOrCreate(element.getKey()).getOrCreate(element.getValue()).createChildRegistry(iterator, version, pathAddressTransformer, resourceTransformer, entry, placeholder);
        }
    }

    private void registerTransformer(Iterator<PathElement> iterator, ModelVersion version, String operationName, OperationTransformerRegistry.OperationTransformerEntry entry) {
        if (!iterator.hasNext()) {
            this.getOrCreate(version, PathAddressTransformer.DEFAULT, null, null, false).registerTransformer(PathAddress.EMPTY_ADDRESS.iterator(), operationName, entry);
        } else {
            PathElement element = iterator.next();
            SubRegistry subRegistry = this.getOrCreate(element.getKey());
            subRegistry.registerTransformer(iterator, element.getValue(), version, operationName, entry);
        }
    }

    protected OperationTransformerRegistry.OperationTransformerEntry resolveTransformer(Iterator<PathElement> iterator, ModelVersion version, String operationName) {
        if (!iterator.hasNext()) {
            OperationTransformerRegistry registry = registryUpdater.get(this, version);
            if (registry == null) {
                return null;
            }
            return registry.resolveOperationTransformer(PathAddress.EMPTY_ADDRESS, operationName, null);
        }
        PathElement element = iterator.next();
        SubRegistry registry = subRegistriesUpdater.get(this, element.getKey());
        if (registry == null) {
            return null;
        }
        return registry.resolveTransformer(iterator, element.getValue(), version, operationName);
    }

    private GlobalTransformerRegistry navigate(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        SubRegistry registry = subRegistriesUpdater.get(this, element.getKey());
        if (registry == null) {
            return null;
        }
        GlobalTransformerRegistry other = (GlobalTransformerRegistry)SubRegistry.childrenUpdater.get(registry, element.getValue());
        if (other != null) {
            return other.navigate(iterator);
        }
        return null;
    }

    private SubRegistry getOrCreate(String key) {
        Map<String, SubRegistry> subRegistries;
        SubRegistry registry;
        do {
            if ((registry = (subRegistries = subRegistriesUpdater.get(this)).get(key)) == null) continue;
            return registry;
        } while (!subRegistriesUpdater.putAtomic(this, key, registry = new SubRegistry(), subRegistries));
        return registry;
    }

    private OperationTransformerRegistry getOrCreate(ModelVersion version, PathAddressTransformer pathAddressTransformer, OperationTransformerRegistry.ResourceTransformerEntry resourceTransformer, OperationTransformerRegistry.OperationTransformerEntry defaultTransformer, boolean placeholder) {
        Map<ModelVersion, OperationTransformerRegistry> snapshot;
        OperationTransformerRegistry registry;
        do {
            if ((registry = (snapshot = registryUpdater.get(this)).get(version)) == null) continue;
            return registry;
        } while (!registryUpdater.putAtomic(this, version, registry = new OperationTransformerRegistry(pathAddressTransformer, resourceTransformer, defaultTransformer, placeholder), snapshot));
        return registry;
    }

    private static class SubRegistry {
        private static final AtomicMapFieldUpdater<SubRegistry, String, GlobalTransformerRegistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(SubRegistry.class, Map.class, "children"));
        private volatile Map<String, GlobalTransformerRegistry> children;

        private SubRegistry() {
            childrenUpdater.clear(this);
        }

        GlobalTransformerRegistry getOrCreate(String value) {
            Map<String, GlobalTransformerRegistry> entries;
            GlobalTransformerRegistry entry;
            do {
                if ((entry = (entries = childrenUpdater.get(this)).get(value)) == null) continue;
                return entry;
            } while (!childrenUpdater.putAtomic(this, value, entry = new GlobalTransformerRegistry(), entries));
            return entry;
        }

        public OperationTransformerRegistry.OperationTransformerEntry resolveTransformer(Iterator<PathElement> iterator, String value, ModelVersion version, String operationName) {
            GlobalTransformerRegistry registry = childrenUpdater.get(this, value);
            if (registry == null) {
                return null;
            }
            return registry.resolveTransformer(iterator, version, operationName);
        }

        public void registerTransformer(Iterator<PathElement> iterator, String value, ModelVersion version, String operationName, OperationTransformerRegistry.OperationTransformerEntry entry) {
            this.getOrCreate(value).registerTransformer(iterator, version, operationName, entry);
        }
    }
}

