/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;

public class ActiveMQMessage
implements javax.jms.Message {
    public static final byte TYPE = 0;
    public static final SimpleString OLD_QUEUE_QUALIFIED_PREFIX = SimpleString.toSimpleString((String)("queue://" + PacketImpl.OLD_QUEUE_PREFIX));
    public static final SimpleString OLD_TEMP_QUEUE_QUALIFED_PREFIX = SimpleString.toSimpleString((String)("temp-queue://" + PacketImpl.OLD_TEMP_QUEUE_PREFIX));
    public static final SimpleString OLD_TOPIC_QUALIFIED_PREFIX = SimpleString.toSimpleString((String)("topic://" + PacketImpl.OLD_TOPIC_PREFIX));
    public static final SimpleString OLD_TEMP_TOPIC_QUALIFED_PREFIX = SimpleString.toSimpleString((String)("temp-topic://" + PacketImpl.OLD_TEMP_TOPIC_PREFIX));
    private static final HashSet<String> reservedIdentifiers = new HashSet();
    protected ClientMessage message;
    private ClientSession session;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    private Destination dest;
    private String msgID;
    private Destination replyTo;
    private String jmsCorrelationID;
    private String jmsType;
    private boolean individualAck;
    private boolean clientAck;
    private boolean enable1xPrefixes;
    private long jmsDeliveryTime;

    public static Map<String, Object> coreMaptoJMSMap(Map<String, Object> coreMessage) {
        HashMap<String, Object> jmsMessage = new HashMap<String, Object>();
        String deliveryMode = (Boolean)coreMessage.get("durable") != false ? "PERSISTENT" : "NON_PERSISTENT";
        byte priority = (Byte)coreMessage.get("priority");
        long timestamp = (Long)coreMessage.get("timestamp");
        long expiration = (Long)coreMessage.get("expiration");
        jmsMessage.put("JMSPriority", Integer.valueOf(priority));
        jmsMessage.put("JMSTimestamp", timestamp);
        jmsMessage.put("JMSExpiration", expiration);
        jmsMessage.put("JMSDeliveryMode", deliveryMode);
        for (Map.Entry<String, Object> entry : coreMessage.entrySet()) {
            if (entry.getKey().equals("type") || entry.getKey().equals("durable") || entry.getKey().equals("expiration") || entry.getKey().equals("timestamp") || entry.getKey().equals("priority")) continue;
            if (entry.getKey().equals("userID")) {
                jmsMessage.put("JMSMessageID", entry.getValue().toString());
                continue;
            }
            Object value = entry.getValue();
            if (value instanceof SimpleString) {
                jmsMessage.put(entry.getKey(), value.toString());
                continue;
            }
            jmsMessage.put(entry.getKey(), value);
        }
        return jmsMessage;
    }

    public static CompositeData coreCompositeTypeToJMSCompositeType(CompositeDataSupport data) throws Exception {
        CompositeDataSupport jmsdata = new CompositeDataSupport(data.getCompositeType(), new HashMap());
        return jmsdata;
    }

    public static ActiveMQMessage createMessage(ClientMessage message, ClientSession session) {
        return ActiveMQMessage.createMessage(message, session, null);
    }

    public static ActiveMQMessage createMessage(ClientMessage message, ClientSession session, ConnectionFactoryOptions options) {
        ActiveMQMessage msg;
        byte type = message.getType();
        switch (type) {
            case 0: {
                msg = new ActiveMQMessage(message, session);
                break;
            }
            case 4: {
                msg = new ActiveMQBytesMessage(message, session);
                break;
            }
            case 5: {
                msg = new ActiveMQMapMessage(message, session);
                break;
            }
            case 2: {
                msg = new ActiveMQObjectMessage(message, session, options);
                break;
            }
            case 6: {
                msg = new ActiveMQStreamMessage(message, session);
                break;
            }
            case 3: {
                msg = new ActiveMQTextMessage(message, session);
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid message type " + type);
            }
        }
        return msg;
    }

    protected ActiveMQMessage(byte type, ClientSession session) {
        this.message = session.createMessage(type, true, 0L, System.currentTimeMillis(), (byte)4);
    }

    protected ActiveMQMessage(ClientSession session) {
        this(0, session);
    }

    public ActiveMQMessage(ClientMessage message, ClientSession session) {
        this.message = message;
        this.readOnly = true;
        this.propertiesReadOnly = true;
        this.session = session;
    }

    public ActiveMQMessage(javax.jms.Message foreign, ClientSession session) throws JMSException {
        this(foreign, 0, session);
    }

    public ActiveMQMessage() {
    }

    protected ActiveMQMessage(javax.jms.Message foreign, byte type, ClientSession session) throws JMSException {
        this(type, session);
        boolean supportBytesId;
        this.setJMSTimestamp(foreign.getJMSTimestamp());
        String value = System.getProperty("amq.jms.support-bytes-id");
        boolean bl = supportBytesId = !"false".equals(value);
        if (supportBytesId) {
            try {
                byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
                this.setJMSCorrelationIDAsBytes(corrIDBytes);
            }
            catch (JMSException e) {
                String corrIDString = foreign.getJMSCorrelationID();
                if (corrIDString != null) {
                    this.setJMSCorrelationID(corrIDString);
                }
            }
        } else {
            String corrIDString = foreign.getJMSCorrelationID();
            if (corrIDString != null) {
                this.setJMSCorrelationID(corrIDString);
            }
        }
        this.setJMSReplyTo(foreign.getJMSReplyTo());
        this.setJMSDestination(foreign.getJMSDestination());
        this.setJMSDeliveryMode(foreign.getJMSDeliveryMode());
        this.setJMSExpiration(foreign.getJMSExpiration());
        this.setJMSPriority(foreign.getJMSPriority());
        this.setJMSType(foreign.getJMSType());
        Enumeration props = foreign.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object prop = foreign.getObjectProperty(name);
            this.setObjectProperty(name, prop);
        }
    }

    public String getJMSMessageID() {
        if (this.msgID == null) {
            UUID uid = (UUID)this.message.getUserID();
            this.msgID = uid == null ? null : "ID:" + uid.toString();
        }
        return this.msgID;
    }

    public void setJMSMessageID(String jmsMessageID) throws JMSException {
        if (jmsMessageID != null && !jmsMessageID.startsWith("ID:")) {
            throw new JMSException("JMSMessageID must start with ID:");
        }
        this.message.setUserID(null);
        this.msgID = jmsMessageID;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.message.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.message.setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return MessageUtil.getJMSCorrelationIDAsBytes((Message)this.message);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            MessageUtil.setJMSCorrelationIDAsBytes((Message)this.message, (byte[])correlationID);
        }
        catch (ActiveMQException e) {
            JMSException ex = new JMSException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        MessageUtil.setJMSCorrelationID((Message)this.message, (String)correlationID);
        this.jmsCorrelationID = correlationID;
    }

    public String getJMSCorrelationID() throws JMSException {
        if (this.jmsCorrelationID == null) {
            this.jmsCorrelationID = MessageUtil.getJMSCorrelationID((Message)this.message);
        }
        return this.jmsCorrelationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        SimpleString address;
        if (this.replyTo == null && (address = MessageUtil.getJMSReplyTo((Message)this.message)) != null) {
            this.replyTo = this.enable1xPrefixes ? ActiveMQDestination.fromPrefixedName(this.get1xPrefixedName(address.toString())) : ActiveMQDestination.fromPrefixedName(address.toString());
        }
        return this.replyTo;
    }

    private String get1xPrefixedName(String address) {
        if (address.startsWith("queue://")) {
            if (!address.startsWith("queue://" + PacketImpl.OLD_QUEUE_PREFIX.toString())) {
                address = "queue://" + PacketImpl.OLD_QUEUE_PREFIX + address.substring("queue://".length());
            }
        } else if (address.startsWith("topic://")) {
            if (!address.startsWith("topic://" + PacketImpl.OLD_TOPIC_PREFIX.toString())) {
                address = "topic://" + PacketImpl.OLD_TOPIC_PREFIX + address.substring("topic://".length());
            }
        } else if (address.startsWith("temp-topic://")) {
            if (!address.startsWith("temp-topic://" + PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
                address = "temp-topic://" + PacketImpl.OLD_TEMP_TOPIC_PREFIX + address.substring("temp-topic://".length());
            }
        } else if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
            address = "queue://" + address;
        } else if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
            address = "topic://" + address;
        } else if (address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString())) {
            address = "temp-queue://" + address;
        } else if (address.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
            address = "temp-topic://" + address;
        }
        return address;
    }

    public void setJMSReplyTo(Destination dest) throws JMSException {
        if (dest == null) {
            MessageUtil.setJMSReplyTo((Message)this.message, (String)null);
            this.replyTo = null;
        } else {
            if (!(dest instanceof ActiveMQDestination)) {
                throw new InvalidDestinationException("Foreign destination " + dest);
            }
            ActiveMQDestination jbd = (ActiveMQDestination)dest;
            String address = jbd.getAddress();
            if (this.enable1xPrefixes && ActiveMQMessage.hasPrefix1X(address)) {
                MessageUtil.setJMSReplyTo((Message)this.message, (String)jbd.getAddress());
            } else {
                String prefix = "";
                if (dest instanceof ActiveMQTemporaryQueue) {
                    prefix = "temp-queue://";
                } else if (dest instanceof ActiveMQQueue) {
                    prefix = "queue://";
                } else if (dest instanceof ActiveMQTemporaryTopic) {
                    prefix = "temp-topic://";
                } else if (dest instanceof ActiveMQTopic) {
                    prefix = "topic://";
                }
                MessageUtil.setJMSReplyTo((Message)this.message, (String)(prefix + jbd.getAddress()));
            }
            this.replyTo = jbd;
        }
    }

    private static boolean hasPrefix1X(String address) {
        if (address != null) {
            if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
                return true;
            }
            if (address.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
                return true;
            }
        }
        return false;
    }

    public Destination getJMSDestination() throws JMSException {
        if (this.dest == null) {
            SimpleString address;
            SimpleString name = address = this.message.getAddressSimpleString();
            if (address != null & this.enable1xPrefixes) {
                this.dest = ActiveMQDestination.fromPrefixedName(this.get1xPrefixedName(address.toString()));
            } else {
                this.dest = address == null ? null : (RoutingType.ANYCAST.equals((Object)this.message.getRoutingType()) ? ActiveMQDestination.createQueue(address) : (RoutingType.MULTICAST.equals((Object)this.message.getRoutingType()) ? ActiveMQDestination.createTopic(address) : (ActiveMQDestination)ActiveMQDestination.fromPrefixedName(address.toString())));
                if (name != null) {
                    ((ActiveMQDestination)this.dest).setName(name.toString());
                }
            }
        }
        return this.dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.message.isDurable() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.message.setDurable(true);
        } else if (deliveryMode == 1) {
            this.message.setDurable(false);
        } else {
            throw ActiveMQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.message.getDeliveryCount() > 1;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (!redelivered) {
            this.message.setDeliveryCount(1);
        } else if (this.message.getDeliveryCount() <= 1) {
            this.message.setDeliveryCount(2);
        }
    }

    public void setJMSType(String type) throws JMSException {
        if (type != null) {
            MessageUtil.setJMSType((Message)this.message, (String)type);
            this.jmsType = type;
        }
    }

    public String getJMSType() throws JMSException {
        if (this.jmsType == null) {
            this.jmsType = MessageUtil.getJMSType((Message)this.message);
        }
        return this.jmsType;
    }

    public long getJMSExpiration() throws JMSException {
        return this.message.getExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.message.setExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.message.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.checkPriority(priority);
        this.message.setPriority((byte)priority);
    }

    public void clearProperties() throws JMSException {
        MessageUtil.clearProperties((Message)this.message);
        this.propertiesReadOnly = false;
    }

    public void clearBody() throws JMSException {
        this.readOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return MessageUtil.propertyExists((Message)this.message, (String)name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        try {
            return this.message.getBooleanProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public byte getByteProperty(String name) throws JMSException {
        try {
            return this.message.getByteProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public short getShortProperty(String name) throws JMSException {
        try {
            return this.message.getShortProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public int getIntProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getIntProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public long getLongProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.message.getDeliveryCount();
        }
        try {
            return this.message.getLongProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public float getFloatProperty(String name) throws JMSException {
        try {
            return this.message.getFloatProperty(name).floatValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public double getDoubleProperty(String name) throws JMSException {
        try {
            return this.message.getDoubleProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public String getStringProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        try {
            if ("JMSXGroupID".equals(name)) {
                return this.message.getStringProperty(Message.HDR_GROUP_ID);
            }
            if ("JMSXUserID".equals(name)) {
                return this.message.getValidatedUserID();
            }
            return this.message.getStringProperty(name);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        Object val = this.message.getObjectProperty(name);
        if (val instanceof SimpleString) {
            val = val.toString();
        }
        return val;
    }

    public Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(MessageUtil.getPropertyNames((Message)this.message));
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkProperty(name);
        this.message.putBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkProperty(name);
        this.message.putByteProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkProperty(name);
        this.message.putShortProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkProperty(name);
        this.message.putIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkProperty(name);
        this.message.putLongProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkProperty(name);
        this.message.putFloatProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkProperty(name);
        this.message.putDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkProperty(name);
        if (this.handleCoreProperty(name, value, "JMSXGroupID", Message.HDR_GROUP_ID)) {
            return;
        }
        if (this.handleCoreProperty(name, value, "JMSXUserID", Message.HDR_VALIDATED_USER)) {
            return;
        }
        this.message.putStringProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.handleCoreProperty(name, value, "JMSXGroupID", Message.HDR_GROUP_ID)) {
            return;
        }
        if (this.handleCoreProperty(name, value, "JMSXUserID", Message.HDR_VALIDATED_USER)) {
            return;
        }
        if ("JMS_AMQ_OutputStream".equals(name)) {
            this.setOutputStream((OutputStream)value);
            return;
        }
        if ("JMS_AMQ_SaveStream".equals(name)) {
            this.saveToOutputStream((OutputStream)value);
            return;
        }
        this.checkProperty(name);
        if ("JMS_AMQ_InputStream".equals(name)) {
            this.setInputStream((InputStream)value);
            return;
        }
        try {
            this.message.putObjectProperty(name, value);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public void acknowledge() throws JMSException {
        if (this.session != null) {
            try {
                if (this.session.isClosed()) {
                    throw ActiveMQClientMessageBundle.BUNDLE.sessionClosed();
                }
                if (this.individualAck) {
                    this.message.individualAcknowledge();
                }
                if (this.clientAck || this.individualAck) {
                    this.session.commit(this.session.isBlockOnAcknowledge());
                }
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.message.getScheduledDeliveryTime();
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.message.setScheduledDeliveryTime(Long.valueOf(deliveryTime));
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return this.getBodyInternal(c);
        }
        if (this.hasNoBody()) {
            return null;
        }
        throw new MessageFormatException("Body not assignable to " + c);
    }

    protected <T> T getBodyInternal(Class<T> c) throws MessageFormatException {
        InputStream is = ((ClientMessageInternal)this.message).getBodyInputStream();
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public boolean isBodyAssignableTo(Class c) {
        return true;
    }

    protected boolean hasNoBody() {
        return this.message.getBodySize() == 0;
    }

    public void setIndividualAcknowledge() {
        this.individualAck = true;
    }

    public void setClientAcknowledge() {
        this.clientAck = true;
    }

    public void resetMessageID(String newMsgID) {
        this.msgID = newMsgID;
    }

    public ClientMessage getCoreMessage() {
        return this.message;
    }

    public void doBeforeSend() throws Exception {
        this.message.getBodyBuffer().resetReaderIndex();
    }

    public void checkBuffer() {
        this.message.getBodyBuffer();
    }

    public void doBeforeReceive() throws ActiveMQException {
        this.message.checkCompletion();
        ActiveMQBuffer body = this.message.getBodyBuffer();
        if (body != null) {
            body.resetReaderIndex();
        }
    }

    public byte getType() {
        return 0;
    }

    public void setInputStream(InputStream input) throws JMSException {
        this.checkStream();
        if (this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        this.message.setBodyInputStream(input);
    }

    public void setOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.setOutputStream(output);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void saveToOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.saveToOutputStream(output);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public boolean waitCompletionOnStream(long timeWait) throws JMSException {
        this.checkStream();
        try {
            return this.message.waitOutputStreamCompletion(timeWait);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void setEnable1xPrefixes(boolean enable1xPrefixes) {
        this.enable1xPrefixes = enable1xPrefixes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ActiveMQMessage[");
        sb.append(this.getJMSMessageID());
        sb.append("]:");
        sb.append(this.message.isDurable() ? "PERSISTENT" : "NON-PERSISTENT");
        sb.append("/" + this.message.toString());
        return sb.toString();
    }

    protected void checkWrite() throws JMSException {
        if (this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
    }

    protected void checkRead() throws JMSException {
        if (!this.readOnly) {
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotReadable();
        }
    }

    private void checkStream() throws JMSException {
        if (this.message.getType() != 4 && this.message.getType() != 6) {
            throw ActiveMQJMSClientBundle.BUNDLE.onlyValidForByteOrStreamMessages();
        }
    }

    private void checkProperty(String name) throws JMSException {
        if (this.propertiesReadOnly) {
            if (name.equals("JMS_AMQ_InputStream")) {
                throw new MessageNotWriteableException("You cannot set the Input Stream on received messages. Did you mean JMS_AMQ_OutputStream or JMS_AMQ_SaveStream?");
            }
            throw ActiveMQJMSClientBundle.BUNDLE.messageNotWritable();
        }
        if (name == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("property");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!this.isValidJavaIdentifier(name)) {
            throw ActiveMQJMSClientBundle.BUNDLE.invalidJavaIdentifier(name);
        }
        if (reservedIdentifiers.contains(name)) {
            throw new JMSRuntimeException("The property name '" + name + "' is reserved due to selector syntax.");
        }
        if (name.startsWith("JMS_ACTIVEMQ")) {
            throw new JMSRuntimeException("The property name '" + name + "' is illegal since it starts with JMS_ACTIVEMQ");
        }
    }

    private boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    private void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException(priority + " is not valid: priority must be between 0 and 9");
        }
    }

    private boolean handleCoreProperty(String name, Object value, String jmsPropertyName, SimpleString corePropertyName) {
        boolean result = false;
        if (jmsPropertyName.equals(name)) {
            this.message.putStringProperty(corePropertyName, value == null ? null : value.toString());
            result = true;
        }
        return result;
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
    }
}

