/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.ra.ActiveMQRABytesMessage;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMapMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMessage;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageListener;
import org.apache.activemq.artemis.ra.ActiveMQRAObjectMessage;
import org.apache.activemq.artemis.ra.ActiveMQRASession;
import org.apache.activemq.artemis.ra.ActiveMQRAStreamMessage;
import org.apache.activemq.artemis.ra.ActiveMQRATextMessage;

public class ActiveMQRAMessageConsumer
implements MessageConsumer {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    protected MessageConsumer consumer;
    protected ActiveMQRASession session;

    public ActiveMQRAMessageConsumer(MessageConsumer consumer, ActiveMQRASession session) {
        this.consumer = consumer;
        this.session = session;
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("new ActiveMQMessageConsumer " + this + " consumer=" + consumer + " session=" + session);
        }
    }

    public void close() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("close " + this);
        }
        try {
            this.closeConsumer();
        }
        finally {
            this.session.removeConsumer(this);
        }
    }

    void checkState() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("checkState()");
        }
        this.session.checkState();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMessageListener()");
        }
        this.checkState();
        this.session.checkStrict();
        return this.consumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.lock();
        try {
            this.checkState();
            this.session.checkStrict();
            if (listener == null) {
                this.consumer.setMessageListener(null);
            } else {
                this.consumer.setMessageListener(this.wrapMessageListener(listener));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    public String getMessageSelector() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMessageSelector()");
        }
        this.checkState();
        return this.consumer.getMessageSelector();
    }

    public Message receive() throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("receive " + this);
            }
            this.checkState();
            Message message = this.consumer.receive();
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("received " + this + " result=" + message);
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("receive " + this + " timeout=" + timeout);
            }
            this.checkState();
            Message message = this.consumer.receive(timeout);
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("received " + this + " result=" + message);
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    public Message receiveNoWait() throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("receiveNoWait " + this);
            }
            this.checkState();
            Message message = this.consumer.receiveNoWait();
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("received " + this + " result=" + message);
            }
            if (message == null) {
                Message message2 = null;
                return message2;
            }
            Message message3 = this.wrapMessage(message);
            return message3;
        }
        finally {
            this.session.unlock();
        }
    }

    void closeConsumer() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("closeConsumer()");
        }
        this.consumer.close();
    }

    Message wrapMessage(Message message) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("wrapMessage(" + message + ")");
        }
        if (message instanceof BytesMessage) {
            return new ActiveMQRABytesMessage((BytesMessage)message, this.session);
        }
        if (message instanceof MapMessage) {
            return new ActiveMQRAMapMessage((MapMessage)message, this.session);
        }
        if (message instanceof ObjectMessage) {
            return new ActiveMQRAObjectMessage((ObjectMessage)message, this.session);
        }
        if (message instanceof StreamMessage) {
            return new ActiveMQRAStreamMessage((StreamMessage)message, this.session);
        }
        if (message instanceof TextMessage) {
            return new ActiveMQRATextMessage((TextMessage)message, this.session);
        }
        return new ActiveMQRAMessage(message, this.session);
    }

    MessageListener wrapMessageListener(MessageListener listener) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMessageSelector()");
        }
        return new ActiveMQRAMessageListener(listener, this);
    }
}

