/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.ra.recovery.RecoveryManager;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;

public class ActiveMQResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final Logger logger = Logger.getLogger(ActiveMQResourceAdapter.class);
    private static final long serialVersionUID = 4756893709825838770L;
    public static final String PRODUCT_NAME = "ActiveMQ Artemis";
    private BootstrapContext ctx;
    private final ActiveMQRAProperties raProperties;
    private String unparsedProperties;
    private String unparsedConnectors;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, ActiveMQActivation> activations;
    private ActiveMQConnectionFactory defaultActiveMQConnectionFactory;
    private ActiveMQConnectionFactory recoveryActiveMQConnectionFactory;
    private TransactionManager tm;
    private String unparsedJndiParams;
    private final RecoveryManager recoveryManager;
    private boolean useAutoRecovery = true;
    private final List<ActiveMQRAManagedConnectionFactory> managedConnectionFactories = new ArrayList<ActiveMQRAManagedConnectionFactory>();
    private String entries;
    private boolean ignoreJTA;
    private final Map<ConnectionFactoryProperties, Pair<ActiveMQConnectionFactory, AtomicInteger>> knownConnectionFactories = new HashMap<ConnectionFactoryProperties, Pair<ActiveMQConnectionFactory, AtomicInteger>>();

    public ActiveMQResourceAdapter() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"constructor()");
        }
        this.raProperties = new ActiveMQRAProperties();
        this.configured = new AtomicBoolean(false);
        this.activations = Collections.synchronizedMap(new IdentityHashMap());
        this.recoveryManager = new RecoveryManager();
    }

    public TransactionManager getTM() {
        return this.tm;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (spec == null) {
            throw ActiveMQRABundle.BUNDLE.noActivationSpec();
        }
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        ActiveMQActivation activation = new ActiveMQActivation(this, endpointFactory, (ActiveMQActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        ActiveMQActivation activation;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if ((activation = this.activations.remove(spec)) != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getXAResources(" + Arrays.toString(specs) + ")"));
        }
        if (this.useAutoRecovery) {
            return null;
        }
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        for (ActivationSpec spec : specs) {
            ActiveMQActivation activation = this.activations.get(spec);
            if (activation == null) continue;
            xaresources.addAll(activation.getXAResources());
        }
        return xaresources.toArray(new XAResource[xaresources.size()]);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("start(" + ctx + ")"));
        }
        this.tm = ServiceUtils.getTransactionManager();
        this.recoveryManager.start(this.useAutoRecovery);
        this.ctx = ctx;
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceAdapterInternalException("Unable to create activation", (Throwable)e);
            }
        }
        ActiveMQRALogger.LOGGER.resourceAdaptorStarted();
    }

    public void stop() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"stop()");
        }
        for (Map.Entry<ActivationSpec, ActiveMQActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                ActiveMQRALogger.LOGGER.debug("Ignored", ignored);
            }
        }
        this.activations.clear();
        for (ActiveMQRAManagedConnectionFactory activeMQRAManagedConnectionFactory : this.managedConnectionFactories) {
            activeMQRAManagedConnectionFactory.stop();
        }
        this.managedConnectionFactories.clear();
        for (Pair pair : this.knownConnectionFactories.values()) {
            ((ActiveMQConnectionFactory)pair.getA()).close();
        }
        this.knownConnectionFactories.clear();
        if (this.defaultActiveMQConnectionFactory != null) {
            this.defaultActiveMQConnectionFactory.close();
        }
        if (this.recoveryActiveMQConnectionFactory != null) {
            this.recoveryActiveMQConnectionFactory.close();
        }
        this.recoveryManager.stop();
        ActiveMQRALogger.LOGGER.raStopped();
    }

    public void setUseAutoRecovery(Boolean useAutoRecovery) {
        this.useAutoRecovery = useAutoRecovery;
    }

    public Boolean isUseAutoRecovery() {
        return this.useAutoRecovery;
    }

    public Boolean isUseMaskedPassword() {
        return this.raProperties.isUseMaskedPassword();
    }

    public void setUseMaskedPassword(Boolean useMaskedPassword) {
        this.raProperties.setUseMaskedPassword(useMaskedPassword);
    }

    public void setPasswordCodec(String passwordCodec) {
        this.raProperties.setPasswordCodec(passwordCodec);
    }

    public String getPasswordCodec() {
        return this.raProperties.getPasswordCodec();
    }

    public void setConnectorClassName(String connectorClassName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setTransportType(" + connectorClassName + ")"));
        }
        this.unparsedConnectors = connectorClassName;
        this.raProperties.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectorClassName() {
        return this.unparsedConnectors;
    }

    public String getConnectionParameters() {
        return this.unparsedProperties;
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.unparsedProperties = config;
            this.raProperties.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(config));
        }
    }

    public Boolean getHA() {
        return this.raProperties.isHA();
    }

    public void setHA(Boolean ha) {
        this.raProperties.setHA(ha);
    }

    public String getEntries() {
        return this.entries;
    }

    public String getJndiName() {
        Matcher m;
        if (this.entries != null && !this.entries.isEmpty() && (m = Pattern.compile("\"(.*?)\"").matcher(this.entries)).find()) {
            return m.group(1);
        }
        return null;
    }

    public void setEntries(String entries) {
        this.entries = entries;
    }

    public String getDiscoveryAddress() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDiscoveryGroupAddress()");
        }
        return this.raProperties.getDiscoveryAddress();
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.raProperties.setJgroupsFile(jgroupsFile);
    }

    public String getJgroupsFile() {
        return this.raProperties.getJgroupsFile();
    }

    public String getJgroupsChannelName() {
        return this.raProperties.getJgroupsChannelName();
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.raProperties.setJgroupsChannelName(jgroupsChannelName);
    }

    public void setDiscoveryAddress(String dgn) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDiscoveryGroupAddress(" + dgn + ")"));
        }
        this.raProperties.setDiscoveryAddress(dgn);
    }

    public Integer getDiscoveryPort() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDiscoveryGroupPort()");
        }
        return this.raProperties.getDiscoveryPort();
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDiscoveryLocalBindAddress(" + discoveryLocalBindAddress + ")"));
        }
        this.raProperties.setDiscoveryLocalBindAddress(discoveryLocalBindAddress);
    }

    public String getDiscoveryLocalBindAddress() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDiscoveryLocalBindAddress()");
        }
        return this.raProperties.getDiscoveryLocalBindAddress();
    }

    public void setDiscoveryPort(Integer dgp) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDiscoveryGroupPort(" + dgp + ")"));
        }
        this.raProperties.setDiscoveryPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDiscoveryRefreshTimeout()");
        }
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")"));
        }
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDiscoveryInitialWaitTimeout()");
        }
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")"));
        }
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public Long getClientFailureCheckPeriod() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getClientFailureCheckPeriod()");
        }
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")"));
        }
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getConnectionTTL()");
        }
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConnectionTTL(" + connectionTTL + ")"));
        }
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Boolean isCacheLargeMessagesClient() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"isCacheLargeMessagesClient()");
        }
        return this.raProperties.isCacheLargeMessagesClient();
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setCacheLargeMessagesClient(" + cacheLargeMessagesClient + ")"));
        }
        this.raProperties.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public Boolean isCompressLargeMessage() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"isCompressLargeMessage()");
        }
        return this.raProperties.isCompressLargeMessage();
    }

    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setFailoverOnInitialConnection(" + failoverOnInitialConnection + ")"));
        }
        this.raProperties.setFailoverOnInitialConnection(failoverOnInitialConnection);
    }

    public Boolean isFailoverOnInitialConnection() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"isFailoverOnInitialConnection()");
        }
        return this.raProperties.isFailoverOnInitialConnection();
    }

    public void setCacheDestinations(Boolean cacheDestinations) {
        if (logger.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setCacheDestinations(" + cacheDestinations + ")");
        }
        this.raProperties.setCacheDestinations(cacheDestinations);
    }

    public Boolean isCacheDestinations() {
        if (logger.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("isCacheDestinations()");
        }
        return this.raProperties.isCacheDestinations();
    }

    public void setEnable1xPrefixes(Boolean enable1xPrefixes) {
        if (logger.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setEnable1xPrefixes(" + enable1xPrefixes + ")");
        }
        this.raProperties.setEnable1xPrefixes(enable1xPrefixes);
    }

    public Boolean isEnable1xPrefixes() {
        if (logger.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("isEnable1xPrefixes()");
        }
        return this.raProperties.isEnable1xPrefixes();
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setCompressLargeMessage(" + compressLargeMessage + ")"));
        }
        this.raProperties.setCompressLargeMessage(compressLargeMessage);
    }

    public Long getCallTimeout() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getCallTimeout()");
        }
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setCallTimeout(" + callTimeout + ")"));
        }
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Long getCallFailoverTimeout() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getCallFailoverTimeout()");
        }
        return this.raProperties.getCallFailoverTimeout();
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setCallFailoverTimeout(" + callFailoverTimeout + ")"));
        }
        this.raProperties.setCallFailoverTimeout(callFailoverTimeout);
    }

    public Integer getDupsOKBatchSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDupsOKBatchSize()");
        }
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDupsOKBatchSize(" + dupsOKBatchSize + ")"));
        }
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getTransactionBatchSize()");
        }
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setTransactionBatchSize(" + transactionBatchSize + ")"));
        }
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getConsumerWindowSize()");
        }
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConsumerWindowSize(" + consumerWindowSize + ")"));
        }
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getConsumerMaxRate()");
        }
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConsumerMaxRate(" + consumerMaxRate + ")"));
        }
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getConfirmationWindowSize()");
        }
        return this.raProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setConfirmationWindowSize(" + confirmationWindowSize + ")"));
        }
        this.raProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getProducerMaxRate()");
        }
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setProducerMaxRate(" + producerMaxRate + ")"));
        }
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getProducerWindowSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getProducerWindowSize()");
        }
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setProducerWindowSize(" + producerWindowSize + ")"));
        }
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public String getProtocolManagerFactoryStr() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getProtocolManagerFactoryStr()");
        }
        return this.raProperties.getProtocolManagerFactoryStr();
    }

    public void setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setProtocolManagerFactoryStr(" + protocolManagerFactoryStr + ")"));
        }
        this.raProperties.setProtocolManagerFactoryStr(protocolManagerFactoryStr);
    }

    public String getDeserializationBlackList() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDeserializationBlackList()");
        }
        return this.raProperties.getDeserializationBlackList();
    }

    public void setDeserializationBlackList(String deserializationBlackList) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDeserializationBlackList(" + deserializationBlackList + ")"));
        }
        this.raProperties.setDeserializationBlackList(deserializationBlackList);
    }

    public String getDeserializationWhiteList() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getDeserializationWhiteList()");
        }
        return this.raProperties.getDeserializationWhiteList();
    }

    public void setDeserializationWhiteList(String deserializationWhiteList) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setDeserializationWhiteList(" + deserializationWhiteList + ")"));
        }
        this.raProperties.setDeserializationWhiteList(deserializationWhiteList);
    }

    public Integer getMinLargeMessageSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getMinLargeMessageSize()");
        }
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setMinLargeMessageSize(" + minLargeMessageSize + ")"));
        }
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getBlockOnAcknowledge()");
        }
        return this.raProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setBlockOnAcknowledge(" + blockOnAcknowledge + ")"));
        }
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonDurableSend() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getBlockOnNonDurableSend()");
        }
        return this.raProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setBlockOnNonDurableSend(" + blockOnNonDurableSend + ")"));
        }
        this.raProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean getBlockOnDurableSend() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getBlockOnDurableSend()");
        }
        return this.raProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setBlockOnDurableSend(" + blockOnDurableSend + ")"));
        }
        this.raProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean getAutoGroup() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getAutoGroup()");
        }
        return this.raProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setAutoGroup(" + autoGroup + ")"));
        }
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Boolean getPreAcknowledge() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getPreAcknowledge()");
        }
        return this.raProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setPreAcknowledge(" + preAcknowledge + ")"));
        }
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Integer getInitialConnectAttempts() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getInitialConnectAttempts()");
        }
        return this.raProperties.getInitialConnectAttempts();
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setInitialConnectionAttempts(" + initialConnectAttempts + ")"));
        }
        this.raProperties.setInitialConnectAttempts(initialConnectAttempts);
    }

    public Integer getInitialMessagePacketSize() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getInitialMessagePacketSize()");
        }
        return this.raProperties.getInitialMessagePacketSize();
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setInitialMessagePacketSize(" + initialMessagePacketSize + ")"));
        }
        this.raProperties.setInitialMessagePacketSize(initialMessagePacketSize);
    }

    public Long getRetryInterval() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getRetryInterval()");
        }
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setRetryInterval(" + retryInterval + ")"));
        }
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getRetryIntervalMultiplier()");
        }
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")"));
        }
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Long getMaxRetryInterval() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getMaxRetryInterval()");
        }
        return this.raProperties.getMaxRetryInterval();
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setMaxRetryInterval(" + maxRetryInterval + ")"));
        }
        this.raProperties.setMaxRetryInterval(maxRetryInterval);
    }

    public Integer getReconnectAttempts() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getReconnectAttempts()");
        }
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setReconnectAttempts(" + reconnectAttempts + ")"));
        }
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setFailoverOnServerShutdown(" + connectionLoadBalancingPolicyClassName + ")"));
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.raProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setFailoverOnServerShutdown(" + scheduledThreadPoolMaxSize + ")"));
        }
        this.raProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.raProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setFailoverOnServerShutdown(" + threadPoolMaxSize + ")"));
        }
        this.raProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getUseGlobalPools() {
        return this.raProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setFailoverOnServerShutdown(" + useGlobalPools + ")"));
        }
        this.raProperties.setUseGlobalPools(useGlobalPools);
    }

    public String getUserName() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getUserName()");
        }
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setUserName(" + userName + ")"));
        }
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getPassword()");
        }
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public boolean isUseJNDI() {
        return this.raProperties.isUseJNDI();
    }

    public void setUseJNDI(Boolean value) {
        this.raProperties.setUseJNDI(value);
    }

    public String getJndiParams() {
        return this.unparsedJndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.unparsedJndiParams = jndiParams;
        this.raProperties.setParsedJndiParams(ActiveMQRaUtils.parseHashtableConfig(jndiParams));
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.raProperties.getParsedJndiParams();
    }

    public String getClientID() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getClientID()");
        }
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setClientID(" + clientID + ")"));
        }
        this.raProperties.setClientID(clientID);
    }

    public String getGroupID() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getGroupID()");
        }
        return this.raProperties.getGroupID();
    }

    public void setGroupID(String groupID) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setGroupID(" + groupID + ")"));
        }
        this.raProperties.setGroupID(groupID);
    }

    public Boolean getUseLocalTx() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getUseLocalTx()");
        }
        return this.raProperties.getUseLocalTx();
    }

    public void setUseLocalTx(Boolean localTx) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setUseXA(" + localTx + ")"));
        }
        this.raProperties.setUseLocalTx(localTx);
    }

    public int getSetupAttempts() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSetupAttempts()");
        }
        return this.raProperties.getSetupAttempts();
    }

    public void setSetupAttempts(Integer setupAttempts) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSetupAttempts(" + setupAttempts + ")"));
        }
        this.raProperties.setSetupAttempts(setupAttempts);
    }

    public long getSetupInterval() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getSetupInterval()");
        }
        return this.raProperties.getSetupInterval();
    }

    public void setSetupInterval(Long interval) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setSetupInterval(" + interval + ")"));
        }
        this.raProperties.setSetupInterval(interval);
    }

    public boolean equals(Object obj) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ActiveMQResourceAdapter) {
            return this.raProperties.equals(((ActiveMQResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"hashCode()");
        }
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getWorkManager()");
        }
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted, boolean useLocalTx, Integer txTimeout) throws Exception {
        ClientSession result;
        if (deliveryTransacted || useLocalTx) {
            result = useLocalTx ? parameterFactory.createSession(user, pass, false, false, false, false, 0) : parameterFactory.createSession(user, pass, true, false, false, false, 0);
        } else if (preAck != null && preAck.booleanValue()) {
            result = parameterFactory.createSession(user, pass, false, true, true, true, -1);
        } else {
            switch (ackMode) {
                case 1: {
                    result = parameterFactory.createSession(user, pass, false, true, true, false, 0);
                    break;
                }
                case 3: {
                    int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
                    result = parameterFactory.createSession(user, pass, false, true, true, false, actDupsOkBatchSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
                }
            }
        }
        ActiveMQRALogger.LOGGER.debug("Using queue connection " + result);
        return result;
    }

    public RecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    public ActiveMQRAProperties getProperties() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"getProperties()");
        }
        return this.raProperties;
    }

    protected void setup() throws ActiveMQException {
        this.raProperties.init();
        this.defaultActiveMQConnectionFactory = this.newConnectionFactory(this.raProperties);
        this.recoveryActiveMQConnectionFactory = this.createRecoveryActiveMQConnectionFactory(this.raProperties);
        HashMap<String, String> recoveryConfProps = new HashMap<String, String>();
        recoveryConfProps.put("JNDI_NAME", this.getJndiName());
        this.recoveryManager.register(this.recoveryActiveMQConnectionFactory, this.raProperties.getUserName(), this.raProperties.getPassword(), recoveryConfProps);
    }

    public Map<ActivationSpec, ActiveMQActivation> getActivations() {
        return this.activations;
    }

    public ActiveMQConnectionFactory getDefaultActiveMQConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (ActiveMQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.defaultActiveMQConnectionFactory;
    }

    public String getJgroupsChannelLocatorClass() {
        return this.raProperties.getJgroupsChannelLocatorClass();
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.raProperties.setJgroupsChannelLocatorClass(jgroupsChannelLocatorClass);
    }

    public String getJgroupsChannelRefName() {
        return this.raProperties.getJgroupsChannelRefName();
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.raProperties.setJgroupsChannelRefName(jgroupsChannelRefName);
    }

    public synchronized ActiveMQConnectionFactory getConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        boolean known = false;
        if (!this.knownConnectionFactories.keySet().contains(overrideProperties)) {
            cf = this.newConnectionFactory(overrideProperties);
            this.knownConnectionFactories.put(overrideProperties, (Pair<ActiveMQConnectionFactory, AtomicInteger>)new Pair((Object)cf, (Object)new AtomicInteger(1)));
        } else {
            Pair<ActiveMQConnectionFactory, AtomicInteger> pair = this.knownConnectionFactories.get(overrideProperties);
            cf = (ActiveMQConnectionFactory)pair.getA();
            ((AtomicInteger)pair.getB()).incrementAndGet();
            known = true;
        }
        if (known && cf.getServerLocator().isClosed()) {
            this.knownConnectionFactories.remove(overrideProperties);
            cf = this.newConnectionFactory(overrideProperties);
            this.knownConnectionFactories.put(overrideProperties, (Pair<ActiveMQConnectionFactory, AtomicInteger>)new Pair((Object)cf, (Object)new AtomicInteger(1)));
        }
        return cf;
    }

    public ActiveMQConnectionFactory newConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        BroadcastEndpointFactory endpointFactory;
        Boolean ha;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        Boolean bl = ha = overrideProperties.isHA() != null ? overrideProperties.isHA() : this.getHA();
        if (ha == null) {
            ha = false;
        }
        if ((endpointFactory = this.createBroadcastEndpointFactory(overrideProperties)) != null) {
            Long initialTimeout;
            Long refreshTimeout;
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory(endpointFactory);
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for discovery=" + groupConfiguration + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else if (connectorClassName != null) {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    ActiveMQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations) + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        } else {
            throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
        }
        cf.setEnableSharedClientID(true);
        cf.setEnable1xPrefixes(this.raProperties.isEnable1xPrefixes() == null ? false : this.raProperties.isEnable1xPrefixes());
        this.setParams(cf, overrideProperties);
        return cf;
    }

    public ActiveMQConnectionFactory createRecoveryActiveMQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        ActiveMQConnectionFactory cf;
        List<String> connectorClassName;
        List<String> list = connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        if (connectorClassName == null) {
            Long initialTimeout;
            Long refreshTimeout;
            BroadcastEndpointFactory endpointFactory = this.createBroadcastEndpointFactory(overrideProperties);
            if (endpointFactory == null) {
                throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for ResourceAdapter Connection Factory");
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setRefreshTimeout(refreshTimeout.longValue()).setDiscoveryInitialWaitTimeout(initialTimeout.longValue()).setBroadcastEndpointFactory(endpointFactory);
            groupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for discovery=" + groupConfiguration);
            }
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    ActiveMQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (ActiveMQRALogger.LOGGER.isDebugEnabled()) {
                ActiveMQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations));
            }
            cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        }
        this.setParams(cf, overrideProperties);
        cf.setReconnectAttempts(0);
        cf.setInitialConnectAttempts(0);
        cf.setEnable1xPrefixes(this.raProperties.isEnable1xPrefixes() == null ? false : this.raProperties.isEnable1xPrefixes());
        cf.setEnableSharedClientID(true);
        return cf;
    }

    protected BroadcastEndpointFactory createBroadcastEndpointFactory(ConnectionFactoryProperties overrideProperties) {
        String jgroupsFileName;
        String discoveryAddress;
        String string = discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        if (discoveryAddress != null) {
            Integer discoveryPort;
            Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
            if (discoveryPort == null) {
                discoveryPort = 9876;
            }
            String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
            return new UDPBroadcastEndpointFactory().setGroupAddress(discoveryAddress).setGroupPort(discoveryPort.intValue()).setLocalBindAddress(localBindAddress).setLocalBindPort(-1);
        }
        String jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        String jgroupsLocatorClassName = this.raProperties.getJgroupsChannelLocatorClass();
        if (jgroupsLocatorClassName != null) {
            String jchannelRefName = this.raProperties.getJgroupsChannelRefName();
            JChannel jchannel = ActiveMQRaUtils.locateJGroupsChannel(jgroupsLocatorClassName, jchannelRefName);
            return new ChannelBroadcastEndpointFactory(jchannel, jgroupsChannel);
        }
        String string2 = jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        if (jgroupsFileName != null) {
            return new JGroupsFileBroadcastEndpointFactory().setChannelName(jgroupsChannel).setFile(jgroupsFileName);
        }
        return null;
    }

    public Map<String, Object> overrideConnectionParameters(Map<String, Object> connectionParams, Map<String, Object> overrideConnectionParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (connectionParams != null) {
            map.putAll(connectionParams);
        }
        if (overrideConnectionParams != null) {
            for (Map.Entry<String, Object> stringObjectEntry : overrideConnectionParams.entrySet()) {
                map.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        return map;
    }

    private void setParams(ActiveMQConnectionFactory cf, ConnectionFactoryProperties overrideProperties) {
        String val5;
        Double val4;
        Long val3;
        Integer val2;
        Boolean val;
        Boolean bl = val = overrideProperties.isAutoGroup() != null ? overrideProperties.isAutoGroup() : this.raProperties.isAutoGroup();
        if (val != null) {
            cf.setAutoGroup(val.booleanValue());
        }
        Boolean bl2 = val = overrideProperties.isBlockOnAcknowledge() != null ? overrideProperties.isBlockOnAcknowledge() : this.raProperties.isBlockOnAcknowledge();
        if (val != null) {
            cf.setBlockOnAcknowledge(val.booleanValue());
        }
        Boolean bl3 = val = overrideProperties.isBlockOnNonDurableSend() != null ? overrideProperties.isBlockOnNonDurableSend() : this.raProperties.isBlockOnNonDurableSend();
        if (val != null) {
            cf.setBlockOnNonDurableSend(val.booleanValue());
        }
        Boolean bl4 = val = overrideProperties.isBlockOnDurableSend() != null ? overrideProperties.isBlockOnDurableSend() : this.raProperties.isBlockOnDurableSend();
        if (val != null) {
            cf.setBlockOnDurableSend(val.booleanValue());
        }
        Boolean bl5 = val = overrideProperties.isPreAcknowledge() != null ? overrideProperties.isPreAcknowledge() : this.raProperties.isPreAcknowledge();
        if (val != null) {
            cf.setPreAcknowledge(val.booleanValue());
        }
        Boolean bl6 = val = overrideProperties.isUseGlobalPools() != null ? overrideProperties.isUseGlobalPools() : this.raProperties.isUseGlobalPools();
        if (val != null) {
            cf.setUseGlobalPools(val.booleanValue());
        }
        Boolean bl7 = val = overrideProperties.isCacheLargeMessagesClient() != null ? overrideProperties.isCacheLargeMessagesClient() : this.raProperties.isCacheLargeMessagesClient();
        if (val != null) {
            cf.setCacheLargeMessagesClient(val.booleanValue());
        }
        Boolean bl8 = val = overrideProperties.isCompressLargeMessage() != null ? overrideProperties.isCompressLargeMessage() : this.raProperties.isCompressLargeMessage();
        if (val != null) {
            cf.setCompressLargeMessage(val.booleanValue());
        }
        Boolean bl9 = val = overrideProperties.isFailoverOnInitialConnection() != null ? overrideProperties.isFailoverOnInitialConnection() : this.raProperties.isFailoverOnInitialConnection();
        if (val != null) {
            cf.setFailoverOnInitialConnection(val.booleanValue());
        }
        Boolean bl10 = val = overrideProperties.isCacheDestinations() != null ? overrideProperties.isCacheDestinations() : this.raProperties.isCacheDestinations();
        if (val != null) {
            cf.setCacheDestinations(val.booleanValue());
        }
        Integer n = val2 = overrideProperties.getConsumerMaxRate() != null ? overrideProperties.getConsumerMaxRate() : this.raProperties.getConsumerMaxRate();
        if (val2 != null) {
            cf.setConsumerMaxRate(val2.intValue());
        }
        Integer n2 = val2 = overrideProperties.getConsumerWindowSize() != null ? overrideProperties.getConsumerWindowSize() : this.raProperties.getConsumerWindowSize();
        if (val2 != null) {
            cf.setConsumerWindowSize(val2.intValue());
        }
        Integer n3 = val2 = overrideProperties.getDupsOKBatchSize() != null ? overrideProperties.getDupsOKBatchSize() : this.raProperties.getDupsOKBatchSize();
        if (val2 != null) {
            cf.setDupsOKBatchSize(val2.intValue());
        }
        Integer n4 = val2 = overrideProperties.getMinLargeMessageSize() != null ? overrideProperties.getMinLargeMessageSize() : this.raProperties.getMinLargeMessageSize();
        if (val2 != null) {
            cf.setMinLargeMessageSize(val2.intValue());
        }
        Integer n5 = val2 = overrideProperties.getProducerMaxRate() != null ? overrideProperties.getProducerMaxRate() : this.raProperties.getProducerMaxRate();
        if (val2 != null) {
            cf.setProducerMaxRate(val2.intValue());
        }
        Integer n6 = val2 = overrideProperties.getProducerWindowSize() != null ? overrideProperties.getProducerWindowSize() : this.raProperties.getProducerWindowSize();
        if (val2 != null) {
            cf.setProducerWindowSize(val2.intValue());
        }
        Integer n7 = val2 = overrideProperties.getConfirmationWindowSize() != null ? overrideProperties.getConfirmationWindowSize() : this.raProperties.getConfirmationWindowSize();
        if (val2 != null) {
            cf.setConfirmationWindowSize(val2.intValue());
        }
        Integer n8 = val2 = overrideProperties.getReconnectAttempts() != null ? overrideProperties.getReconnectAttempts() : this.raProperties.getReconnectAttempts();
        if (val2 != null) {
            cf.setReconnectAttempts(val2.intValue());
        } else {
            cf.setReconnectAttempts(-1);
        }
        Integer n9 = val2 = overrideProperties.getThreadPoolMaxSize() != null ? overrideProperties.getThreadPoolMaxSize() : this.raProperties.getThreadPoolMaxSize();
        if (val2 != null) {
            cf.setThreadPoolMaxSize(val2.intValue());
        }
        Integer n10 = val2 = overrideProperties.getScheduledThreadPoolMaxSize() != null ? overrideProperties.getScheduledThreadPoolMaxSize() : this.raProperties.getScheduledThreadPoolMaxSize();
        if (val2 != null) {
            cf.setScheduledThreadPoolMaxSize(val2.intValue());
        }
        Integer n11 = val2 = overrideProperties.getTransactionBatchSize() != null ? overrideProperties.getTransactionBatchSize() : this.raProperties.getTransactionBatchSize();
        if (val2 != null) {
            cf.setTransactionBatchSize(val2.intValue());
        }
        Integer n12 = val2 = overrideProperties.getInitialConnectAttempts() != null ? overrideProperties.getInitialConnectAttempts() : this.raProperties.getInitialConnectAttempts();
        if (val2 != null) {
            cf.setInitialConnectAttempts(val2.intValue());
        }
        Integer n13 = val2 = overrideProperties.getInitialMessagePacketSize() != null ? overrideProperties.getInitialMessagePacketSize() : this.raProperties.getInitialMessagePacketSize();
        if (val2 != null) {
            cf.setInitialMessagePacketSize(val2.intValue());
        }
        Long l = val3 = overrideProperties.getClientFailureCheckPeriod() != null ? overrideProperties.getClientFailureCheckPeriod() : this.raProperties.getClientFailureCheckPeriod();
        if (val3 != null) {
            cf.setClientFailureCheckPeriod(val3.longValue());
        }
        Long l2 = val3 = overrideProperties.getCallTimeout() != null ? overrideProperties.getCallTimeout() : this.raProperties.getCallTimeout();
        if (val3 != null) {
            cf.setCallTimeout(val3.longValue());
        }
        Long l3 = val3 = overrideProperties.getCallFailoverTimeout() != null ? overrideProperties.getCallFailoverTimeout() : this.raProperties.getCallFailoverTimeout();
        if (val3 != null) {
            cf.setCallFailoverTimeout(val3.longValue());
        }
        Long l4 = val3 = overrideProperties.getConnectionTTL() != null ? overrideProperties.getConnectionTTL() : this.raProperties.getConnectionTTL();
        if (val3 != null) {
            cf.setConnectionTTL(val3.longValue());
        }
        Long l5 = val3 = overrideProperties.getRetryInterval() != null ? overrideProperties.getRetryInterval() : this.raProperties.getRetryInterval();
        if (val3 != null) {
            cf.setRetryInterval(val3.longValue());
        }
        Long l6 = val3 = overrideProperties.getMaxRetryInterval() != null ? overrideProperties.getMaxRetryInterval() : this.raProperties.getMaxRetryInterval();
        if (val3 != null) {
            cf.setMaxRetryInterval(val3.longValue());
        }
        Double d = val4 = overrideProperties.getRetryIntervalMultiplier() != null ? overrideProperties.getRetryIntervalMultiplier() : this.raProperties.getRetryIntervalMultiplier();
        if (val4 != null) {
            cf.setRetryIntervalMultiplier(val4.doubleValue());
        }
        String string = val5 = overrideProperties.getClientID() != null ? overrideProperties.getClientID() : this.raProperties.getClientID();
        if (val5 != null) {
            cf.setClientID(val5);
        }
        String string2 = val5 = overrideProperties.getConnectionLoadBalancingPolicyClassName() != null ? overrideProperties.getConnectionLoadBalancingPolicyClassName() : this.raProperties.getConnectionLoadBalancingPolicyClassName();
        if (val5 != null) {
            cf.setConnectionLoadBalancingPolicyClassName(val5);
        }
        String string3 = val5 = overrideProperties.getProtocolManagerFactoryStr() != null ? overrideProperties.getProtocolManagerFactoryStr() : this.raProperties.getProtocolManagerFactoryStr();
        if (val5 != null) {
            cf.setProtocolManagerFactoryStr(val5);
        }
        String string4 = val5 = overrideProperties.getDeserializationBlackList() != null ? overrideProperties.getDeserializationBlackList() : this.raProperties.getDeserializationBlackList();
        if (val5 != null) {
            cf.setDeserializationBlackList(val5);
        }
        String string5 = val5 = overrideProperties.getDeserializationWhiteList() != null ? overrideProperties.getDeserializationWhiteList() : this.raProperties.getDeserializationWhiteList();
        if (val5 != null) {
            cf.setDeserializationWhiteList(val5);
        }
        cf.setIgnoreJTA(this.isIgnoreJTA());
    }

    public void setManagedConnectionFactory(ActiveMQRAManagedConnectionFactory activeMQRAManagedConnectionFactory) {
        this.managedConnectionFactories.add(activeMQRAManagedConnectionFactory);
    }

    public String getCodec() {
        return this.raProperties.getCodec();
    }

    public synchronized void closeConnectionFactory(ConnectionFactoryProperties properties) {
        Pair<ActiveMQConnectionFactory, AtomicInteger> pair = this.knownConnectionFactories.get(properties);
        int references = ((AtomicInteger)pair.getB()).decrementAndGet();
        if (pair.getA() != null && pair.getA() != this.defaultActiveMQConnectionFactory && references == 0) {
            ((ActiveMQConnectionFactory)this.knownConnectionFactories.remove(properties).getA()).close();
        }
    }

    public boolean isIgnoreJTA() {
        return this.ignoreJTA;
    }

    public void setIgnoreJTA(boolean ignoreJTA) {
        this.ignoreJTA = ignoreJTA;
    }
}

