/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLRequestWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusDetailType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.w3c.dom.Element;

public class SAMLResponseWriter
extends BaseWriter {
    private final SAMLAssertionWriter assertionWriter;

    public SAMLResponseWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAMLAssertionWriter(writer);
    }

    public void write(ResponseType response) throws ProcessingException {
        Element sig;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.RESPONSE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        StatusType status = response.getStatus();
        this.write(status);
        List<ResponseType.RTChoiceType> choiceTypes = response.getAssertions();
        if (choiceTypes != null) {
            for (ResponseType.RTChoiceType choiceType : choiceTypes) {
                EncryptedAssertionType encryptedAssertion;
                AssertionType assertion = choiceType.getAssertion();
                if (assertion != null) {
                    this.assertionWriter.write(assertion);
                }
                if ((encryptedAssertion = choiceType.getEncryptedAssertion()) == null) continue;
                Element encElement = encryptedAssertion.getEncryptedElement();
                StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)encElement);
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(ArtifactResponseType response) throws ProcessingException {
        Object anyObj;
        StatusType status;
        Element sig;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.ARTIFACT_RESPONSE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement((XMLStreamWriter)this.writer, (Element)sig);
        }
        if ((status = response.getStatus()) != null) {
            this.write(status);
        }
        if ((anyObj = response.getAny()) instanceof AuthnRequestType) {
            AuthnRequestType authn = (AuthnRequestType)anyObj;
            SAMLRequestWriter requestWriter = new SAMLRequestWriter(this.writer);
            requestWriter.write(authn);
        } else if (anyObj instanceof ResponseType) {
            ResponseType rt = (ResponseType)anyObj;
            this.write(rt);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatusResponseType response, QName qname) throws ProcessingException {
        if (qname == null) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.STATUS_RESPONSE_TYPE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        } else {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)qname.getPrefix(), (String)qname.getLocalPart(), (String)qname.getNamespaceURI());
        }
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        StatusType status = response.getStatus();
        this.write(status);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatusType status) throws ProcessingException {
        StatusDetailType statusDetail;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.STATUS.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StatusCodeType statusCodeType = status.getStatusCode();
        this.write(statusCodeType);
        String statusMessage = status.getStatusMessage();
        if (StringUtil.isNotNull((String)statusMessage)) {
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.STATUS_MESSAGE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        if ((statusDetail = status.getStatusDetail()) != null) {
            this.write(statusDetail);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatusCodeType statusCodeType) throws ProcessingException {
        StatusCodeType subStatusCode;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.STATUS_CODE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        URI value = statusCodeType.getValue();
        if (value != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VALUE.get(), (String)value.toASCIIString());
        }
        if ((subStatusCode = statusCodeType.getStatusCode()) != null) {
            this.write(subStatusCode);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(StatusDetailType statusDetailType) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)PROTOCOL_PREFIX, (String)JBossSAMLConstants.STATUS_CODE.get(), (String)JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void writeBaseAttributes(StatusResponseType statusResponse) throws ProcessingException {
        String inResponseTo;
        String consent;
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ID.get(), (String)statusResponse.getID());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.VERSION.get(), (String)statusResponse.getVersion());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ISSUE_INSTANT.get(), (String)statusResponse.getIssueInstant().toString());
        String destination = statusResponse.getDestination();
        if (StringUtil.isNotNull((String)destination)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.DESTINATION.get(), (String)destination);
        }
        if (StringUtil.isNotNull((String)(consent = statusResponse.getConsent()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.CONSENT.get(), (String)consent);
        }
        if (StringUtil.isNotNull((String)(inResponseTo = statusResponse.getInResponseTo()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.IN_RESPONSE_TO.get(), (String)inResponseTo);
        }
    }
}

