/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;

public class InterceptorAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection<ComponentDescription> componentConfigurations = eeModuleDescription.getComponentDescriptions();
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (MetadataCompleteMarker.isMetadataComplete(deploymentUnit)) {
            return;
        }
        if (componentConfigurations == null || componentConfigurations.isEmpty()) {
            return;
        }
        for (ComponentDescription description : componentConfigurations) {
            this.processComponentConfig(applicationClasses, deploymentReflectionIndex, description, deploymentUnit);
        }
    }

    private void processComponentConfig(EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, ComponentDescription description, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        Class<?> componentClass;
        try {
            componentClass = ClassLoadingUtils.loadClass(description.getComponentClassName(), deploymentUnit);
        }
        catch (Throwable e) {
            return;
        }
        this.handleAnnotations(applicationClasses, deploymentReflectionIndex, componentClass, description);
    }

    private void handleAnnotations(EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, ComponentDescription description) {
        ArrayList heirachy = new ArrayList();
        for (Class<?> c = componentClass; c != Object.class && c != null; c = c.getSuperclass()) {
            heirachy.add(c);
        }
        Collections.reverse(heirachy);
        RuntimeAnnotationInformation excludeDefaultInterceptors = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, applicationClasses, deploymentReflectionIndex, ExcludeDefaultInterceptors.class);
        if (excludeDefaultInterceptors.getClassAnnotations().containsKey(componentClass.getName())) {
            description.setExcludeDefaultInterceptors(true);
        }
        for (Map.Entry entry : excludeDefaultInterceptors.getMethodAnnotations().entrySet()) {
            description.excludeDefaultInterceptors(MethodIdentifier.getIdentifierForMethod((Method)entry.getKey()));
        }
        RuntimeAnnotationInformation excludeClassInterceptors = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, applicationClasses, deploymentReflectionIndex, ExcludeClassInterceptors.class);
        for (Map.Entry entry : excludeClassInterceptors.getMethodAnnotations().entrySet()) {
            description.excludeClassInterceptors(MethodIdentifier.getIdentifierForMethod((Method)entry.getKey()));
        }
        RuntimeAnnotationInformation runtimeAnnotationInformation = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, applicationClasses, deploymentReflectionIndex, Interceptors.class);
        for (Class clazz : heirachy) {
            List classInterceptors = runtimeAnnotationInformation.getClassAnnotations().get(clazz.getName());
            if (classInterceptors == null) continue;
            for (String interceptor : (String[])classInterceptors.get(0)) {
                description.addClassInterceptor(new InterceptorDescription(interceptor));
            }
        }
        for (Map.Entry entry : runtimeAnnotationInformation.getMethodAnnotations().entrySet()) {
            MethodIdentifier method = MethodIdentifier.getIdentifierForMethod((Method)entry.getKey());
            for (String interceptor : (String[])entry.getValue().get(0)) {
                description.addMethodInterceptor(method, new InterceptorDescription(interceptor));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

