/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.transport.EmptyFrame;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.Ref;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;

class FrameWriter {
    static final byte AMQP_FRAME_TYPE = 0;
    static final byte SASL_FRAME_TYPE = 1;
    private EncoderImpl _encoder;
    private ByteBuffer _bbuf;
    private WritableBuffer _buffer;
    private int _maxFrameSize;
    private byte _frameType;
    private final Ref<ProtocolTracer> _protocolTracer;
    private TransportImpl _transport;
    private int _frameStart = 0;
    private int _payloadStart;
    private int _performativeSize;
    private long _framesOutput = 0L;

    FrameWriter(EncoderImpl encoder, int maxFrameSize, byte frameType, Ref<ProtocolTracer> protocolTracer, TransportImpl transport) {
        this._encoder = encoder;
        this._bbuf = ByteBuffer.allocate(1024);
        this._buffer = new WritableBuffer.ByteBufferWrapper(this._bbuf);
        this._encoder.setByteBuffer(this._buffer);
        this._maxFrameSize = maxFrameSize;
        this._frameType = frameType;
        this._protocolTracer = protocolTracer;
        this._transport = transport;
    }

    void setMaxFrameSize(int maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    private void grow() {
        this.grow(this._bbuf.capacity());
    }

    private void grow(int amount) {
        ByteBuffer old = this._bbuf;
        this._bbuf = ByteBuffer.allocate(old.capacity() + amount);
        this._buffer = new WritableBuffer.ByteBufferWrapper(this._bbuf);
        old.flip();
        this._bbuf.put(old);
        this._encoder.setByteBuffer(this._buffer);
    }

    void writeHeader(byte[] header) {
        this._buffer.put(header, 0, header.length);
    }

    private void startFrame() {
        this._frameStart = this._buffer.position();
    }

    private void writePerformative(Object frameBody, ReadableBuffer payload, Runnable onPayloadTooLarge) {
        while (this._buffer.remaining() < 8) {
            this.grow();
        }
        block3: while (true) {
            try {
                while (true) {
                    this._buffer.position(this._frameStart + 8);
                    if (frameBody != null) {
                        this._encoder.writeObject(frameBody);
                    }
                    this._payloadStart = this._buffer.position();
                    this._performativeSize = this._payloadStart - this._frameStart;
                    if (onPayloadTooLarge == null || this._maxFrameSize <= 0 || payload == null || payload.remaining() + this._performativeSize <= this._maxFrameSize) break block3;
                    onPayloadTooLarge.run();
                    onPayloadTooLarge = null;
                }
            }
            catch (BufferOverflowException e) {
                this.grow();
                continue;
            }
            break;
        }
    }

    private void endFrame(int channel) {
        int frameSize = this._buffer.position() - this._frameStart;
        int limit = this._buffer.position();
        this._buffer.position(this._frameStart);
        this._buffer.putInt(frameSize);
        this._buffer.put((byte)2);
        this._buffer.put(this._frameType);
        this._buffer.putShort((short)channel);
        this._buffer.position(limit);
    }

    void writeFrame(int channel, Object frameBody, ReadableBuffer payload, Runnable onPayloadTooLarge) {
        ProtocolTracer tracer;
        this.startFrame();
        this.writePerformative(frameBody, payload, onPayloadTooLarge);
        int capacity = this._maxFrameSize > 0 ? this._maxFrameSize - this._performativeSize : Integer.MAX_VALUE;
        int payloadSize = Math.min(payload == null ? 0 : payload.remaining(), capacity);
        ProtocolTracer protocolTracer = tracer = this._protocolTracer == null ? null : this._protocolTracer.get();
        if (tracer != null || this._transport.isTraceFramesEnabled()) {
            this.logFrame(tracer, channel, frameBody, payload, payloadSize);
        }
        if (payloadSize > 0) {
            while (this._buffer.remaining() < payloadSize) {
                this.grow(payloadSize - this._buffer.remaining());
            }
            int oldLimit = payload.limit();
            payload.limit(payload.position() + payloadSize);
            this._buffer.put(payload);
            payload.limit(oldLimit);
        }
        this.endFrame(channel);
        ++this._framesOutput;
    }

    private void logFrame(ProtocolTracer tracer, int channel, Object frameBody, ReadableBuffer payload, int payloadSize) {
        if (this._frameType == 0) {
            ReadableBuffer originalPayload = null;
            if (payload != null) {
                originalPayload = payload.slice();
                originalPayload.limit(payloadSize);
            }
            Binary payloadBin = Binary.create(originalPayload);
            FrameBody body = null;
            body = frameBody == null ? EmptyFrame.INSTANCE : (FrameBody)frameBody;
            TransportFrame frame = new TransportFrame(channel, body, payloadBin);
            this._transport.log(TransportImpl.OUTGOING, frame);
            if (tracer != null) {
                tracer.sentFrame(frame);
            }
        }
    }

    void writeFrame(Object frameBody) {
        this.writeFrame(0, frameBody, null, null);
    }

    boolean isFull() {
        return this._bbuf.position() > 65536;
    }

    int readBytes(ByteBuffer dst) {
        ByteBuffer src = this._bbuf.duplicate();
        src.flip();
        int size = Math.min(src.remaining(), dst.remaining());
        int limit = src.limit();
        src.limit(size);
        dst.put(src);
        src.limit(limit);
        this._bbuf.rewind();
        this._bbuf.put(src);
        return size;
    }

    long getFramesOutput() {
        return this._framesOutput;
    }
}

